/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    protected int a;
    protected int b;
    protected int c;
    protected char d;
    protected int e;
    protected int f;
    protected char[] g;
    protected int h;
    protected int i;
    protected boolean j;
    protected Calendar k = null;
    protected TimeZone l = JSON.defaultTimeZone;
    protected Locale m = JSON.defaultLocale;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> r;
    protected String n = null;
    protected int o = 0;
    protected static final char[] p;
    protected static final int[] q;

    protected void a(String string, Object ... objectArray) {
        this.a = 1;
    }

    public JSONLexerBase(int n2) {
        this.c = n2;
        if ((n2 & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.n = "";
        }
        this.g = r.get();
        if (this.g == null) {
            this.g = new char[512];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n2) {
        this.a = n2;
    }

    @Override
    public final void nextToken() {
        block28: {
            this.h = 0;
            block19: while (true) {
                this.b = this.e;
                if (this.d == '/') {
                    this.a();
                    continue;
                }
                if (this.d == '\"') {
                    this.scanString();
                    return;
                }
                if (this.d == ',') {
                    this.next();
                    this.a = 16;
                    return;
                }
                if (this.d >= '0' && this.d <= '9') {
                    this.scanNumber();
                    return;
                }
                if (this.d == '-') {
                    this.scanNumber();
                    return;
                }
                switch (this.d) {
                    case '\'': {
                        if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                            throw new JSONException("Feature.AllowSingleQuotes is false");
                        }
                        this.b();
                        return;
                    }
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        this.next();
                        continue block19;
                    }
                    case 't': {
                        this.scanTrue();
                        return;
                    }
                    case 'f': {
                        this.scanFalse();
                        return;
                    }
                    case 'n': {
                        this.scanNullOrNew();
                        return;
                    }
                    case 'N': 
                    case 'S': 
                    case 'T': 
                    case 'u': {
                        this.scanIdent();
                        return;
                    }
                    case '(': {
                        this.next();
                        this.a = 10;
                        return;
                    }
                    case ')': {
                        this.next();
                        this.a = 11;
                        return;
                    }
                    case '[': {
                        this.next();
                        this.a = 14;
                        return;
                    }
                    case ']': {
                        this.next();
                        this.a = 15;
                        return;
                    }
                    case '{': {
                        this.next();
                        this.a = 12;
                        return;
                    }
                    case '}': {
                        this.next();
                        this.a = 13;
                        return;
                    }
                    case ':': {
                        this.next();
                        this.a = 17;
                        return;
                    }
                    case ';': {
                        this.next();
                        this.a = 24;
                        return;
                    }
                    case '.': {
                        this.next();
                        this.a = 25;
                        return;
                    }
                    case '+': {
                        this.next();
                        this.scanNumber();
                        return;
                    }
                    case 'x': {
                        this.scanHex();
                        return;
                    }
                }
                if (this.isEOF()) {
                    if (this.a == 20) {
                        throw new JSONException("EOF error");
                    }
                    this.a = 20;
                    this.f = this.b = this.e;
                    break block28;
                }
                if (this.d > '\u001f' && this.d != '\u007f') break;
                this.next();
            }
            this.a("illegal.char", String.valueOf((int)this.d));
            this.next();
        }
    }

    @Override
    public final void nextToken(int n2) {
        this.h = 0;
        while (true) {
            switch (n2) {
                case 12: {
                    if (this.d == '{') {
                        this.a = 12;
                        this.next();
                        return;
                    }
                    if (this.d != '[') break;
                    this.a = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.d == ',') {
                        this.a = 16;
                        this.next();
                        return;
                    }
                    if (this.d == '}') {
                        this.a = 13;
                        this.next();
                        return;
                    }
                    if (this.d == ']') {
                        this.a = 15;
                        this.next();
                        return;
                    }
                    if (this.d == '\u001a') {
                        this.a = 20;
                        return;
                    }
                    if (this.d != 'n') break;
                    this.scanNullOrNew(false);
                    return;
                }
                case 2: {
                    if (this.d >= '0' && this.d <= '9') {
                        this.b = this.e;
                        this.scanNumber();
                        return;
                    }
                    if (this.d == '\"') {
                        this.b = this.e;
                        this.scanString();
                        return;
                    }
                    if (this.d == '[') {
                        this.a = 14;
                        this.next();
                        return;
                    }
                    if (this.d != '{') break;
                    this.a = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.d == '\"') {
                        this.b = this.e;
                        this.scanString();
                        return;
                    }
                    if (this.d >= '0' && this.d <= '9') {
                        this.b = this.e;
                        this.scanNumber();
                        return;
                    }
                    if (this.d == '[') {
                        this.a = 14;
                        this.next();
                        return;
                    }
                    if (this.d != '{') break;
                    this.a = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.d == '[') {
                        this.a = 14;
                        this.next();
                        return;
                    }
                    if (this.d != '{') break;
                    this.a = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.d == ']') {
                        this.a = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.d != '\u001a') break;
                    this.a = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.d != ' ' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\f' && this.d != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.d)) {
            this.next();
        }
        if (this.d == '_' || this.d == '$' || Character.isLetter(this.d)) {
            this.scanIdent();
        } else {
            this.nextToken();
        }
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c2) {
        this.h = 0;
        while (true) {
            if (this.d == c2) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.d != ' ' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\f' && this.d != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + c2 + " - " + this.d + ", info : " + this.info());
    }

    @Override
    public final int token() {
        return this.a;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.a);
    }

    @Override
    public final int pos() {
        return this.b;
    }

    public final String stringDefaultValue() {
        return this.n;
    }

    @Override
    public final Number integerValue() {
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.i == -1) {
            this.i = 0;
        }
        int n3 = this.i;
        int n4 = this.i + this.h;
        int n5 = 32;
        switch (this.charAt(n4 - 1)) {
            case 'L': {
                --n4;
                n5 = 76;
                break;
            }
            case 'S': {
                --n4;
                n5 = 83;
                break;
            }
            case 'B': {
                --n4;
                n5 = 66;
                break;
            }
        }
        if (this.charAt(this.i) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        long l4 = -922337203685477580L;
        if (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            l3 = -n2;
        }
        while (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            if (l3 < l4) {
                return new BigInteger(this.numberString(), 10);
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                return new BigInteger(this.numberString(), 10);
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.i + 1) {
                if (l3 >= Integer.MIN_VALUE && n5 != 76) {
                    if (n5 == 83) {
                        return (short)l3;
                    }
                    if (n5 == 66) {
                        return (byte)l3;
                    }
                    return (int)l3;
                }
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l3 = -l3) <= Integer.MAX_VALUE && n5 != 76) {
            if (n5 == 83) {
                return (short)l3;
            }
            if (n5 == 66) {
                return (byte)l3;
            }
            return (int)l3;
        }
        return l3;
    }

    @Override
    public final void nextTokenWithColon(int n2) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c2;
        String string = this.numberString();
        float f2 = Float.parseFloat(string);
        if ((f2 == 0.0f || f2 == Float.POSITIVE_INFINITY) && (c2 = string.charAt(0)) > '0' && c2 <= '9') {
            throw new JSONException("float overflow : " + string);
        }
        return f2;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void config(Feature feature, boolean bl) {
        this.c = Feature.config(this.c, feature, bl);
        if ((this.c & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.n = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n2) {
        return (this.c & n2) != 0;
    }

    public final boolean isEnabled(int n2, int n3) {
        return (this.c & n3) != 0 || (n2 & n3) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.d;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    protected void a() {
        this.next();
        if (this.d == '/') {
            do {
                this.next();
                if (this.d != '\n') continue;
                this.next();
                return;
            } while (this.d != '\u001a');
            return;
        }
        if (this.d == '*') {
            this.next();
            while (this.d != '\u001a') {
                if (this.d == '*') {
                    this.next();
                    if (this.d != '/') continue;
                    this.next();
                    return;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.d == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.d == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.d == '}') {
            this.next();
            this.a = 13;
            return null;
        }
        if (this.d == ',') {
            this.next();
            this.a = 16;
            return null;
        }
        if (this.d == '\u001a') {
            this.a = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    protected abstract void a(int var1, char[] var2, int var3, int var4);

    @Override
    public final String scanSymbol(SymbolTable symbolTable, char c2) {
        String string;
        char c3;
        int n2 = 0;
        this.i = this.e;
        this.h = 0;
        boolean bl = false;
        block22: while ((c3 = this.next()) != c2) {
            if (c3 == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (c3 == '\\') {
                int n3;
                if (!bl) {
                    bl = true;
                    if (this.h >= this.g.length) {
                        n3 = this.g.length * 2;
                        if (this.h > n3) {
                            n3 = this.h;
                        }
                        char[] cArray = new char[n3];
                        System.arraycopy(this.g, 0, cArray, 0, this.g.length);
                        this.g = cArray;
                    }
                    this.a(this.i + 1, this.g, 0, this.h);
                }
                c3 = this.next();
                switch (c3) {
                    case '0': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0000');
                        continue block22;
                    }
                    case '1': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0001');
                        continue block22;
                    }
                    case '2': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0002');
                        continue block22;
                    }
                    case '3': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0003');
                        continue block22;
                    }
                    case '4': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0004');
                        continue block22;
                    }
                    case '5': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0005');
                        continue block22;
                    }
                    case '6': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0006');
                        continue block22;
                    }
                    case '7': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        n2 = 31 * n2 + 8;
                        this.a('\b');
                        continue block22;
                    }
                    case 't': {
                        n2 = 31 * n2 + 9;
                        this.a('\t');
                        continue block22;
                    }
                    case 'n': {
                        n2 = 31 * n2 + 10;
                        this.a('\n');
                        continue block22;
                    }
                    case 'v': {
                        n2 = 31 * n2 + 11;
                        this.a('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        n2 = 31 * n2 + 12;
                        this.a('\f');
                        continue block22;
                    }
                    case 'r': {
                        n2 = 31 * n2 + 13;
                        this.a('\r');
                        continue block22;
                    }
                    case '\"': {
                        n2 = 31 * n2 + 34;
                        this.a('\"');
                        continue block22;
                    }
                    case '\'': {
                        n2 = 31 * n2 + 39;
                        this.a('\'');
                        continue block22;
                    }
                    case '/': {
                        n2 = 31 * n2 + 47;
                        this.a('/');
                        continue block22;
                    }
                    case '\\': {
                        n2 = 31 * n2 + 92;
                        this.a('\\');
                        continue block22;
                    }
                    case 'x': {
                        n3 = this.d = this.next();
                        char c4 = this.d = this.next();
                        int n4 = q[n3] * 16 + q[c4];
                        char c5 = (char)n4;
                        n2 = 31 * n2 + c5;
                        this.a(c5);
                        continue block22;
                    }
                    case 'u': {
                        char c6 = c3 = this.next();
                        char c7 = c3 = this.next();
                        char c8 = c3 = this.next();
                        char c9 = c3 = this.next();
                        int n5 = Integer.parseInt(new String(new char[]{c6, c7, c8, c9}), 16);
                        n2 = 31 * n2 + n5;
                        this.a((char)n5);
                        continue block22;
                    }
                }
                this.d = c3;
                throw new JSONException("unclosed.str.lit");
            }
            n2 = 31 * n2 + c3;
            if (!bl) {
                ++this.h;
                continue;
            }
            if (this.h == this.g.length) {
                this.a(c3);
                continue;
            }
            this.g[this.h++] = c3;
        }
        this.a = 4;
        if (!bl) {
            int n6 = this.i == -1 ? 0 : this.i + 1;
            string = this.addSymbol(n6, this.h, n2, symbolTable);
        } else {
            string = symbolTable.addSymbol(this.g, 0, this.h, n2);
        }
        this.h = 0;
        this.next();
        return string;
    }

    @Override
    public final void resetStringPosition() {
        this.h = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char c2;
        boolean bl;
        if (this.a == 1 && this.b == 0 && this.e == 1) {
            this.e = 0;
        }
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        int n2 = this.d;
        boolean bl2 = bl = this.d >= blArray.length || blArray[n2];
        if (!bl) {
            throw new JSONException("illegal identifier : " + this.d + this.info());
        }
        boolean[] blArray2 = IOUtils.identifierFlags;
        int n3 = n2;
        this.i = this.e;
        this.h = 1;
        while ((c2 = this.next()) >= blArray2.length || blArray2[c2]) {
            n3 = 31 * n3 + c2;
            ++this.h;
        }
        this.d = this.charAt(this.e);
        this.a = 18;
        int n4 = 3392903;
        if (this.h == 4 && n3 == 3392903 && this.charAt(this.i) == 'n' && this.charAt(this.i + 1) == 'u' && this.charAt(this.i + 2) == 'l' && this.charAt(this.i + 3) == 'l') {
            return null;
        }
        if (symbolTable == null) {
            return this.subString(this.i, this.h);
        }
        return this.addSymbol(this.i, this.h, n3, symbolTable);
    }

    protected abstract void a(int var1, int var2, char[] var3);

    @Override
    public final void scanString() {
        char c2;
        this.i = this.e;
        this.j = false;
        block22: while ((c2 = this.next()) != '\"') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.a('\u001a');
                    continue;
                }
                throw new JSONException("unclosed string : " + c2);
            }
            if (c2 == '\\') {
                char c3;
                if (!this.j) {
                    this.j = true;
                    if (this.h >= this.g.length) {
                        c3 = this.g.length * 2;
                        if (this.h > c3) {
                            c3 = this.h;
                        }
                        char[] cArray = new char[c3];
                        System.arraycopy(this.g, 0, cArray, 0, this.g.length);
                        this.g = cArray;
                    }
                    this.a(this.i + 1, this.h, this.g);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.a('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.a('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.a('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.a('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.a('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.a('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.a('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.a('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.a('\b');
                        continue block22;
                    }
                    case 't': {
                        this.a('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.a('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.a('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.a('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.a('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.a('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.a('\'');
                        continue block22;
                    }
                    case '/': {
                        this.a('/');
                        continue block22;
                    }
                    case '\\': {
                        this.a('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        c3 = this.next();
                        char c4 = this.next();
                        boolean bl2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                        boolean bl3 = bl = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c3 + c4);
                        }
                        char c5 = (char)(q[c3] * 16 + q[c4]);
                        this.a(c5);
                        continue block22;
                    }
                    case 'u': {
                        char c6 = this.next();
                        char c7 = this.next();
                        char c8 = this.next();
                        char c9 = this.next();
                        int n2 = Integer.parseInt(new String(new char[]{c6, c7, c8, c9}), 16);
                        this.a((char)n2);
                        continue block22;
                    }
                }
                this.d = c2;
                throw new JSONException("unclosed string : " + c2);
            }
            if (!this.j) {
                ++this.h;
                continue;
            }
            if (this.h == this.g.length) {
                this.a(c2);
                continue;
            }
            this.g[this.h++] = c2;
        }
        this.a = 4;
        this.d = this.next();
    }

    public Calendar getCalendar() {
        return this.k;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.l;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.l = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.m;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m = locale;
    }

    @Override
    public final int intValue() {
        char c2;
        int n2;
        int n3;
        if (this.i == -1) {
            this.i = 0;
        }
        int n4 = 0;
        boolean bl = false;
        int n5 = this.i;
        int n6 = this.i + this.h;
        if (this.charAt(this.i) == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n5;
        } else {
            n3 = -2147483647;
        }
        long l2 = -214748364L;
        if (n5 < n6) {
            n2 = this.charAt(n5++) - 48;
            n4 = -n2;
        }
        while (n5 < n6 && (c2 = this.charAt(n5++)) != 'L' && c2 != 'S' && c2 != 'B') {
            n2 = c2 - 48;
            if ((long)n4 < l2) {
                throw new NumberFormatException(this.numberString());
            }
            if ((n4 *= 10) < n3 + n2) {
                throw new NumberFormatException(this.numberString());
            }
            n4 -= n2;
        }
        if (bl) {
            if (n5 > this.i + 1) {
                return n4;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n4;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.g.length <= 8192) {
            r.set(this.g);
        }
        this.g = null;
    }

    @Override
    public final boolean isRef() {
        if (this.h != 4) {
            return false;
        }
        return this.charAt(this.i + 1) == '$' && this.charAt(this.i + 2) == 'r' && this.charAt(this.i + 3) == 'e' && this.charAt(this.i + 4) == 'f';
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        if (!this.charArrayCompare(p)) {
            return -2;
        }
        int n2 = this.e + p.length;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) == this.charAt(n2 + i2)) continue;
            return -1;
        }
        if (this.charAt(n2 += n3) != '\"') {
            return -1;
        }
        this.d = this.charAt(++n2);
        if (this.d == ',') {
            this.d = this.charAt(++n2);
            this.e = n2;
            this.a = 16;
            return 3;
        }
        if (this.d == '}') {
            this.d = this.charAt(++n2);
            if (this.d == ',') {
                this.a = 16;
                this.d = this.charAt(++n2);
            } else if (this.d == ']') {
                this.a = 15;
                this.d = this.charAt(++n2);
            } else if (this.d == '}') {
                this.a = 13;
                this.d = this.charAt(++n2);
            } else if (this.d == '\u001a') {
                this.a = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.e = n2;
        return this.matchStat;
    }

    public final boolean matchField(char[] cArray) {
        while (!this.charArrayCompare(cArray)) {
            if (JSONLexerBase.isWhitespace(this.d)) {
                this.next();
                continue;
            }
            return false;
        }
        this.e += cArray.length;
        this.d = this.charAt(this.e);
        if (this.d == '{') {
            this.next();
            this.a = 12;
        } else if (this.d == '[') {
            this.next();
            this.a = 14;
        } else if (this.d == 'S' && this.charAt(this.e + 1) == 'e' && this.charAt(this.e + 2) == 't' && this.charAt(this.e + 3) == '[') {
            this.e += 3;
            this.d = this.charAt(this.e);
            this.a = 21;
        } else {
            this.nextToken();
        }
        return true;
    }

    public int matchField(long l2) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n2) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l2, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l2) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] cArray) {
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int n2 = cArray.length;
        if ((c2 = this.charAt(this.e + n2++)) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        int n3 = this.e + cArray.length + 1;
        int n4 = this.indexOf('\"', n3);
        if (n4 == -1) {
            throw new JSONException("unclosed str");
        }
        int n5 = this.e + cArray.length + 1;
        String string = this.subString(n5, n4 - n5);
        if (string.indexOf(92) != -1) {
            while (true) {
                int n6 = 0;
                for (int i2 = n4 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                }
                if (n6 % 2 == 0) {
                    n6 = n4 - (this.e + cArray.length + 1);
                    char[] cArray2 = this.sub_chars(this.e + cArray.length + 1, n6);
                    string = JSONLexerBase.readString(cArray2, n6);
                    break;
                }
                n4 = this.indexOf('\"', n4 + 1);
            }
        }
        n2 += n4 - (this.e + cArray.length + 1) + 1;
        c2 = this.charAt(this.e + n2++);
        String string2 = string;
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return string2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public String scanString(char c2) {
        String string;
        char c3;
        int n2;
        block13: {
            this.matchStat = 0;
            n2 = 0;
            if ((c3 = this.charAt(this.e + n2++)) == 'n') {
                if (this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                    n2 += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                c3 = this.charAt(this.e + n2++);
                if (c3 == c2) {
                    this.e += n2;
                    this.d = this.charAt(this.e);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            while (true) {
                if (c3 == '\"') {
                    int n3 = this.e + n2;
                    int n4 = this.indexOf('\"', n3);
                    if (n4 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    string = this.subString(this.e + n2, n4 - n3);
                    if (string.indexOf(92) != -1) {
                        int n5;
                        while (true) {
                            n5 = 0;
                            for (int i2 = n4 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                                ++n5;
                            }
                            if (n5 % 2 == 0) break;
                            n4 = this.indexOf('\"', n4 + 1);
                        }
                        n5 = n4 - n3;
                        char[] cArray = this.sub_chars(this.e + 1, n5);
                        string = JSONLexerBase.readString(cArray, n5);
                    }
                    n2 += n4 - n3 + 1;
                    break block13;
                }
                if (!JSONLexerBase.isWhitespace(c3)) break;
                c3 = this.charAt(this.e + n2++);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        c3 = this.charAt(this.e + n2++);
        String string2 = string;
        while (true) {
            if (c3 == c2) {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return string2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.e + n2++);
        }
        if (c3 == ']') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = -1;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(char[] cArray) {
        long l2;
        char c2;
        int n2;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n2 = cArray.length;
                if ((c2 = this.charAt(this.e + n2++)) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    if ((c2 = this.charAt(this.e + n2++)) == '\"') {
                        if ((c2 = this.charAt(this.e + n2++)) != ',') break block12;
                        break block13;
                    }
                    l2 ^= (long)c2;
                    l2 *= 1099511628211L;
                } while (c2 != '\\');
                this.matchStat = -1;
                return 0L;
            }
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return l2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanEnumSymbol(char[] cArray) {
        long l2;
        int n2;
        int n3;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n3 = cArray.length;
                if ((n2 = this.charAt(this.e + n3++)) != 34) {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    if ((n2 = this.charAt(this.e + n3++)) == 34) {
                        if ((n2 = this.charAt(this.e + n3++)) != 44) break block12;
                        break block13;
                    }
                    l2 ^= (long)(n2 >= 65 && n2 <= 90 ? n2 + 32 : n2);
                    l2 *= 1099511628211L;
                } while (n2 != 92);
                this.matchStat = -1;
                return 0L;
            }
            this.e += n3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return l2;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return 0L;
        }
        if ((n2 = (int)this.charAt(this.e + n3++)) == 44) {
            this.a = 16;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (n2 == 93) {
            this.a = 15;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (n2 == 125) {
            this.a = 13;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.a = 20;
            this.e += n3 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable symbolTable, char c2) {
        String string = this.scanSymbolWithSeperator(symbolTable, c2);
        if (string == null) {
            return null;
        }
        return Enum.valueOf(clazz, string);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable symbolTable, char c2) {
        int n2;
        char c3;
        int n3;
        block8: {
            this.matchStat = 0;
            n3 = 0;
            if ((c3 = this.charAt(this.e + n3++)) == 'n') {
                if (this.charAt(this.e + n3) == 'u' && this.charAt(this.e + n3 + 1) == 'l' && this.charAt(this.e + n3 + 2) == 'l') {
                    n3 += 3;
                } else {
                    this.matchStat = -1;
                    return null;
                }
                c3 = this.charAt(this.e + n3++);
                if (c3 == c2) {
                    this.e += n3;
                    this.d = this.charAt(this.e);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (c3 != '\"') {
                this.matchStat = -1;
                return null;
            }
            n2 = 0;
            do {
                if ((c3 = this.charAt(this.e + n3++)) == '\"') break block8;
                n2 = 31 * n2 + c3;
            } while (c3 != '\\');
            this.matchStat = -1;
            return null;
        }
        int n4 = this.e + 0 + 1;
        int n5 = this.e + n3 - n4 - 1;
        String string = this.addSymbol(n4, n5, n2, symbolTable);
        c3 = this.charAt(this.e + n3++);
        while (true) {
            if (c3 == c2) {
                this.e += n3;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                return string;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.e + n3++);
        }
        this.matchStat = -1;
        return string;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> clazz) {
        char c2;
        int n2;
        Collection<String> collection;
        block19: {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            collection = this.newCollectionByType(clazz);
            n2 = cArray.length;
            if ((c2 = this.charAt(this.e + n2++)) != '[') {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.e + n2++);
            while (true) {
                block23: {
                    String string;
                    int n3;
                    block21: {
                        block22: {
                            block20: {
                                if (c2 != '\"') break block20;
                                int n4 = this.e + n2;
                                n3 = this.indexOf('\"', n4);
                                if (n3 == -1) {
                                    throw new JSONException("unclosed str");
                                }
                                int n5 = this.e + n2;
                                string = this.subString(n5, n3 - n5);
                                if (string.indexOf(92) == -1) break block21;
                                break block22;
                            }
                            if (c2 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                                n2 += 3;
                                c2 = this.charAt(this.e + n2++);
                                collection.add(null);
                                break block23;
                            } else {
                                if (c2 != ']') throw new JSONException("illega str");
                                if (collection.size() != 0) throw new JSONException("illega str");
                                c2 = this.charAt(this.e + n2++);
                                break block19;
                            }
                        }
                        while (true) {
                            int n6 = 0;
                            for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                            }
                            if (n6 % 2 == 0) {
                                n6 = n3 - (this.e + n2);
                                char[] cArray2 = this.sub_chars(this.e + n2, n6);
                                string = JSONLexerBase.readString(cArray2, n6);
                                break;
                            }
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                    }
                    n2 += n3 - (this.e + n2) + 1;
                    c2 = this.charAt(this.e + n2++);
                    collection.add(string);
                }
                if (c2 != ',') break;
                c2 = this.charAt(this.e + n2++);
            }
            if (c2 != ']') {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.e + n2++);
        }
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return collection;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.e += n2 - 1;
            this.a = 20;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return collection;
    }

    @Override
    public void scanStringArray(Collection<String> collection, char c2) {
        char c3;
        int n2;
        block14: {
            this.matchStat = 0;
            n2 = 0;
            if ((c3 = this.charAt(this.e + n2++)) == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l' && this.charAt(this.e + n2 + 3) == c2) {
                this.e += 5;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                return;
            }
            if (c3 != '[') {
                this.matchStat = -1;
                return;
            }
            c3 = this.charAt(this.e + n2++);
            while (true) {
                if (c3 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                    n2 += 3;
                    c3 = this.charAt(this.e + n2++);
                    collection.add(null);
                } else {
                    if (c3 == ']' && collection.size() == 0) {
                        c3 = this.charAt(this.e + n2++);
                        break block14;
                    }
                    if (c3 != '\"') {
                        this.matchStat = -1;
                        return;
                    }
                    int n3 = this.e + n2;
                    int n4 = this.indexOf('\"', n3);
                    if (n4 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    String string = this.subString(this.e + n2, n4 - n3);
                    if (string.indexOf(92) != -1) {
                        int n5;
                        while (true) {
                            n5 = 0;
                            for (int i2 = n4 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                                ++n5;
                            }
                            if (n5 % 2 == 0) break;
                            n4 = this.indexOf('\"', n4 + 1);
                        }
                        n5 = n4 - n3;
                        char[] cArray = this.sub_chars(this.e + n2, n5);
                        string = JSONLexerBase.readString(cArray, n5);
                    }
                    n2 += n4 - (this.e + n2) + 1;
                    c3 = this.charAt(this.e + n2++);
                    collection.add(string);
                }
                if (c3 != ',') break;
                c3 = this.charAt(this.e + n2++);
            }
            if (c3 == ']') {
                c3 = this.charAt(this.e + n2++);
            } else {
                this.matchStat = -1;
                return;
            }
        }
        if (c3 == c2) {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return;
        }
        this.matchStat = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] cArray) {
        int n2;
        int n3;
        char c2;
        boolean bl;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0;
        }
        int n4 = cArray.length;
        boolean bl2 = bl = (c2 = this.charAt(this.e + n4++)) == '-';
        if (bl) {
            c2 = this.charAt(this.e + n4++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n3 = c2 - 48;
            while ((c2 = this.charAt(this.e + n4++)) >= '0' && c2 <= '9') {
                n3 = n3 * 10 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (!(n3 >= 0 && n4 <= 14 + cArray.length || n3 == Integer.MIN_VALUE && n4 == 17 && bl)) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (c2 == ',') {
            int n5;
            this.e += n4;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            if (bl) {
                n5 = -n3;
                return n5;
            }
            n5 = n3;
            return n5;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0;
        }
        if ((c2 = this.charAt(this.e + n4++)) == ',') {
            this.a = 16;
            this.e += n4;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n4;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n4;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.a = 20;
            this.e += n4 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            n2 = n3;
            return n2;
        }
        n2 = -n3;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(char[] cArray) {
        int n2;
        int[] nArray;
        char c2;
        int n3;
        block20: {
            block19: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return null;
                }
                n3 = cArray.length;
                if ((c2 = this.charAt(this.e + n3++)) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                c2 = this.charAt(this.e + n3++);
                nArray = new int[16];
                n2 = 0;
                if (c2 == ']') {
                    c2 = this.charAt(this.e + n3++);
                } else {
                    while (true) {
                        boolean bl = false;
                        if (c2 == '-') {
                            c2 = this.charAt(this.e + n3++);
                            bl = true;
                        }
                        if (c2 < '0' || c2 > '9') break block19;
                        int n4 = c2 - 48;
                        while ((c2 = this.charAt(this.e + n3++)) >= '0' && c2 <= '9') {
                            n4 = n4 * 10 + (c2 - 48);
                        }
                        if (n2 >= nArray.length) {
                            int[] nArray2 = new int[nArray.length * 3 / 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n2);
                            nArray = nArray2;
                        }
                        int n5 = nArray[n2++] = bl ? -n4 : n4;
                        if (c2 == ',') {
                            c2 = this.charAt(this.e + n3++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    c2 = this.charAt(this.e + n3++);
                }
                break block20;
            }
            this.matchStat = -1;
            return null;
        }
        if (n2 != nArray.length) {
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            nArray = nArray3;
        }
        if (c2 == ',') {
            this.e += n3 - 1;
            this.next();
            this.matchStat = 3;
            this.a = 16;
            return nArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.e + n3++)) == ',') {
            this.a = 16;
            this.e += n3 - 1;
            this.next();
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n3 - 1;
            this.next();
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n3 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.e += n3 - 1;
            this.a = 20;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean scanBoolean(char c2) {
        boolean bl;
        char c3;
        int n2;
        block12: {
            this.matchStat = 0;
            n2 = 0;
            c3 = this.charAt(this.e + n2++);
            bl = false;
            if (c3 == 't') {
                if (this.charAt(this.e + n2) == 'r' && this.charAt(this.e + n2 + 1) == 'u' && this.charAt(this.e + n2 + 2) == 'e') {
                    n2 += 3;
                    c3 = this.charAt(this.e + n2++);
                    bl = true;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (c3 == 'f') {
                if (this.charAt(this.e + n2) == 'a' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 's' && this.charAt(this.e + n2 + 3) == 'e') {
                    n2 += 4;
                    c3 = this.charAt(this.e + n2++);
                    bl = false;
                    break block12;
                } else {
                    this.matchStat = -1;
                    return false;
                }
            }
            if (c3 == '1') {
                c3 = this.charAt(this.e + n2++);
                bl = true;
            } else if (c3 == '0') {
                c3 = this.charAt(this.e + n2++);
                bl = false;
            }
        }
        while (true) {
            if (c3 == c2) {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                return bl;
            }
            if (!JSONLexerBase.isWhitespace(c3)) {
                this.matchStat = -1;
                return bl;
            }
            c3 = this.charAt(this.e + n2++);
        }
    }

    @Override
    public int scanInt(char c2) {
        int n2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n3 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.e + n3++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.e + n3++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.e + n3++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n2 = c3 - 48;
            while ((c3 = this.charAt(this.e + n3++)) >= '0' && c3 <= '9') {
                n2 = n2 * 10 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n2 < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n' && this.charAt(this.e + n3) == 'u' && this.charAt(this.e + n3 + 1) == 'l' && this.charAt(this.e + n3 + 2) == 'l') {
                this.matchStat = 5;
                int n4 = 0;
                n3 += 3;
                c3 = this.charAt(this.e + n3++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.e + n3++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e += n3;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return n4;
                    }
                    if (c3 == ']') {
                        this.e += n3;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return n4;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.e + n3++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.e += n3;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bl ? -n2 : n2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.e + n3++);
        }
        this.matchStat = -1;
        return bl ? -n2 : n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n2 = cArray.length;
        if ((c2 = this.charAt(this.e + n2++)) == 't') {
            if (this.charAt(this.e + n2++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.e + n2++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.e + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = true;
        } else {
            if (c2 != 'f') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.e + n2++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.e + n2++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.e + n2++) != 's') {
                this.matchStat = -1;
                return false;
            }
            if (this.charAt(this.e + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = false;
        }
        c2 = this.charAt(this.e + n2++);
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return bl;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return false;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] cArray) {
        long l2;
        long l3;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n2 = cArray.length;
        char c2 = this.charAt(this.e + n2++);
        boolean bl = false;
        if (c2 == '-') {
            c2 = this.charAt(this.e + n2++);
            bl = true;
        }
        if (c2 >= '0' && c2 <= '9') {
            boolean bl2;
            l3 = c2 - 48;
            while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                l3 = l3 * 10L + (long)(c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl3 = bl2 = n2 - cArray.length < 21 && (l3 >= 0L || l3 == Long.MIN_VALUE && bl);
            if (!bl2) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (c2 == ',') {
            long l4;
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            if (bl) {
                l4 = -l3;
                return l4;
            }
            l4 = l3;
            return l4;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            l2 = l3;
            return l2;
        }
        l2 = -l3;
        return l2;
    }

    @Override
    public long scanLong(char c2) {
        long l2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.e + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.e + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.e + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            boolean bl5;
            l2 = c3 - 48;
            while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            boolean bl6 = bl5 = l2 >= 0L || l2 == Long.MIN_VALUE && bl;
            if (!bl5) {
                String string = this.subString(this.e, n2 - 1);
                throw new NumberFormatException(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                this.matchStat = 5;
                long l3 = 0L;
                n2 += 3;
                c3 = this.charAt(this.e + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.e + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e += n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return l3;
                    }
                    if (c3 == ']') {
                        this.e += n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return l3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.e + n2++);
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        if (bl2) {
            if (c3 != '\"') {
                this.matchStat = -1;
                return 0L;
            }
            c3 = this.charAt(this.e + n2++);
        }
        while (true) {
            if (c3 == c2) {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bl ? -l2 : l2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            c3 = this.charAt(this.e + n2++);
        }
        this.matchStat = -1;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final float scanFieldFloat(char[] cArray) {
        float f2;
        char c2;
        int n2;
        block35: {
            float f3;
            block34: {
                boolean bl;
                block33: {
                    int n3;
                    int n4;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    n2 = cArray.length;
                    boolean bl5 = bl = (c2 = this.charAt(this.e + n2++)) == '\"';
                    if (bl) {
                        c2 = this.charAt(this.e + n2++);
                    }
                    boolean bl6 = bl4 = c2 == '-';
                    if (bl4) {
                        c2 = this.charAt(this.e + n2++);
                    }
                    if (c2 < '0' || c2 > '9') break block33;
                    long l2 = c2 - 48;
                    while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                        l2 = l2 * 10L + (long)(c2 - 48);
                    }
                    long l3 = 1L;
                    boolean bl7 = bl3 = c2 == '.';
                    if (bl3) {
                        if ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                            l2 = l2 * 10L + (long)(c2 - 48);
                            l3 = 10L;
                            while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                l2 = l2 * 10L + (long)(c2 - 48);
                                l3 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                    if (bl2) {
                        if ((c2 = this.charAt(this.e + n2++)) == '+' || c2 == '-') {
                            c2 = this.charAt(this.e + n2++);
                        }
                        while (c2 >= '0' && c2 <= '9') {
                            c2 = this.charAt(this.e + n2++);
                        }
                    }
                    if (bl) {
                        if (c2 != '\"') {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                        c2 = this.charAt(this.e + n2++);
                        n4 = this.e + cArray.length + 1;
                        n3 = this.e + n2 - n4 - 2;
                    } else {
                        n4 = this.e + cArray.length;
                        n3 = this.e + n2 - n4 - 1;
                    }
                    if (!bl2 && n3 < 17) {
                        f3 = (float)((double)l2 / (double)l3);
                        if (bl4) {
                            f3 = -f3;
                        }
                        break block34;
                    } else {
                        String string = this.subString(n4, n3);
                        f3 = Float.parseFloat(string);
                    }
                    break block34;
                }
                if (c2 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                    this.matchStat = 5;
                    f2 = 0.0f;
                    n2 += 3;
                    c2 = this.charAt(this.e + n2++);
                    if (bl && c2 == '\"') {
                        c2 = this.charAt(this.e + n2++);
                    }
                    break block35;
                } else {
                    this.matchStat = -1;
                    return 0.0f;
                }
            }
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return f3;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return 0.0f;
            }
            if ((c2 = this.charAt(this.e + n2++)) == ',') {
                this.a = 16;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == ']') {
                this.a = 15;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == '}') {
                this.a = 13;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return 0.0f;
                }
                this.e += n2 - 1;
                this.a = 20;
                this.d = (char)26;
            }
            this.matchStat = 4;
            return f3;
        }
        while (true) {
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 16;
                return f2;
            }
            if (c2 == '}') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 13;
                return f2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return 0.0f;
            }
            c2 = this.charAt(this.e + n2++);
        }
    }

    @Override
    public final float scanFloat(char c2) {
        float f2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.e + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.e + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.e + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n3;
            int n4;
            boolean bl5;
            boolean bl6;
            long l2 = c3 - 48;
            while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            long l3 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                    l2 = l2 * 10L + (long)(c3 - 48);
                    l3 = 10L;
                    while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                        l2 = l2 * 10L + (long)(c3 - 48);
                        l3 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0f;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(this.e + n2++)) == '+' || c3 == '-') {
                    c3 = this.charAt(this.e + n2++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(this.e + n2++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0f;
                }
                c3 = this.charAt(this.e + n2++);
                n4 = this.e + 1;
                n3 = this.e + n2 - n4 - 2;
            } else {
                n4 = this.e;
                n3 = this.e + n2 - n4 - 1;
            }
            if (!bl5 && n3 < 17) {
                f2 = (float)((double)l2 / (double)l3);
                if (bl) {
                    f2 = -f2;
                }
            } else {
                String string = this.subString(n4, n3);
                f2 = Float.parseFloat(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                this.matchStat = 5;
                float f3 = 0.0f;
                n2 += 3;
                c3 = this.charAt(this.e + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.e + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e += n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return f3;
                    }
                    if (c3 == ']') {
                        this.e += n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return f3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.e + n2++);
                }
                this.matchStat = -1;
                return 0.0f;
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (c3 == c2) {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return f2;
        }
        this.matchStat = -1;
        return f2;
    }

    @Override
    public double scanDouble(char c2) {
        double d2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = 0;
        boolean bl3 = bl2 = (c3 = this.charAt(this.e + n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(this.e + n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(this.e + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n3;
            int n4;
            boolean bl5;
            boolean bl6;
            long l2 = c3 - 48;
            while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            long l3 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                    l2 = l2 * 10L + (long)(c3 - 48);
                    l3 = 10L;
                    while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                        l2 = l2 * 10L + (long)(c3 - 48);
                        l3 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(this.e + n2++)) == '+' || c3 == '-') {
                    c3 = this.charAt(this.e + n2++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(this.e + n2++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0;
                }
                c3 = this.charAt(this.e + n2++);
                n4 = this.e + 1;
                n3 = this.e + n2 - n4 - 2;
            } else {
                n4 = this.e;
                n3 = this.e + n2 - n4 - 1;
            }
            if (!bl5 && n3 < 17) {
                d2 = (double)l2 / (double)l3;
                if (bl) {
                    d2 = -d2;
                }
            } else {
                String string = this.subString(n4, n3);
                d2 = Double.parseDouble(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                this.matchStat = 5;
                double d3 = 0.0;
                n2 += 3;
                c3 = this.charAt(this.e + n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(this.e + n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e += n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return d3;
                    }
                    if (c3 == ']') {
                        this.e += n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return d3;
                    }
                    if (!JSONLexerBase.isWhitespace(c3)) break;
                    c3 = this.charAt(this.e + n2++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (c3 == c2) {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return d2;
        }
        this.matchStat = -1;
        return d2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public BigDecimal scanDecimal(char c2) {
        BigDecimal bigDecimal;
        char c3;
        int n2;
        block32: {
            BigDecimal bigDecimal2;
            block30: {
                block31: {
                    boolean bl;
                    block29: {
                        int n3;
                        int n4;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        this.matchStat = 0;
                        n2 = 0;
                        boolean bl5 = bl = (c3 = this.charAt(this.e + n2++)) == '\"';
                        if (bl) {
                            c3 = this.charAt(this.e + n2++);
                        }
                        boolean bl6 = bl4 = c3 == '-';
                        if (bl4) {
                            c3 = this.charAt(this.e + n2++);
                        }
                        if (c3 < '0' || c3 > '9') break block29;
                        while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                        }
                        boolean bl7 = bl3 = c3 == '.';
                        if (bl3) {
                            if ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                                while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl8 = bl2 = c3 == 'e' || c3 == 'E';
                        if (bl2) {
                            if ((c3 = this.charAt(this.e + n2++)) == '+' || c3 == '-') {
                                c3 = this.charAt(this.e + n2++);
                            }
                            while (c3 >= '0' && c3 <= '9') {
                                c3 = this.charAt(this.e + n2++);
                            }
                        }
                        if (bl) {
                            if (c3 != '\"') {
                                this.matchStat = -1;
                                return null;
                            }
                            c3 = this.charAt(this.e + n2++);
                            n4 = this.e + 1;
                            n3 = this.e + n2 - n4 - 2;
                        } else {
                            n4 = this.e;
                            n3 = this.e + n2 - n4 - 1;
                        }
                        if (n3 > 65535) {
                            throw new JSONException("decimal overflow");
                        }
                        char[] cArray = this.sub_chars(n4, n3);
                        bigDecimal2 = new BigDecimal(cArray, 0, cArray.length, MathContext.UNLIMITED);
                        if (c3 != ',') break block30;
                        break block31;
                    }
                    if (c3 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                        this.matchStat = 5;
                        bigDecimal = null;
                        n2 += 3;
                        c3 = this.charAt(this.e + n2++);
                        if (bl && c3 == '\"') {
                            c3 = this.charAt(this.e + n2++);
                        }
                        break block32;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bigDecimal2;
            }
            if (c3 != ']') {
                this.matchStat = -1;
                return null;
            }
            if ((c3 = this.charAt(this.e + n2++)) == ',') {
                this.a = 16;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c3 == ']') {
                this.a = 15;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c3 == '}') {
                this.a = 13;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else {
                if (c3 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.a = 20;
                this.e += n2 - 1;
                this.d = (char)26;
            }
            this.matchStat = 4;
            return bigDecimal2;
        }
        while (true) {
            if (c3 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 16;
                return bigDecimal;
            }
            if (c3 == '}') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 13;
                return bigDecimal;
            }
            if (!JSONLexerBase.isWhitespace(c3)) {
                this.matchStat = -1;
                return null;
            }
            c3 = this.charAt(this.e + n2++);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final float[] scanFieldFloatArray(char[] cArray) {
        void var4_8;
        char c2;
        int n2;
        block27: {
            void var4_5;
            int n3;
            block28: {
                block26: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    n2 = cArray.length;
                    if ((c2 = this.charAt(this.e + n2++)) != '[') {
                        this.matchStat = -2;
                        return null;
                    }
                    c2 = this.charAt(this.e + n2++);
                    float[] fArray = new float[16];
                    n3 = 0;
                    while (true) {
                        Object object;
                        float f2;
                        boolean bl;
                        boolean bl2;
                        boolean bl3;
                        int n4 = this.e + n2 - 1;
                        boolean bl4 = bl3 = c2 == '-';
                        if (bl3) {
                            c2 = this.charAt(this.e + n2++);
                        }
                        if (c2 < '0' || c2 > '9') break block26;
                        int n5 = c2 - 48;
                        while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                            n5 = n5 * 10 + (c2 - 48);
                        }
                        int n6 = 1;
                        boolean bl5 = bl2 = c2 == '.';
                        if (bl2) {
                            c2 = this.charAt(this.e + n2++);
                            n6 = 10;
                            if (c2 >= '0' && c2 <= '9') {
                                n5 = n5 * 10 + (c2 - 48);
                                while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                    n5 = n5 * 10 + (c2 - 48);
                                    n6 *= 10;
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl6 = bl = c2 == 'e' || c2 == 'E';
                        if (bl) {
                            if ((c2 = this.charAt(this.e + n2++)) == '+' || c2 == '-') {
                                c2 = this.charAt(this.e + n2++);
                            }
                            while (c2 >= '0' && c2 <= '9') {
                                c2 = this.charAt(this.e + n2++);
                            }
                        }
                        int n7 = this.e + n2 - n4 - 1;
                        if (!bl && n7 < 10) {
                            f2 = (float)n5 / (float)n6;
                            if (bl3) {
                                f2 = -f2;
                            }
                        } else {
                            object = this.subString(n4, n7);
                            f2 = Float.parseFloat((String)object);
                        }
                        if (n3 >= ((void)var4_5).length) {
                            object = new float[((void)var4_5).length * 3 / 2];
                            System.arraycopy(var4_5, 0, object, 0, n3);
                            Object object2 = object;
                        }
                        var4_5[n3++] = f2;
                        if (c2 == ',') {
                            c2 = this.charAt(this.e + n2++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    c2 = this.charAt(this.e + n2++);
                    if (n3 == ((void)var4_5).length) break block27;
                    break block28;
                }
                this.matchStat = -1;
                return null;
            }
            float[] fArray = new float[n3];
            System.arraycopy(var4_5, 0, fArray, 0, n3);
            float[] fArray2 = fArray;
        }
        if (c2 == ',') {
            this.e += n2 - 1;
            this.next();
            this.matchStat = 3;
            this.a = 16;
            return var4_8;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2 - 1;
            this.next();
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2 - 1;
            this.next();
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.e += n2 - 1;
            this.a = 20;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return var4_8;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final float[][] scanFieldFloatArray2(char[] cArray) {
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return null;
        }
        int n2 = cArray.length;
        if ((c2 = this.charAt(this.e + n2++)) != '[') {
            this.matchStat = -2;
            return null;
        }
        c2 = this.charAt(this.e + n2++);
        float[][] fArrayArray = new float[16][];
        int n3 = 0;
        while (c2 == '[') {
            void var6_6;
            int n4;
            block31: {
                void var6_8;
                block32: {
                    block30: {
                        c2 = this.charAt(this.e + n2++);
                        float[] fArray = new float[16];
                        n4 = 0;
                        while (true) {
                            Object object;
                            float f2;
                            boolean bl;
                            boolean bl2;
                            int n5 = this.e + n2 - 1;
                            boolean bl3 = bl2 = c2 == '-';
                            if (bl2) {
                                c2 = this.charAt(this.e + n2++);
                            }
                            if (c2 < '0' || c2 > '9') break block30;
                            int n6 = c2 - 48;
                            while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                n6 = n6 * 10 + (c2 - 48);
                            }
                            int n7 = 1;
                            if (c2 == '.') {
                                if ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                    n6 = n6 * 10 + (c2 - 48);
                                    n7 = 10;
                                    while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                        n6 = n6 * 10 + (c2 - 48);
                                        n7 *= 10;
                                    }
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            boolean bl4 = bl = c2 == 'e' || c2 == 'E';
                            if (bl) {
                                if ((c2 = this.charAt(this.e + n2++)) == '+' || c2 == '-') {
                                    c2 = this.charAt(this.e + n2++);
                                }
                                while (c2 >= '0' && c2 <= '9') {
                                    c2 = this.charAt(this.e + n2++);
                                }
                            }
                            int n8 = this.e + n2 - n5 - 1;
                            if (!bl && n8 < 10) {
                                f2 = (float)n6 / (float)n7;
                                if (bl2) {
                                    f2 = -f2;
                                }
                            } else {
                                object = this.subString(n5, n8);
                                f2 = Float.parseFloat((String)object);
                            }
                            if (n4 >= ((void)var6_8).length) {
                                object = new float[((void)var6_8).length * 3 / 2];
                                System.arraycopy(var6_8, 0, object, 0, n4);
                                Object object2 = object;
                            }
                            var6_8[n4++] = f2;
                            if (c2 == ',') {
                                c2 = this.charAt(this.e + n2++);
                                continue;
                            }
                            if (c2 == ']') break;
                        }
                        c2 = this.charAt(this.e + n2++);
                        if (n4 == ((void)var6_8).length) break block31;
                        break block32;
                    }
                    this.matchStat = -1;
                    return null;
                }
                float[] fArray = new float[n4];
                System.arraycopy(var6_8, 0, fArray, 0, n4);
                float[] fArray2 = fArray;
            }
            if (n3 >= fArrayArray.length) {
                float[][] fArrayArray2 = new float[fArrayArray.length * 3 / 2][];
                System.arraycopy(var6_6, 0, fArrayArray2, 0, n4);
                fArrayArray = fArrayArray2;
            }
            fArrayArray[n3++] = var6_6;
            if (c2 == ',') {
                c2 = this.charAt(this.e + n2++);
                continue;
            }
            if (c2 != ']') continue;
            c2 = this.charAt(this.e + n2++);
            break;
        }
        if (n3 != fArrayArray.length) {
            float[][] fArrayArray3 = new float[n3][];
            System.arraycopy(fArrayArray, 0, fArrayArray3, 0, n3);
            fArrayArray = fArrayArray3;
        }
        if (c2 == ',') {
            this.e += n2 - 1;
            this.next();
            this.matchStat = 3;
            this.a = 16;
            return fArrayArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2 - 1;
            this.next();
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2 - 1;
            this.next();
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.e += n2 - 1;
            this.a = 20;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return fArrayArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final double scanFieldDouble(char[] cArray) {
        double d2;
        char c2;
        int n2;
        block35: {
            double d3;
            block34: {
                boolean bl;
                block33: {
                    int n3;
                    int n4;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    n2 = cArray.length;
                    boolean bl5 = bl = (c2 = this.charAt(this.e + n2++)) == '\"';
                    if (bl) {
                        c2 = this.charAt(this.e + n2++);
                    }
                    boolean bl6 = bl4 = c2 == '-';
                    if (bl4) {
                        c2 = this.charAt(this.e + n2++);
                    }
                    if (c2 < '0' || c2 > '9') break block33;
                    long l2 = c2 - 48;
                    while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                        l2 = l2 * 10L + (long)(c2 - 48);
                    }
                    long l3 = 1L;
                    boolean bl7 = bl3 = c2 == '.';
                    if (bl3) {
                        if ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                            l2 = l2 * 10L + (long)(c2 - 48);
                            l3 = 10L;
                            while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                l2 = l2 * 10L + (long)(c2 - 48);
                                l3 *= 10L;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                    if (bl2) {
                        if ((c2 = this.charAt(this.e + n2++)) == '+' || c2 == '-') {
                            c2 = this.charAt(this.e + n2++);
                        }
                        while (c2 >= '0' && c2 <= '9') {
                            c2 = this.charAt(this.e + n2++);
                        }
                    }
                    if (bl) {
                        if (c2 != '\"') {
                            this.matchStat = -1;
                            return 0.0;
                        }
                        c2 = this.charAt(this.e + n2++);
                        n4 = this.e + cArray.length + 1;
                        n3 = this.e + n2 - n4 - 2;
                    } else {
                        n4 = this.e + cArray.length;
                        n3 = this.e + n2 - n4 - 1;
                    }
                    if (!bl2 && n3 < 17) {
                        d3 = (double)l2 / (double)l3;
                        if (bl4) {
                            d3 = -d3;
                        }
                        break block34;
                    } else {
                        String string = this.subString(n4, n3);
                        d3 = Double.parseDouble(string);
                    }
                    break block34;
                }
                if (c2 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                    this.matchStat = 5;
                    d2 = 0.0;
                    n2 += 3;
                    c2 = this.charAt(this.e + n2++);
                    if (bl && c2 == '\"') {
                        c2 = this.charAt(this.e + n2++);
                    }
                    break block35;
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return d3;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return 0.0;
            }
            if ((c2 = this.charAt(this.e + n2++)) == ',') {
                this.a = 16;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == ']') {
                this.a = 15;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == '}') {
                this.a = 13;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return 0.0;
                }
                this.a = 20;
                this.e += n2 - 1;
                this.d = (char)26;
            }
            this.matchStat = 4;
            return d3;
        }
        while (true) {
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 16;
                return d2;
            }
            if (c2 == '}') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 13;
                return d2;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return 0.0;
            }
            c2 = this.charAt(this.e + n2++);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigDecimal scanFieldDecimal(char[] cArray) {
        BigDecimal bigDecimal;
        char c2;
        int n2;
        block33: {
            BigDecimal bigDecimal2;
            block31: {
                block32: {
                    boolean bl;
                    block30: {
                        int n3;
                        int n4;
                        boolean bl2;
                        boolean bl3;
                        boolean bl4;
                        this.matchStat = 0;
                        if (!this.charArrayCompare(cArray)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n2 = cArray.length;
                        boolean bl5 = bl = (c2 = this.charAt(this.e + n2++)) == '\"';
                        if (bl) {
                            c2 = this.charAt(this.e + n2++);
                        }
                        boolean bl6 = bl4 = c2 == '-';
                        if (bl4) {
                            c2 = this.charAt(this.e + n2++);
                        }
                        if (c2 < '0' || c2 > '9') break block30;
                        while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                        }
                        boolean bl7 = bl3 = c2 == '.';
                        if (bl3) {
                            if ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        boolean bl8 = bl2 = c2 == 'e' || c2 == 'E';
                        if (bl2) {
                            if ((c2 = this.charAt(this.e + n2++)) == '+' || c2 == '-') {
                                c2 = this.charAt(this.e + n2++);
                            }
                            while (c2 >= '0' && c2 <= '9') {
                                c2 = this.charAt(this.e + n2++);
                            }
                        }
                        if (bl) {
                            if (c2 != '\"') {
                                this.matchStat = -1;
                                return null;
                            }
                            c2 = this.charAt(this.e + n2++);
                            n4 = this.e + cArray.length + 1;
                            n3 = this.e + n2 - n4 - 2;
                        } else {
                            n4 = this.e + cArray.length;
                            n3 = this.e + n2 - n4 - 1;
                        }
                        if (n3 > 65535) {
                            throw new JSONException("scan decimal overflow");
                        }
                        char[] cArray2 = this.sub_chars(n4, n3);
                        bigDecimal2 = new BigDecimal(cArray2, 0, cArray2.length, MathContext.UNLIMITED);
                        if (c2 != ',') break block31;
                        break block32;
                    }
                    if (c2 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                        this.matchStat = 5;
                        bigDecimal = null;
                        n2 += 3;
                        c2 = this.charAt(this.e + n2++);
                        if (bl && c2 == '\"') {
                            c2 = this.charAt(this.e + n2++);
                        }
                        break block33;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bigDecimal2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return null;
            }
            if ((c2 = this.charAt(this.e + n2++)) == ',') {
                this.a = 16;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == ']') {
                this.a = 15;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == '}') {
                this.a = 13;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.a = 20;
                this.e += n2 - 1;
                this.d = (char)26;
            }
            this.matchStat = 4;
            return bigDecimal2;
        }
        while (true) {
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 16;
                return bigDecimal;
            }
            if (c2 == '}') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 13;
                return bigDecimal;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.e + n2++);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public BigInteger scanFieldBigInteger(char[] cArray) {
        BigInteger bigInteger;
        char c2;
        int n2;
        block29: {
            BigInteger bigInteger2;
            int n3;
            int n4;
            boolean bl;
            long l2;
            boolean bl2;
            boolean bl3;
            block28: {
                block27: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    n2 = cArray.length;
                    boolean bl4 = bl3 = (c2 = this.charAt(this.e + n2++)) == '\"';
                    if (bl3) {
                        c2 = this.charAt(this.e + n2++);
                    }
                    boolean bl5 = bl2 = c2 == '-';
                    if (bl2) {
                        c2 = this.charAt(this.e + n2++);
                    }
                    if (c2 < '0' || c2 > '9') break block27;
                    l2 = c2 - 48;
                    bl = false;
                    break block28;
                }
                if (c2 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                    this.matchStat = 5;
                    bigInteger = null;
                    n2 += 3;
                    c2 = this.charAt(this.e + n2++);
                    if (bl3 && c2 == '\"') {
                        c2 = this.charAt(this.e + n2++);
                    }
                    break block29;
                } else {
                    this.matchStat = -1;
                    return null;
                }
            }
            while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                long l3 = l2 * 10L + (long)(c2 - 48);
                if (l3 < l2) {
                    bl = true;
                    break;
                }
                l2 = l3;
            }
            if (bl3) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                c2 = this.charAt(this.e + n2++);
                n4 = this.e + cArray.length + 1;
                n3 = this.e + n2 - n4 - 2;
            } else {
                n4 = this.e + cArray.length;
                n3 = this.e + n2 - n4 - 1;
            }
            if (!bl && (n3 < 20 || bl2 && n3 < 21)) {
                bigInteger2 = BigInteger.valueOf(bl2 ? -l2 : l2);
            } else {
                if (n3 > 65535) {
                    throw new JSONException("scanInteger overflow");
                }
                String string = this.subString(n4, n3);
                bigInteger2 = new BigInteger(string, 10);
            }
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bigInteger2;
            }
            if (c2 != '}') {
                this.matchStat = -1;
                return null;
            }
            if ((c2 = this.charAt(this.e + n2++)) == ',') {
                this.a = 16;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == ']') {
                this.a = 15;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else if (c2 == '}') {
                this.a = 13;
                this.e += n2;
                this.d = this.charAt(this.e);
            } else {
                if (c2 != '\u001a') {
                    this.matchStat = -1;
                    return null;
                }
                this.a = 20;
                this.e += n2 - 1;
                this.d = (char)26;
            }
            this.matchStat = 4;
            return bigInteger2;
        }
        while (true) {
            if (c2 == ',') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 16;
                return bigInteger;
            }
            if (c2 == '}') {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 5;
                this.a = 13;
                return bigInteger;
            }
            if (!JSONLexerBase.isWhitespace(c2)) {
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.e + n2++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanFieldDate(char[] cArray) {
        Date date;
        char c2;
        int n2;
        block25: {
            Object object;
            String string;
            int n3;
            block27: {
                block28: {
                    block26: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare(cArray)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n2 = cArray.length;
                        if ((c2 = this.charAt(this.e + n2++)) != '\"') break block26;
                        int n4 = this.e + cArray.length + 1;
                        n3 = this.indexOf('\"', n4);
                        if (n3 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n5 = this.e + cArray.length + 1;
                        string = this.subString(n5, n3 - n5);
                        if (string.indexOf(92) == -1) break block27;
                        break block28;
                    }
                    if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                        long l2 = 0L;
                        boolean bl = false;
                        if (c2 == '-') {
                            c2 = this.charAt(this.e + n2++);
                            bl = true;
                        }
                        if (c2 >= '0' && c2 <= '9') {
                            l2 = c2 - 48;
                            while ((c2 = this.charAt(this.e + n2++)) >= '0' && c2 <= '9') {
                                l2 = l2 * 10L + (long)(c2 - 48);
                            }
                        }
                        if (l2 < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l2 = -l2;
                        }
                        date = new Date(l2);
                        break block25;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    int n6 = 0;
                    for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                    }
                    if (n6 % 2 == 0) {
                        n6 = n3 - (this.e + cArray.length + 1);
                        object = this.sub_chars(this.e + cArray.length + 1, n6);
                        string = JSONLexerBase.readString((char[])object, n6);
                        break;
                    }
                    n3 = this.indexOf('\"', n3 + 1);
                }
            }
            n2 += n3 - (this.e + cArray.length + 1) + 1;
            c2 = this.charAt(this.e + n2++);
            try (JSONScanner jSONScanner = new JSONScanner(string);){
                if (!jSONScanner.scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    object = null;
                    return object;
                }
                object = jSONScanner.getCalendar();
                date = ((Calendar)object).getTime();
            }
        }
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return date;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanDate(char c2) {
        Date date;
        char c3;
        int n2;
        block26: {
            Object object;
            String string;
            int n3;
            block28: {
                block29: {
                    block27: {
                        this.matchStat = 0;
                        n2 = 0;
                        if ((c3 = this.charAt(this.e + n2++)) != '\"') break block27;
                        int n4 = this.e + 1;
                        n3 = this.indexOf('\"', n4);
                        if (n3 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n5 = this.e + 1;
                        string = this.subString(n5, n3 - n5);
                        if (string.indexOf(92) == -1) break block28;
                        break block29;
                    }
                    if (c3 == '-' || c3 >= '0' && c3 <= '9') {
                        long l2 = 0L;
                        boolean bl = false;
                        if (c3 == '-') {
                            c3 = this.charAt(this.e + n2++);
                            bl = true;
                        }
                        if (c3 >= '0' && c3 <= '9') {
                            l2 = c3 - 48;
                            while ((c3 = this.charAt(this.e + n2++)) >= '0' && c3 <= '9') {
                                l2 = l2 * 10L + (long)(c3 - 48);
                            }
                        }
                        if (l2 < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l2 = -l2;
                        }
                        date = new Date(l2);
                        break block26;
                    } else if (c3 == 'n' && this.charAt(this.e + n2) == 'u' && this.charAt(this.e + n2 + 1) == 'l' && this.charAt(this.e + n2 + 2) == 'l') {
                        this.matchStat = 5;
                        date = null;
                        n2 += 3;
                        c3 = this.charAt(this.e + n2++);
                        break block26;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    int n6 = 0;
                    for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n6, --i2) {
                    }
                    if (n6 % 2 == 0) {
                        n6 = n3 - (this.e + 1);
                        object = this.sub_chars(this.e + 1, n6);
                        string = JSONLexerBase.readString((char[])object, n6);
                        break;
                    }
                    n3 = this.indexOf('\"', n3 + 1);
                }
            }
            n2 += n3 - (this.e + 1) + 1;
            c3 = this.charAt(this.e + n2++);
            try (JSONScanner jSONScanner = new JSONScanner(string);){
                if (!jSONScanner.scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    object = null;
                    return object;
                }
                object = jSONScanner.getCalendar();
                date = ((Calendar)object).getTime();
            }
        }
        if (c3 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return date;
        }
        if (c3 != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((c3 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c3 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c3 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c3 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return date;
    }

    /*
     * Enabled aggressive block sorting
     */
    public UUID scanFieldUUID(char[] cArray) {
        UUID uUID;
        char c2;
        int n2;
        block63: {
            char c3;
            int n3;
            int n4;
            long l2;
            long l3;
            int n5;
            int n6;
            block67: {
                char c4;
                int n7;
                int n8;
                long l4;
                long l5;
                block66: {
                    block64: {
                        int n9;
                        block65: {
                            this.matchStat = 0;
                            if (!this.charArrayCompare(cArray)) {
                                this.matchStat = -2;
                                return null;
                            }
                            n2 = cArray.length;
                            if ((c2 = this.charAt(this.e + n2++)) != '\"') break block64;
                            int n10 = this.e + cArray.length + 1;
                            n6 = this.indexOf('\"', n10);
                            if (n6 == -1) {
                                throw new JSONException("unclosed str");
                            }
                            n5 = this.e + cArray.length + 1;
                            n9 = n6 - n5;
                            if (n9 != 36) break block65;
                            l5 = 0L;
                            l4 = 0L;
                            break block66;
                        }
                        if (n9 != 32) {
                            this.matchStat = -1;
                            return null;
                        }
                        l3 = 0L;
                        l2 = 0L;
                        break block67;
                    }
                    if (c2 == 'n' && this.charAt(this.e + n2++) == 'u' && this.charAt(this.e + n2++) == 'l' && this.charAt(this.e + n2++) == 'l') {
                        uUID = null;
                        c2 = this.charAt(this.e + n2++);
                        break block63;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                for (n7 = 0; n7 < 8; l5 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 9; n7 < 13; l5 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 14; n7 < 18; l5 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 19; n7 < 23; l4 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n7 = 24; n7 < 36; l4 |= (long)n8, ++n7) {
                    c4 = this.charAt(n5 + n7);
                    if (c4 >= '0' && c4 <= '9') {
                        n8 = c4 - 48;
                    } else if (c4 >= 'a' && c4 <= 'f') {
                        n8 = 10 + (c4 - 97);
                    } else if (c4 >= 'A' && c4 <= 'F') {
                        n8 = 10 + (c4 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                uUID = new UUID(l5, l4);
                n2 += n6 - (this.e + cArray.length + 1) + 1;
                c2 = this.charAt(this.e + n2++);
                break block63;
            }
            for (n3 = 0; n3 < 16; l3 |= (long)n4, ++n3) {
                c3 = this.charAt(n5 + n3);
                if (c3 >= '0' && c3 <= '9') {
                    n4 = c3 - 48;
                } else if (c3 >= 'a' && c3 <= 'f') {
                    n4 = 10 + (c3 - 97);
                } else if (c3 >= 'A' && c3 <= 'F') {
                    n4 = 10 + (c3 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l3 <<= 4;
            }
            for (n3 = 16; n3 < 32; l2 |= (long)n4, ++n3) {
                c3 = this.charAt(n5 + n3);
                if (c3 >= '0' && c3 <= '9') {
                    n4 = c3 - 48;
                } else if (c3 >= 'a' && c3 <= 'f') {
                    n4 = 10 + (c3 - 97);
                } else if (c3 >= 'A' && c3 <= 'F') {
                    n4 = 10 + (c3 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l2 <<= 4;
            }
            uUID = new UUID(l3, l2);
            n2 += n6 - (this.e + cArray.length + 1) + 1;
            c2 = this.charAt(this.e + n2++);
        }
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return uUID;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        if ((c2 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return uUID;
    }

    /*
     * Enabled aggressive block sorting
     */
    public UUID scanUUID(char c2) {
        UUID uUID;
        char c3;
        int n2;
        block62: {
            char c4;
            int n3;
            int n4;
            long l2;
            long l3;
            int n5;
            int n6;
            block66: {
                char c5;
                int n7;
                int n8;
                long l4;
                long l5;
                block65: {
                    block63: {
                        int n9;
                        block64: {
                            this.matchStat = 0;
                            n2 = 0;
                            if ((c3 = this.charAt(this.e + n2++)) != '\"') break block63;
                            int n10 = this.e + 1;
                            n6 = this.indexOf('\"', n10);
                            if (n6 == -1) {
                                throw new JSONException("unclosed str");
                            }
                            n5 = this.e + 1;
                            n9 = n6 - n5;
                            if (n9 != 36) break block64;
                            l5 = 0L;
                            l4 = 0L;
                            break block65;
                        }
                        if (n9 != 32) {
                            this.matchStat = -1;
                            return null;
                        }
                        l3 = 0L;
                        l2 = 0L;
                        break block66;
                    }
                    if (c3 == 'n' && this.charAt(this.e + n2++) == 'u' && this.charAt(this.e + n2++) == 'l' && this.charAt(this.e + n2++) == 'l') {
                        uUID = null;
                        c3 = this.charAt(this.e + n2++);
                        break block62;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                for (n7 = 0; n7 < 8; l5 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 9; n7 < 13; l5 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 14; n7 < 18; l5 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l5 <<= 4;
                }
                for (n7 = 19; n7 < 23; l4 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                for (n7 = 24; n7 < 36; l4 |= (long)n8, ++n7) {
                    c5 = this.charAt(n5 + n7);
                    if (c5 >= '0' && c5 <= '9') {
                        n8 = c5 - 48;
                    } else if (c5 >= 'a' && c5 <= 'f') {
                        n8 = 10 + (c5 - 97);
                    } else if (c5 >= 'A' && c5 <= 'F') {
                        n8 = 10 + (c5 - 65);
                    } else {
                        this.matchStat = -2;
                        return null;
                    }
                    l4 <<= 4;
                }
                uUID = new UUID(l5, l4);
                n2 += n6 - (this.e + 1) + 1;
                c3 = this.charAt(this.e + n2++);
                break block62;
            }
            for (n3 = 0; n3 < 16; l3 |= (long)n4, ++n3) {
                c4 = this.charAt(n5 + n3);
                if (c4 >= '0' && c4 <= '9') {
                    n4 = c4 - 48;
                } else if (c4 >= 'a' && c4 <= 'f') {
                    n4 = 10 + (c4 - 97);
                } else if (c4 >= 'A' && c4 <= 'F') {
                    n4 = 10 + (c4 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l3 <<= 4;
            }
            for (n3 = 16; n3 < 32; l2 |= (long)n4, ++n3) {
                c4 = this.charAt(n5 + n3);
                if (c4 >= '0' && c4 <= '9') {
                    n4 = c4 - 48;
                } else if (c4 >= 'a' && c4 <= 'f') {
                    n4 = 10 + (c4 - 97);
                } else if (c4 >= 'A' && c4 <= 'F') {
                    n4 = 10 + (c4 - 65);
                } else {
                    this.matchStat = -2;
                    return null;
                }
                l2 <<= 4;
            }
            uUID = new UUID(l3, l2);
            n2 += n6 - (this.e + 1) + 1;
            c3 = this.charAt(this.e + n2++);
        }
        if (c3 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return uUID;
        }
        if (c3 != ']') {
            this.matchStat = -1;
            return null;
        }
        if ((c3 = this.charAt(this.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c3 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c3 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c3 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return uUID;
    }

    public final void scanTrue() {
        if (this.d != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != ' ' && this.d != ',' && this.d != '}' && this.d != ']' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\u001a' && this.d != '\f' && this.d != '\b' && this.d != ':' && this.d != '/') {
            throw new JSONException("scan true error");
        }
        this.a = 6;
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean bl) {
        if (this.d != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.d == 'u') {
            this.next();
            if (this.d != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.d != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (!(this.d == ' ' || this.d == ',' || this.d == '}' || this.d == ']' || this.d == '\n' || this.d == '\r' || this.d == '\t' || this.d == '\u001a' || this.d == ':' && bl || this.d == '\f' || this.d == '\b')) {
                throw new JSONException("scan null error");
            }
            this.a = 8;
            return;
        }
        if (this.d != 'e') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.d != 'w') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.d != ' ' && this.d != ',' && this.d != '}' && this.d != ']' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\u001a' && this.d != '\f' && this.d != '\b') {
            throw new JSONException("scan new error");
        }
        this.a = 9;
    }

    public final void scanFalse() {
        if (this.d != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != ' ' && this.d != ',' && this.d != '}' && this.d != ']' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\u001a' && this.d != '\f' && this.d != '\b' && this.d != ':' && this.d != '/') {
            throw new JSONException("scan false error");
        }
        this.a = 7;
    }

    public final void scanIdent() {
        this.i = this.e - 1;
        this.j = false;
        do {
            ++this.h;
            this.next();
        } while (Character.isLetterOrDigit(this.d));
        String string = this.stringVal();
        this.a = "null".equalsIgnoreCase(string) ? 8 : ("new".equals(string) ? 9 : ("true".equals(string) ? 6 : ("false".equals(string) ? 7 : ("undefined".equals(string) ? 23 : ("Set".equals(string) ? 21 : ("TreeSet".equals(string) ? 22 : 18))))));
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    public static String readString(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = 0;
        block22: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 != '\\') {
                cArray2[n3++] = c2;
                continue;
            }
            c2 = cArray[++i2];
            switch (c2) {
                case '0': {
                    cArray2[n3++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    cArray2[n3++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    cArray2[n3++] = 2;
                    continue block22;
                }
                case '3': {
                    cArray2[n3++] = 3;
                    continue block22;
                }
                case '4': {
                    cArray2[n3++] = 4;
                    continue block22;
                }
                case '5': {
                    cArray2[n3++] = 5;
                    continue block22;
                }
                case '6': {
                    cArray2[n3++] = 6;
                    continue block22;
                }
                case '7': {
                    cArray2[n3++] = 7;
                    continue block22;
                }
                case 'b': {
                    cArray2[n3++] = 8;
                    continue block22;
                }
                case 't': {
                    cArray2[n3++] = 9;
                    continue block22;
                }
                case 'n': {
                    cArray2[n3++] = 10;
                    continue block22;
                }
                case 'v': {
                    cArray2[n3++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    cArray2[n3++] = 12;
                    continue block22;
                }
                case 'r': {
                    cArray2[n3++] = 13;
                    continue block22;
                }
                case '\"': {
                    cArray2[n3++] = 34;
                    continue block22;
                }
                case '\'': {
                    cArray2[n3++] = 39;
                    continue block22;
                }
                case '/': {
                    cArray2[n3++] = 47;
                    continue block22;
                }
                case '\\': {
                    cArray2[n3++] = 92;
                    continue block22;
                }
                case 'x': {
                    cArray2[n3++] = (char)(q[cArray[++i2]] * 16 + q[cArray[++i2]]);
                    continue block22;
                }
                case 'u': {
                    cArray2[n3++] = (char)Integer.parseInt(new String(new char[]{cArray[++i2], cArray[++i2], cArray[++i2], cArray[++i2]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(cArray2, 0, n3);
    }

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.charAt(n2)) == '\u001a') break;
            if (!JSONLexerBase.isWhitespace(c2)) {
                return false;
            }
            ++n2;
        }
        this.a = 20;
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (this.d <= '/') {
            if (this.d == ' ' || this.d == '\r' || this.d == '\n' || this.d == '\t' || this.d == '\f' || this.d == '\b') {
                this.next();
                continue;
            }
            if (this.d != '/') break;
            this.a();
        }
    }

    private void b() {
        char c2;
        this.i = this.e;
        this.j = false;
        block22: while ((c2 = this.next()) != '\'') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.a('\u001a');
                    continue;
                }
                throw new JSONException("unclosed single-quote string");
            }
            if (c2 == '\\') {
                if (!this.j) {
                    this.j = true;
                    if (this.h > this.g.length) {
                        char[] cArray = new char[this.h * 2];
                        System.arraycopy(this.g, 0, cArray, 0, this.g.length);
                        this.g = cArray;
                    }
                    this.a(this.i + 1, this.h, this.g);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.a('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.a('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.a('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.a('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.a('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.a('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.a('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.a('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.a('\b');
                        continue block22;
                    }
                    case 't': {
                        this.a('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.a('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.a('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.a('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.a('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.a('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.a('\'');
                        continue block22;
                    }
                    case '/': {
                        this.a('/');
                        continue block22;
                    }
                    case '\\': {
                        this.a('\\');
                        continue block22;
                    }
                    case 'x': {
                        boolean bl;
                        char c3 = this.next();
                        char c4 = this.next();
                        boolean bl2 = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                        boolean bl3 = bl = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F';
                        if (!bl2 || !bl) {
                            throw new JSONException("invalid escape character \\x" + c3 + c4);
                        }
                        this.a((char)(q[c3] * 16 + q[c4]));
                        continue block22;
                    }
                    case 'u': {
                        this.a((char)Integer.parseInt(new String(new char[]{this.next(), this.next(), this.next(), this.next()}), 16));
                        continue block22;
                    }
                }
                this.d = c2;
                throw new JSONException("unclosed single-quote string");
            }
            if (!this.j) {
                ++this.h;
                continue;
            }
            if (this.h == this.g.length) {
                this.a(c2);
                continue;
            }
            this.g[this.h++] = c2;
        }
        this.a = 4;
        this.next();
    }

    protected final void a(char c2) {
        if (this.h == this.g.length) {
            char[] cArray = new char[this.g.length * 2];
            System.arraycopy(this.g, 0, cArray, 0, this.g.length);
            this.g = cArray;
        }
        this.g[this.h++] = c2;
    }

    public final void scanHex() {
        if (this.d != 'x') {
            throw new JSONException("illegal state. " + this.d);
        }
        this.next();
        if (this.d != '\'') {
            throw new JSONException("illegal state. " + this.d);
        }
        this.i = this.e;
        this.next();
        if (this.d == '\'') {
            this.next();
            this.a = 26;
            return;
        }
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.next()) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') {
                ++this.h;
            } else {
                if (c2 == '\'') {
                    ++this.h;
                    break;
                }
                throw new JSONException("illegal state. " + c2);
            }
            ++n2;
        }
        this.next();
        this.a = 26;
    }

    @Override
    public final void scanNumber() {
        this.i = this.e;
        if (this.d == '-') {
            ++this.h;
            this.next();
        }
        while (this.d >= '0' && this.d <= '9') {
            ++this.h;
            this.next();
        }
        boolean bl = false;
        if (this.d == '.') {
            ++this.h;
            this.next();
            bl = true;
            while (this.d >= '0' && this.d <= '9') {
                ++this.h;
                this.next();
            }
        }
        if (this.h > 65535) {
            throw new JSONException("scanNumber overflow");
        }
        if (this.d == 'L') {
            ++this.h;
            this.next();
        } else if (this.d == 'S') {
            ++this.h;
            this.next();
        } else if (this.d == 'B') {
            ++this.h;
            this.next();
        } else if (this.d == 'F') {
            ++this.h;
            this.next();
            bl = true;
        } else if (this.d == 'D') {
            ++this.h;
            this.next();
            bl = true;
        } else if (this.d == 'e' || this.d == 'E') {
            ++this.h;
            this.next();
            if (this.d == '+' || this.d == '-') {
                ++this.h;
                this.next();
            }
            while (this.d >= '0' && this.d <= '9') {
                ++this.h;
                this.next();
            }
            if (this.d == 'D' || this.d == 'F') {
                ++this.h;
                this.next();
            }
            bl = true;
        }
        this.a = bl ? 3 : 2;
    }

    @Override
    public final long longValue() {
        char c2;
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.i == -1) {
            this.i = 0;
        }
        int n3 = this.i;
        int n4 = this.i + this.h;
        if (this.charAt(this.i) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        long l4 = -922337203685477580L;
        if (n3 < n4) {
            n2 = this.charAt(n3++) - 48;
            l3 = -n2;
        }
        while (n3 < n4 && (c2 = this.charAt(n3++)) != 'L' && c2 != 'S' && c2 != 'B') {
            n2 = c2 - 48;
            if (l3 < l4) {
                throw new NumberFormatException(this.numberString());
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                throw new NumberFormatException(this.numberString());
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.i + 1) {
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l3;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        char c2 = this.charAt(this.i + this.h - 1);
        try {
            if (c2 == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (c2 == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (bl) {
                return this.decimalValue();
            }
            return this.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
        }
    }

    @Override
    public abstract BigDecimal decimalValue();

    public static boolean isWhitespace(char c2) {
        return c2 <= ' ' && (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\f' || c2 == '\b');
    }

    public String[] scanFieldStringArray(char[] cArray, int n2, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.c;
    }

    @Override
    public void setFeatures(int n2) {
        this.c = n2;
    }

    static {
        int n2;
        r = new ThreadLocal();
        p = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
        q = new int[103];
        for (n2 = 48; n2 <= 57; ++n2) {
            JSONLexerBase.q[n2] = n2 - 48;
        }
        for (n2 = 97; n2 <= 102; ++n2) {
            JSONLexerBase.q[n2] = n2 - 97 + 10;
        }
        for (n2 = 65; n2 <= 70; ++n2) {
            JSONLexerBase.q[n2] = n2 - 65 + 10;
        }
    }
}

