/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class NumberDeserializer
implements ObjectDeserializer {
    public static final NumberDeserializer instance = new NumberDeserializer();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            if (type == Double.TYPE || type == Double.class) {
                String string = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(string));
            }
            long l2 = jSONLexer.longValue();
            jSONLexer.nextToken(16);
            if (type == Short.TYPE || type == Short.class) {
                if (l2 > 32767L || l2 < -32768L) {
                    throw new JSONException("short overflow : " + l2);
                }
                return (T)Short.valueOf((short)l2);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                if (l2 > 127L || l2 < -128L) {
                    throw new JSONException("short overflow : " + l2);
                }
                return (T)Byte.valueOf((byte)l2);
            }
            if (l2 >= Integer.MIN_VALUE && l2 <= Integer.MAX_VALUE) {
                return (T)Integer.valueOf((int)l2);
            }
            return (T)Long.valueOf(l2);
        }
        if (jSONLexer.token() == 3) {
            if (type == Double.TYPE || type == Double.class) {
                String string = jSONLexer.numberString();
                jSONLexer.nextToken(16);
                return (T)Double.valueOf(Double.parseDouble(string));
            }
            if (type == Short.TYPE || type == Short.class) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                short s2 = TypeUtils.shortValue(bigDecimal);
                return (T)Short.valueOf(s2);
            }
            if (type == Byte.TYPE || type == Byte.class) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                jSONLexer.nextToken(16);
                byte by = TypeUtils.byteValue(bigDecimal);
                return (T)Byte.valueOf(by);
            }
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            if (jSONLexer.isEnabled(Feature.UseBigDecimal)) {
                return (T)bigDecimal;
            }
            return (T)Double.valueOf(bigDecimal.doubleValue());
        }
        if (jSONLexer.token() == 18 && "NaN".equals(jSONLexer.stringVal())) {
            jSONLexer.nextToken();
            Number number = null;
            if (type == Double.class) {
                number = Double.NaN;
            } else if (type == Float.class) {
                number = Float.valueOf(Float.NaN);
            }
            return (T)number;
        }
        Object object2 = defaultJSONParser.parse();
        if (object2 == null) {
            return null;
        }
        if (type == Double.TYPE || type == Double.class) {
            try {
                return (T)TypeUtils.castToDouble(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseDouble error, field : " + object, exception);
            }
        }
        if (type == Short.TYPE || type == Short.class) {
            try {
                return (T)TypeUtils.castToShort(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseShort error, field : " + object, exception);
            }
        }
        if (type == Byte.TYPE || type == Byte.class) {
            try {
                return (T)TypeUtils.castToByte(object2);
            }
            catch (Exception exception) {
                throw new JSONException("parseByte error, field : " + object, exception);
            }
        }
        return (T)TypeUtils.castToBigDecimal(object2);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

