/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;

public class OptionalCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static OptionalCodec instance = new OptionalCodec();

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (type == OptionalInt.class) {
            Integer n2 = defaultJSONParser.parseObject(Integer.class);
            Integer n3 = TypeUtils.castToInt(n2);
            if (n3 == null) {
                return (T)OptionalInt.empty();
            }
            return (T)OptionalInt.of(n3);
        }
        if (type == OptionalLong.class) {
            Long l2 = defaultJSONParser.parseObject(Long.class);
            Long l3 = TypeUtils.castToLong(l2);
            if (l3 == null) {
                return (T)OptionalLong.empty();
            }
            return (T)OptionalLong.of(l3);
        }
        if (type == OptionalDouble.class) {
            Double d2 = defaultJSONParser.parseObject(Double.class);
            Double d3 = TypeUtils.castToDouble(d2);
            if (d3 == null) {
                return (T)OptionalDouble.empty();
            }
            return (T)OptionalDouble.of(d3);
        }
        Object t2 = defaultJSONParser.parseObject(type = TypeUtils.unwrapOptional(type));
        if (t2 == null) {
            return (T)Optional.empty();
        }
        return (T)Optional.of(t2);
    }

    @Override
    public int getFastMatchToken() {
        return 12;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        if (object == null) {
            jSONSerializer.writeNull();
            return;
        }
        if (object instanceof Optional) {
            Optional optional = (Optional)object;
            Object var7_10 = optional.isPresent() ? optional.get() : null;
            jSONSerializer.write((Object)var7_10);
            return;
        }
        if (object instanceof OptionalDouble) {
            OptionalDouble optionalDouble = (OptionalDouble)object;
            if (optionalDouble.isPresent()) {
                double d2 = optionalDouble.getAsDouble();
                jSONSerializer.write(d2);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        if (object instanceof OptionalInt) {
            OptionalInt optionalInt = (OptionalInt)object;
            if (optionalInt.isPresent()) {
                int n3 = optionalInt.getAsInt();
                jSONSerializer.out.writeInt(n3);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        if (object instanceof OptionalLong) {
            OptionalLong optionalLong = (OptionalLong)object;
            if (optionalLong.isPresent()) {
                long l2 = optionalLong.getAsLong();
                jSONSerializer.out.writeLong(l2);
            } else {
                jSONSerializer.writeNull();
            }
            return;
        }
        throw new JSONException("not support optional : " + object.getClass());
    }
}

