/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final AtomicCodec instance = new AtomicCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object instanceof AtomicInteger) {
            AtomicInteger atomicInteger = (AtomicInteger)object;
            serializeWriter.writeInt(atomicInteger.get());
            return;
        }
        if (object instanceof AtomicLong) {
            AtomicLong atomicLong = (AtomicLong)object;
            serializeWriter.writeLong(atomicLong.get());
            return;
        }
        if (object instanceof AtomicBoolean) {
            AtomicBoolean atomicBoolean = (AtomicBoolean)object;
            serializeWriter.append(atomicBoolean.get() ? "true" : "false");
            return;
        }
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof AtomicIntegerArray) {
            AtomicIntegerArray atomicIntegerArray = (AtomicIntegerArray)object;
            int n3 = atomicIntegerArray.length();
            serializeWriter.write(91);
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = atomicIntegerArray.get(i2);
                if (i2 != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeInt(n4);
            }
            serializeWriter.write(93);
            return;
        }
        AtomicLongArray atomicLongArray = (AtomicLongArray)object;
        int n5 = atomicLongArray.length();
        serializeWriter.write(91);
        for (int i3 = 0; i3 < n5; ++i3) {
            long l2 = atomicLongArray.get(i3);
            if (i3 != 0) {
                serializeWriter.write(44);
            }
            serializeWriter.writeLong(l2);
        }
        serializeWriter.write(93);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (defaultJSONParser.lexer.token() == 8) {
            defaultJSONParser.lexer.nextToken(16);
            return null;
        }
        JSONArray jSONArray = new JSONArray();
        defaultJSONParser.parseArray(jSONArray);
        if (type == AtomicIntegerArray.class) {
            AtomicIntegerArray atomicIntegerArray = new AtomicIntegerArray(jSONArray.size());
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                atomicIntegerArray.set(i2, jSONArray.getInteger(i2));
            }
            return (T)atomicIntegerArray;
        }
        AtomicLongArray atomicLongArray = new AtomicLongArray(jSONArray.size());
        for (int i3 = 0; i3 < jSONArray.size(); ++i3) {
            atomicLongArray.set(i3, jSONArray.getLong(i3));
        }
        return (T)atomicLongArray;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

