/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigInteger;

public class BigIntegerCodec
implements ObjectDeserializer,
ObjectSerializer {
    private static final BigInteger a = BigInteger.valueOf(-9007199254740991L);
    private static final BigInteger b = BigInteger.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigIntegerCodec instance = new BigIntegerCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        BigInteger bigInteger = (BigInteger)object;
        String string = bigInteger.toString();
        if (string.length() >= 16 && SerializerFeature.isEnabled(n2, serializeWriter.c, SerializerFeature.BrowserCompatible) && (bigInteger.compareTo(a) < 0 || bigInteger.compareTo(b) > 0)) {
            serializeWriter.writeString(string);
            return;
        }
        serializeWriter.write(string);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return BigIntegerCodec.deserialze(defaultJSONParser);
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            String string = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            if (string.length() > 65535) {
                throw new JSONException("decimal overflow");
            }
            return (T)new BigInteger(string);
        }
        Object object = defaultJSONParser.parse();
        return (T)(object == null ? null : TypeUtils.castToBigInteger(object));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

