/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.concurrent.atomic.AtomicBoolean;

public class BooleanCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final BooleanCodec instance = new BooleanCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        Boolean bl = (Boolean)object;
        if (bl == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullBooleanAsFalse);
            return;
        }
        if (bl.booleanValue()) {
            serializeWriter.write("true");
        } else {
            serializeWriter.write("false");
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Boolean bl;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        try {
            if (jSONLexer.token() == 6) {
                jSONLexer.nextToken(16);
                bl = Boolean.TRUE;
            } else if (jSONLexer.token() == 7) {
                jSONLexer.nextToken(16);
                bl = Boolean.FALSE;
            } else if (jSONLexer.token() == 2) {
                int n2 = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                bl = n2 == 1 ? Boolean.TRUE : Boolean.FALSE;
            } else {
                Object object2 = defaultJSONParser.parse();
                if (object2 == null) {
                    return null;
                }
                bl = TypeUtils.castToBoolean(object2);
            }
        }
        catch (Exception exception) {
            throw new JSONException("parseBoolean error, field : " + object, exception);
        }
        if (type == AtomicBoolean.class) {
            return (T)new AtomicBoolean(bl);
        }
        return (T)bl;
    }

    @Override
    public int getFastMatchToken() {
        return 6;
    }
}

