/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.JavaBeanSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class CollectionCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static final CollectionCodec instance = new CollectionCodec();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        Type type2 = null;
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) || SerializerFeature.isEnabled(n2, SerializerFeature.WriteClassName)) {
            type2 = TypeUtils.getCollectionItemType(type);
        }
        Collection collection = (Collection)object;
        SerialContext serialContext = jSONSerializer.c;
        jSONSerializer.setContext(serialContext, object, object2, 0);
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName)) {
            if (HashSet.class.isAssignableFrom(collection.getClass())) {
                serializeWriter.append("Set");
            } else if (TreeSet.class == collection.getClass()) {
                serializeWriter.append("TreeSet");
            }
        }
        try {
            int n3 = 0;
            serializeWriter.append('[');
            for (Object e2 : collection) {
                if (n3++ != 0) {
                    serializeWriter.append(',');
                }
                if (e2 == null) {
                    serializeWriter.writeNull();
                    continue;
                }
                Class<?> clazz = e2.getClass();
                if (clazz == Integer.class) {
                    serializeWriter.writeInt((Integer)e2);
                    continue;
                }
                if (clazz == Long.class) {
                    serializeWriter.writeLong((Long)e2);
                    if (!serializeWriter.isEnabled(SerializerFeature.WriteClassName)) continue;
                    serializeWriter.write(76);
                    continue;
                }
                ObjectSerializer objectSerializer = jSONSerializer.getObjectWriter(clazz);
                if (SerializerFeature.isEnabled(n2, SerializerFeature.WriteClassName) && objectSerializer instanceof JavaBeanSerializer) {
                    JavaBeanSerializer javaBeanSerializer = (JavaBeanSerializer)objectSerializer;
                    javaBeanSerializer.writeNoneASM(jSONSerializer, e2, n3 - 1, type2, n2);
                    continue;
                }
                objectSerializer.write(jSONSerializer, e2, n3 - 1, type2, n2);
            }
            serializeWriter.append(']');
        }
        finally {
            jSONSerializer.c = serialContext;
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        if (defaultJSONParser.lexer.token() == 8) {
            defaultJSONParser.lexer.nextToken(16);
            return null;
        }
        if (type == JSONArray.class) {
            JSONArray jSONArray = new JSONArray();
            defaultJSONParser.parseArray(jSONArray);
            return (T)jSONArray;
        }
        Collection collection = TypeUtils.createCollection(type);
        Type type2 = TypeUtils.getCollectionItemType(type);
        defaultJSONParser.parseArray(type2, collection, object);
        return (T)collection;
    }

    @Override
    public int getFastMatchToken() {
        return 14;
    }
}

