/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.deserializer.AbstractDateDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class DateCodec
extends AbstractDateDeserializer
implements ObjectDeserializer,
ObjectSerializer {
    public static final DateCodec instance = new DateCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        java.util.Date date;
        Cloneable cloneable;
        int n3;
        long l2;
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == Date.class && ((l2 = ((Date)object).getTime()) + (long)(n3 = ((TimeZone)(cloneable = jSONSerializer.d)).getOffset(l2))) % 86400000L == 0L && !SerializerFeature.isEnabled(serializeWriter.c, n2, SerializerFeature.WriteClassName)) {
            serializeWriter.writeString(object.toString());
            return;
        }
        if (clazz == Time.class) {
            l2 = ((Time)object).getTime();
            if ("unixtime".equals(jSONSerializer.getDateFormatPattern())) {
                long l3 = l2 / 1000L;
                serializeWriter.writeLong(l3);
                return;
            }
            if ("millis".equals(jSONSerializer.getDateFormatPattern())) {
                long l4 = l2;
                serializeWriter.writeLong(l2);
                return;
            }
            if (l2 < 86400000L) {
                serializeWriter.writeString(object.toString());
                return;
            }
        }
        int n4 = 0;
        if (clazz == Timestamp.class) {
            date = (Timestamp)object;
            n4 = ((Timestamp)date).getNanos();
        }
        date = object instanceof java.util.Date ? (java.util.Date)object : TypeUtils.castToDate(object);
        if ("unixtime".equals(jSONSerializer.getDateFormatPattern())) {
            long l5 = date.getTime() / 1000L;
            serializeWriter.writeLong(l5);
            return;
        }
        if ("millis".equals(jSONSerializer.getDateFormatPattern())) {
            long l6 = date.getTime();
            serializeWriter.writeLong(l6);
            return;
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteDateUseDateFormat)) {
            cloneable = jSONSerializer.getDateFormat();
            if (cloneable == null) {
                String string = jSONSerializer.getFastJsonConfigDateFormatPattern();
                if (string == null) {
                    string = JSON.DEFFAULT_DATE_FORMAT;
                }
                cloneable = new SimpleDateFormat(string, jSONSerializer.e);
                ((DateFormat)cloneable).setTimeZone(jSONSerializer.d);
            }
            String string = ((DateFormat)cloneable).format(date);
            serializeWriter.writeString(string);
            return;
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && clazz != type) {
            if (clazz == java.util.Date.class) {
                serializeWriter.write("new Date(");
                serializeWriter.writeLong(((java.util.Date)object).getTime());
                serializeWriter.write(41);
            } else {
                serializeWriter.write(123);
                serializeWriter.writeFieldName(JSON.DEFAULT_TYPE_KEY);
                jSONSerializer.write(clazz.getName());
                serializeWriter.writeFieldValue(',', "val", ((java.util.Date)object).getTime());
                serializeWriter.write(125);
            }
            return;
        }
        long l7 = date.getTime();
        if (serializeWriter.isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            int n5 = serializeWriter.isEnabled(SerializerFeature.UseSingleQuotes) ? 39 : 34;
            serializeWriter.write(n5);
            Calendar calendar = Calendar.getInstance(jSONSerializer.d, jSONSerializer.e);
            calendar.setTimeInMillis(l7);
            int n6 = calendar.get(1);
            int n7 = calendar.get(2) + 1;
            int n8 = calendar.get(5);
            int n9 = calendar.get(11);
            int n10 = calendar.get(12);
            int n11 = calendar.get(13);
            int n12 = calendar.get(14);
            if (n4 > 0) {
                cArray = "0000-00-00 00:00:00.000000000".toCharArray();
                IOUtils.getChars(n4, 29, cArray);
                IOUtils.getChars(n11, 19, cArray);
                IOUtils.getChars(n10, 16, cArray);
                IOUtils.getChars(n9, 13, cArray);
                IOUtils.getChars(n8, 10, cArray);
                IOUtils.getChars(n7, 7, cArray);
                IOUtils.getChars(n6, 4, cArray);
            } else if (n12 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n12, 23, cArray);
                IOUtils.getChars(n11, 19, cArray);
                IOUtils.getChars(n10, 16, cArray);
                IOUtils.getChars(n9, 13, cArray);
                IOUtils.getChars(n8, 10, cArray);
                IOUtils.getChars(n7, 7, cArray);
                IOUtils.getChars(n6, 4, cArray);
            } else if (n11 == 0 && n10 == 0 && n9 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n8, 10, cArray);
                IOUtils.getChars(n7, 7, cArray);
                IOUtils.getChars(n6, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n11, 19, cArray);
                IOUtils.getChars(n10, 16, cArray);
                IOUtils.getChars(n9, 13, cArray);
                IOUtils.getChars(n8, 10, cArray);
                IOUtils.getChars(n7, 7, cArray);
                IOUtils.getChars(n6, 4, cArray);
            }
            if (n4 > 0) {
                int n13;
                int n14;
                for (n14 = 0; n14 < 9 && cArray[n13 = cArray.length - n14 - 1] == '0'; ++n14) {
                }
                serializeWriter.write(cArray, 0, cArray.length - n14);
                serializeWriter.write(n5);
                return;
            }
            serializeWriter.write(cArray);
            float f2 = (float)calendar.getTimeZone().getOffset(calendar.getTimeInMillis()) / 3600000.0f;
            int n15 = (int)f2;
            if ((double)n15 == 0.0) {
                serializeWriter.write(90);
            } else {
                if (n15 > 9) {
                    serializeWriter.write(43);
                    serializeWriter.writeInt(n15);
                } else if (n15 > 0) {
                    serializeWriter.write(43);
                    serializeWriter.write(48);
                    serializeWriter.writeInt(n15);
                } else if (n15 < -9) {
                    serializeWriter.write(45);
                    serializeWriter.writeInt(-n15);
                } else if (n15 < 0) {
                    serializeWriter.write(45);
                    serializeWriter.write(48);
                    serializeWriter.writeInt(-n15);
                }
                serializeWriter.write(58);
                int n16 = (int)(Math.abs(f2 - (float)n15) * 60.0f);
                serializeWriter.append(String.format("%02d", n16));
            }
            serializeWriter.write(n5);
        } else {
            serializeWriter.writeLong(l7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T cast(DefaultJSONParser defaultJSONParser, Type type, Object object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof java.util.Date) {
            return (T)object2;
        }
        if (object2 instanceof BigDecimal) {
            return (T)new java.util.Date(TypeUtils.longValue((BigDecimal)object2));
        }
        if (object2 instanceof Number) {
            return (T)new java.util.Date(((Number)object2).longValue());
        }
        if (object2 instanceof String) {
            String string;
            TimeZone timeZone;
            Object object3;
            boolean bl;
            Object object4 = (String)object2;
            if (((String)object4).length() == 0) {
                return null;
            }
            if (((String)object4).length() == 23 && ((String)object4).endsWith(" 000")) {
                object4 = ((String)object4).substring(0, 19);
            }
            try (Object object5 = new JSONScanner((String)object4);){
                if (((JSONScanner)object5).scanISO8601DateIfMatch(false)) {
                    Calendar calendar = ((JSONLexerBase)object5).getCalendar();
                    if (type == Calendar.class) {
                        Calendar calendar2 = calendar;
                        return (T)calendar2;
                    }
                    java.util.Date date = calendar.getTime();
                    return (T)date;
                }
            }
            object5 = defaultJSONParser.getDateFomartPattern();
            boolean bl2 = bl = ((String)object4).length() == ((String)object5).length() || ((String)object4).length() == 22 && ((String)object5).equals("yyyyMMddHHmmssSSSZ") || ((String)object4).indexOf(84) != -1 && ((String)object5).contains("'T'") && ((String)object4).length() + 2 == ((String)object5).length();
            if (bl) {
                object3 = defaultJSONParser.getDateFormat();
                try {
                    return (T)((DateFormat)object3).parse((String)object4);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (((String)object4).startsWith("/Date(") && ((String)object4).endsWith(")/")) {
                object4 = object3 = ((String)object4).substring(6, ((String)object4).length() - 2);
            }
            if ("0000-00-00".equals(object4) || "0000-00-00T00:00:00".equalsIgnoreCase((String)object4) || "0001-01-01T00:00:00+08:00".equalsIgnoreCase((String)object4)) {
                return null;
            }
            int n2 = ((String)object4).lastIndexOf(124);
            if (n2 > 20 && !"GMT".equals((timeZone = TimeZone.getTimeZone(string = ((String)object4).substring(n2 + 1))).getID())) {
                String string2 = ((String)object4).substring(0, n2);
                try (JSONScanner jSONScanner = new JSONScanner(string2);){
                    if (jSONScanner.scanISO8601DateIfMatch(false)) {
                        Calendar calendar = jSONScanner.getCalendar();
                        calendar.setTimeZone(timeZone);
                        if (type == Calendar.class) {
                            Calendar calendar3 = calendar;
                            return (T)calendar3;
                        }
                        java.util.Date date = calendar.getTime();
                        return (T)date;
                    }
                }
            }
            long l2 = Long.parseLong((String)object4);
            return (T)new java.util.Date(l2);
        }
        throw new JSONException("parse error");
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

