/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.util.UTF8Decoder;
import java.lang.ref.SoftReference;
import java.nio.charset.CharsetDecoder;

public class ThreadLocalCache {
    public static final int CHARS_CACH_INIT_SIZE = 1024;
    public static final int CHARS_CACH_INIT_SIZE_EXP = 10;
    public static final int CHARS_CACH_MAX_SIZE = 131072;
    public static final int CHARS_CACH_MAX_SIZE_EXP = 17;
    private static final ThreadLocal<SoftReference<char[]>> b = new ThreadLocal();
    private static final ThreadLocal<CharsetDecoder> c = new ThreadLocal();
    public static final int BYTES_CACH_INIT_SIZE = 1024;
    public static final int BYTES_CACH_INIT_SIZE_EXP = 10;
    public static final int BYTES_CACH_MAX_SIZE = 131072;
    public static final int BYTES_CACH_MAX_SIZE_EXP = 17;
    private static final ThreadLocal<SoftReference<byte[]>> d = new ThreadLocal();

    public static CharsetDecoder getUTF8Decoder() {
        CharsetDecoder charsetDecoder = c.get();
        if (charsetDecoder == null) {
            charsetDecoder = new UTF8Decoder();
            c.set(charsetDecoder);
        }
        return charsetDecoder;
    }

    public static void clearChars() {
        b.set(null);
    }

    public static char[] getChars(int n2) {
        SoftReference<char[]> softReference = b.get();
        if (softReference == null) {
            return ThreadLocalCache.a(n2);
        }
        char[] cArray = softReference.get();
        if (cArray == null) {
            return ThreadLocalCache.a(n2);
        }
        if (cArray.length < n2) {
            cArray = ThreadLocalCache.a(n2);
        }
        return cArray;
    }

    private static char[] a(int n2) {
        if (n2 > 131072) {
            return new char[n2];
        }
        int n3 = ThreadLocalCache.a(10, 17, n2);
        char[] cArray = new char[n3];
        b.set(new SoftReference<char[]>(cArray));
        return cArray;
    }

    private static int a(int n2, int n3, int n4) {
        assert (1 << n3 >= n4);
        int n5 = n4 >>> n2;
        if (n5 <= 0) {
            return 1 << n2;
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(n4 - 1);
    }

    public static void clearBytes() {
        d.set(null);
    }

    public static byte[] getBytes(int n2) {
        SoftReference<byte[]> softReference = d.get();
        if (softReference == null) {
            return ThreadLocalCache.b(n2);
        }
        byte[] byArray = softReference.get();
        if (byArray == null) {
            return ThreadLocalCache.b(n2);
        }
        if (byArray.length < n2) {
            byArray = ThreadLocalCache.b(n2);
        }
        return byArray;
    }

    private static byte[] b(int n2) {
        if (n2 > 131072) {
            return new byte[n2];
        }
        int n3 = ThreadLocalCache.a(10, 17, n2);
        byte[] byArray = new byte[n3];
        d.set(new SoftReference<byte[]>(byArray));
        return byArray;
    }
}

