/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import java.io.FileDescriptor;

public class BitmapUtil {
    public static Bitmap getBitmap(String string, int n2, int n3) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapUtil.calculateSampleSize(options.outWidth, options.outHeight, n2, n3);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFile((String)string, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static Bitmap getBitmap(FileDescriptor fileDescriptor, int n2, int n3) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
            options.inSampleSize = BitmapUtil.calculateSampleSize(options.outWidth, options.outHeight, n2, n3);
            options.inJustDecodeBounds = false;
            return BitmapFactory.decodeFileDescriptor((FileDescriptor)fileDescriptor, null, (BitmapFactory.Options)options);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public static int calculateSampleSize(int n2, int n3, int n4, int n5) {
        int n6 = 1;
        if (n4 <= 0 && n5 <= 0) {
            return n6;
        }
        int n7 = n2;
        int n8 = n3;
        while (n7 / n6 > n4 && n8 / n6 > n5) {
            n6 *= 2;
        }
        return n6;
    }

    public static Bitmap blurBitmap(Context context, Bitmap bitmap) {
        try {
            Bitmap bitmap2 = Bitmap.createBitmap((int)(bitmap.getWidth() / 3), (int)(bitmap.getHeight() / 3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            RenderScript renderScript = RenderScript.create((Context)context);
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            Allocation allocation = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap);
            Allocation allocation2 = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap2);
            scriptIntrinsicBlur.setRadius(25.0f);
            scriptIntrinsicBlur.setInput(allocation);
            scriptIntrinsicBlur.forEach(allocation2);
            allocation2.copyTo(bitmap2);
            Canvas canvas = new Canvas(bitmap2);
            canvas.drawColor(0x33000000);
            renderScript.destroy();
            return bitmap2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

