/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.a.a;
import com.tradplus.ads.a.b;
import com.tradplus.ads.common.FSMoPubBrowser;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.util.LogUtil;
import java.util.List;

public class Intents {
    private Intents() {
    }

    public static void startActivity(@NonNull Context context, @NonNull Intent intent) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            throw new a(activityNotFoundException);
        }
    }

    public static Intent getStartActivityIntent(@NonNull Context context, @NonNull Class clazz, @Nullable Bundle bundle) {
        Intent intent = new Intent(context, clazz);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        if (bundle != null) {
            intent.putExtras(bundle);
        }
        return intent;
    }

    public static boolean deviceCanHandleIntent(@NonNull Context context, @NonNull Intent intent) {
        try {
            PackageManager packageManager = context.getPackageManager();
            List list = packageManager.queryIntentActivities(intent, 0);
            return !list.isEmpty();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static Intent intentForNativeBrowserScheme(@NonNull Uri uri) {
        String string;
        Preconditions.checkNotNull(uri);
        if (!UrlAction.OPEN_NATIVE_BROWSER.shouldTryHandlingUrl(uri)) {
            throw new b("URL does not have mopubnativebrowser:// scheme.");
        }
        if (!"navigate".equals(uri.getHost())) {
            throw new b("URL missing 'navigate' host parameter.");
        }
        try {
            string = uri.getQueryParameter("url");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LogUtil.show("Could not handle url: " + uri);
            throw new b("Passed-in URL did not create a hierarchical URI.");
        }
        if (string == null) {
            throw new b("URL missing 'url' query parameter.");
        }
        Uri uri2 = Uri.parse((String)string);
        return new Intent("android.intent.action.VIEW", uri2);
    }

    public static Intent intentForShareTweet(@NonNull Uri uri) {
        String string;
        String string2;
        if (!UrlAction.HANDLE_SHARE_TWEET.shouldTryHandlingUrl(uri)) {
            throw new b("URL does not have mopubshare://tweet? format.");
        }
        try {
            string2 = uri.getQueryParameter("screen_name");
            string = uri.getQueryParameter("tweet_id");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LogUtil.show("Could not handle url: " + uri);
            throw new b("Passed-in URL did not create a hierarchical URI.");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new b("URL missing non-empty 'screen_name' query parameter.");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new b("URL missing non-empty 'tweet_id' query parameter.");
        }
        String string3 = String.format("https://twitter.com/%s/status/%s", string2, string);
        String string4 = String.format("Check out @%s's Tweet: %s", string2, string3);
        Intent intent = new Intent("android.intent.action.SEND");
        intent.setType("text/plain");
        intent.putExtra("android.intent.extra.SUBJECT", string4);
        intent.putExtra("android.intent.extra.TEXT", string4);
        return intent;
    }

    public static void showMoPubBrowserForUrl(@NonNull Context context, @NonNull Uri uri, @Nullable String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        LogUtil.show("Final URI to show in browser: " + uri);
        Bundle bundle = new Bundle();
        bundle.putString("URL", uri.toString());
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("mopub-dsp-creative-id", string);
        }
        Intent intent = Intents.getStartActivityIntent(context, FSMoPubBrowser.class, bundle);
        String string2 = "Could not show FSMoPubBrowser for url: " + uri + "\n\tPerhaps you forgot to declare FSMoPubBrowser in your Android manifest file.";
        Intents.launchIntentForUserClick(context, intent, string2);
    }

    public static void showAdExpressBrowserForUrl(@NonNull Context context, @NonNull Uri uri, @Nullable String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        LogUtil.show("Final URI to show in browser: " + uri);
        Intent intent = new Intent();
        intent.setAction("android.intent.action.VIEW");
        intent.setData(uri);
        String string2 = "Could not show url: " + uri;
        Intents.launchIntentForUserClick(context, intent, string2);
    }

    public static void launchIntentForUserClick(@NonNull Context context, @NonNull Intent intent, @Nullable String string) {
        Preconditions.NoThrow.checkNotNull(context);
        Preconditions.NoThrow.checkNotNull(intent);
        try {
            Intents.startActivity(context, intent);
        }
        catch (a a2) {
            throw new a(string + "\n" + a2.getMessage());
        }
    }

    public static void launchApplicationUrl(@NonNull Context context, @NonNull Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        if (!Intents.deviceCanHandleIntent(context, intent)) {
            throw new a("Could not handle application specific action: " + uri + "\n\tYou may be running in the emulator or another device which does not have the required application.");
        }
        Intents.launchApplicationIntent(context, intent);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void launchApplicationIntent(@NonNull Context context, @NonNull Intent intent) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (Intents.deviceCanHandleIntent(context, intent)) {
            String string = "Unable to open intent: " + intent;
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            Intents.launchIntentForUserClick(context, intent, string);
            return;
        } else {
            String string = intent.getStringExtra("browser_fallback_url");
            if (TextUtils.isEmpty((CharSequence)string)) {
                if ("market".equalsIgnoreCase(intent.getScheme())) throw new a("Device could not handle neither intent nor market url.\nIntent: " + intent.toString());
                Intents.launchApplicationUrl(context, Intents.getPlayStoreUri(intent));
                return;
            } else {
                Uri uri = Uri.parse((String)string);
                String string2 = uri.getScheme();
                if ("http".equalsIgnoreCase(string2) || "https".equalsIgnoreCase(string2)) {
                    Intents.showMoPubBrowserForUrl(context, uri, null);
                    return;
                } else {
                    Intents.launchApplicationUrl(context, uri);
                }
            }
        }
    }

    @NonNull
    public static Uri getPlayStoreUri(@NonNull Intent intent) {
        Preconditions.checkNotNull(intent);
        return Uri.parse((String)("market://details?id=" + intent.getPackage()));
    }

    public static void launchActionViewIntent(@NonNull Context context, @NonNull Uri uri, @Nullable String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        Intents.launchIntentForUserClick(context, intent, string);
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri) {
        return false;
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri, boolean bl) {
        return false;
    }
}

