/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.text.TextUtils;
import com.tradplus.ads.common.util.LogUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Json {
    public static Map<String, String> jsonStringToMap(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return hashMap;
        }
        JSONObject jSONObject = (JSONObject)new JSONTokener(string).nextValue();
        Iterator iterator = jSONObject.keys();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            hashMap.put(string2, jSONObject.getString(string2));
        }
        return hashMap;
    }

    public static String mapToJsonString(Map<String, String> map) {
        if (map == null) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{");
        boolean bl = true;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!bl) {
                stringBuilder.append(",");
            }
            stringBuilder.append("\"");
            stringBuilder.append(entry.getKey());
            stringBuilder.append("\":\"");
            stringBuilder.append(entry.getValue());
            stringBuilder.append("\"");
            bl = false;
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public static String[] jsonArrayToStringArray(String string) {
        string = "{key:" + string + "}";
        try {
            JSONObject jSONObject = (JSONObject)new JSONTokener(string).nextValue();
            JSONArray jSONArray = jSONObject.getJSONArray("key");
            String[] stringArray = new String[jSONArray.length()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = jSONArray.getString(i2);
            }
            return stringArray;
        }
        catch (JSONException jSONException) {
            return new String[0];
        }
    }

    public static <T> T getJsonValue(JSONObject jSONObject, String string, Class<T> clazz) {
        if (jSONObject == null || string == null || clazz == null) {
            throw new IllegalArgumentException("Cannot pass any null argument to getJsonValue");
        }
        Object object = jSONObject.opt(string);
        if (object == null) {
            LogUtil.show("Tried to get Json value with key: " + string + ", but it was null");
            return null;
        }
        if (!clazz.isInstance(object)) {
            LogUtil.show("Tried to get Json value with key: " + string + ", of type: " + clazz.toString() + ", its type did not match");
            return null;
        }
        return clazz.cast(object);
    }
}

