/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.tradplus.ads.common.FSMoPubBrowser;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.Intents;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Utils;
import com.tradplus.ads.common.util.VersionCode;
import java.util.ArrayList;
import java.util.List;

public class ManifestUtils {
    private static final List<Class<? extends Activity>> a;
    private static b b;
    private static final List<Class<? extends Activity>> c;

    private ManifestUtils() {
    }

    public static void checkWebViewActivitiesDeclared(@NonNull Context context) {
        if (!Preconditions.NoThrow.checkNotNull(context, "context is not allowed to be null")) {
            return;
        }
        ManifestUtils.a(context, a);
        ManifestUtils.b(context, a);
    }

    public static void checkNativeActivitiesDeclared(@NonNull Context context) {
        if (!Preconditions.NoThrow.checkNotNull(context, "context is not allowed to be null")) {
            return;
        }
        ManifestUtils.a(context, c);
        ManifestUtils.b(context, c);
    }

    @VisibleForTesting
    static void a(@NonNull Context context, @NonNull List<Class<? extends Activity>> list) {
        List<Class<? extends Activity>> list2 = ManifestUtils.a(context, list, false);
        if (list2.isEmpty()) {
            return;
        }
        ManifestUtils.a(context);
        ManifestUtils.a(list2);
    }

    @VisibleForTesting
    static void b(@NonNull Context context, @NonNull List<Class<? extends Activity>> list) {
        List<Class<? extends Activity>> list2 = ManifestUtils.a(context, list, true);
        List<Class<? extends Activity>> list3 = ManifestUtils.c(context, list2);
        if (list3.isEmpty()) {
            return;
        }
        ManifestUtils.a(context);
        ManifestUtils.d(context, list3);
    }

    public static boolean isDebuggable(@NonNull Context context) {
        int n2 = context.getApplicationInfo().flags;
        return Utils.bitMaskContainsFlag(n2, 2);
    }

    private static List<Class<? extends Activity>> a(@NonNull Context context, @NonNull List<Class<? extends Activity>> list, boolean bl) {
        ArrayList<Class<? extends Activity>> arrayList = new ArrayList<Class<? extends Activity>>();
        for (Class<? extends Activity> clazz : list) {
            Intent intent = new Intent(context, clazz);
            if (Intents.deviceCanHandleIntent(context, intent) != bl) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    @TargetApi(value=13)
    private static List<Class<? extends Activity>> c(@NonNull Context context, @NonNull List<Class<? extends Activity>> list) {
        ArrayList<Class<? extends Activity>> arrayList = new ArrayList<Class<? extends Activity>>();
        for (Class<? extends Activity> clazz : list) {
            a a2;
            try {
                a2 = ManifestUtils.a(context, clazz);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                continue;
            }
            if (a2.hasKeyboardHidden && a2.hasOrientation && a2.hasScreenSize) continue;
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private static void a(@NonNull List<Class<? extends Activity>> list) {
        StringBuilder stringBuilder = new StringBuilder("AndroidManifest permissions for the following required TradPlus activities are missing:\n");
        for (Class<? extends Activity> clazz : list) {
            stringBuilder.append("\n\t").append(clazz.getName());
        }
        stringBuilder.append("\n\nPlease update your manifest to include them.");
        LogUtil.show(stringBuilder.toString());
    }

    private static void d(@NonNull Context context, @NonNull List<Class<? extends Activity>> list) {
        StringBuilder stringBuilder = new StringBuilder("In AndroidManifest, the android:configChanges param is missing values for the following TradPlus activities:\n");
        for (Class<? extends Activity> clazz : list) {
            a a2;
            try {
                a2 = ManifestUtils.a(context, clazz);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                continue;
            }
            if (!a2.hasKeyboardHidden) {
                stringBuilder.append("\n\tThe android:configChanges param for activity " + clazz.getName() + " must include keyboardHidden.");
            }
            if (!a2.hasOrientation) {
                stringBuilder.append("\n\tThe android:configChanges param for activity " + clazz.getName() + " must include orientation.");
            }
            if (a2.hasScreenSize) continue;
            stringBuilder.append("\n\tThe android:configChanges param for activity " + clazz.getName() + " must include screenSize.");
        }
        stringBuilder.append("\n\nPlease update your manifest to include them.");
        LogUtil.show(stringBuilder.toString());
    }

    private static a a(@NonNull Context context, @NonNull Class<? extends Activity> clazz) {
        ActivityInfo activityInfo = context.getPackageManager().getActivityInfo(new ComponentName(context, clazz.getName()), 0);
        a a2 = new a();
        a2.hasKeyboardHidden = b.hasFlag(clazz, activityInfo.configChanges, 32);
        a2.hasOrientation = b.hasFlag(clazz, activityInfo.configChanges, 128);
        a2.hasScreenSize = true;
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.HONEYCOMB_MR2) && context.getApplicationInfo().targetSdkVersion >= VersionCode.HONEYCOMB_MR2.getApiLevel()) {
            a2.hasScreenSize = b.hasFlag(clazz, activityInfo.configChanges, 1024);
        }
        return a2;
    }

    private static void a(@NonNull Context context) {
        if (ManifestUtils.isDebuggable(context)) {
            String string = "ERROR: YOUR MOPUB INTEGRATION IS INCOMPLETE.\nCheck logcat and update your AndroidManifest.xml with the correct activities and configuration.";
            Toast toast = Toast.makeText((Context)context, (CharSequence)"ERROR: YOUR MOPUB INTEGRATION IS INCOMPLETE.\nCheck logcat and update your AndroidManifest.xml with the correct activities and configuration.", (int)1);
            toast.setGravity(7, 0, 0);
            toast.show();
        }
    }

    static {
        b = new b();
        a = new ArrayList<Class<? extends Activity>>(4);
        try {
            Class<?> clazz = Class.forName("com.mopub.mobileads.MoPubActivity");
            Class<?> clazz2 = Class.forName("com.mopub.mobileads.MraidActivity");
            a.add(clazz);
            a.add(clazz2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogUtil.show("ManifestUtils running without interstitial module");
        }
        c = new ArrayList<Class<? extends Activity>>(1);
        c.add(FSMoPubBrowser.class);
    }

    static class b {
        b() {
        }

        public boolean hasFlag(Class clazz, int n2, int n3) {
            return Utils.bitMaskContainsFlag(n2, n3);
        }
    }

    private static class a {
        public boolean hasKeyboardHidden;
        public boolean hasOrientation;
        public boolean hasScreenSize;

        private a() {
        }
    }
}

