/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import androidx.annotation.NonNull;
import com.tradplus.ads.common.Preconditions;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class Reflection {
    public static Method getDeclaredMethodWithTraversal(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            try {
                return clazz2.getDeclaredMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        throw new NoSuchMethodException();
    }

    public static boolean classFound(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static <T> T instantiateClassWithEmptyConstructor(@NonNull String string, @NonNull Class<? extends T> clazz) {
        Preconditions.checkNotNull(string);
        Class<T> clazz2 = Class.forName(string).asSubclass(clazz);
        Constructor<T> constructor = clazz2.getDeclaredConstructor(null);
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    public static <T> T instantiateClassWithConstructor(@NonNull String string, @NonNull Class<? extends T> clazz, @NonNull Class[] classArray, @NonNull Object[] objectArray) {
        Preconditions.checkNotNull(string);
        Preconditions.checkNotNull(clazz);
        Preconditions.checkNotNull(classArray);
        Preconditions.checkNotNull(objectArray);
        Class<T> clazz2 = Class.forName(string).asSubclass(clazz);
        Constructor<T> constructor = clazz2.getDeclaredConstructor(classArray);
        constructor.setAccessible(true);
        return constructor.newInstance(objectArray);
    }

    public static class MethodBuilder {
        private final Object a;
        private final String b;
        private Class<?> c;
        private List<Class<?>> d;
        private List<Object> e;
        private boolean f;
        private boolean g;

        public MethodBuilder(Object object, String string) {
            this.a = object;
            this.b = string;
            this.d = new ArrayList();
            this.e = new ArrayList<Object>();
            this.c = object != null ? object.getClass() : null;
        }

        public <T> MethodBuilder addParam(Class<T> clazz, T t2) {
            this.d.add(clazz);
            this.e.add(t2);
            return this;
        }

        public MethodBuilder setAccessible() {
            this.f = true;
            return this;
        }

        public MethodBuilder setStatic(Class<?> clazz) {
            this.g = true;
            this.c = clazz;
            return this;
        }

        public Object execute() {
            Class[] classArray = new Class[this.d.size()];
            Class[] classArray2 = this.d.toArray(classArray);
            Method method = Reflection.getDeclaredMethodWithTraversal(this.c, this.b, classArray2);
            if (this.f) {
                method.setAccessible(true);
            }
            Object[] objectArray = this.e.toArray();
            if (this.g) {
                return method.invoke(null, objectArray);
            }
            return method.invoke(this.a, objectArray);
        }
    }
}

