/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.view.View;
import android.view.Window;
import androidx.annotation.NonNull;
import com.tradplus.ads.common.Preconditions;
import java.security.MessageDigest;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public class Utils {
    private static final AtomicLong a = new AtomicLong(1L);

    public static String sha1(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = string.getBytes("UTF-8");
            messageDigest.update(byArray, 0, byArray.length);
            for (byte by : byArray = messageDigest.digest()) {
                stringBuilder.append(String.format("%02X", by));
            }
            return stringBuilder.toString().toLowerCase(Locale.ENGLISH);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static long generateUniqueId() {
        long l2;
        long l3;
        do {
            if ((l2 = (l3 = a.get()) + 1L) <= 0x7FFFFFFFFFFFFFFEL) continue;
            l2 = 1L;
        } while (!a.compareAndSet(l3, l2));
        return l3;
    }

    public static boolean bitMaskContainsFlag(int n2, int n3) {
        return (n2 & n3) != 0;
    }

    public static void hideNavigationBar(@NonNull Activity activity) {
        Preconditions.checkNotNull(activity);
        Window window = activity.getWindow();
        if (window != null) {
            View view = window.getDecorView();
            Utils.b(view);
            view.setOnSystemUiVisibilityChangeListener(Utils.a(view));
        }
    }

    static View.OnSystemUiVisibilityChangeListener a(final @NonNull View view) {
        Preconditions.checkNotNull(view);
        return new View.OnSystemUiVisibilityChangeListener(){

            public void onSystemUiVisibilityChange(int n2) {
                if ((n2 & 2) == 0) {
                    Utils.b(view);
                }
            }
        };
    }

    static void b(@NonNull View view) {
        Preconditions.checkNotNull(view);
        view.setSystemUiVisibility(4870);
    }
}

