/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.mobileads.gdpr;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.util.Log;

public class CommonUtil {
    public static final String TAG = "CommonUtils";

    public static <T extends String> boolean isNullOrEmpty(T t2) {
        return t2 == null || t2.length() == 0;
    }

    public static <T extends String> boolean isNotNullOrEmpty(T t2) {
        return t2 != null && t2.length() > 0;
    }

    public static boolean isNetConnect(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            return networkInfo != null && networkInfo.isAvailable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int dip2px(Context context, float f2) {
        float f3 = context.getResources().getDisplayMetrics().density;
        return (int)(f2 * f3 + 0.5f);
    }

    public static boolean isGranted(String string, Context context) {
        boolean bl = false;
        try {
            PackageManager packageManager = context.getPackageManager();
            int n2 = packageManager.checkPermission(string, context.getPackageName());
            if (n2 == 0) {
                bl = true;
                Log.d((String)TAG, (String)("Permission " + string + " is granted"));
            } else {
                Log.d((String)TAG, (String)("Permission " + string + " is NOT granted"));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    public static int getResId(Context context, String string, String string2) {
        if (context != null) {
            return context.getResources().getIdentifier(string, string2, context.getPackageName());
        }
        return -1;
    }
}

