/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.nativeads.BaseNativeAd;
import com.tradplus.ads.nativeads.MoPubAdRenderer;
import com.tradplus.ads.nativeads.NativeAd;
import java.util.ArrayList;

public class AdRendererRegistry {
    @NonNull
    private final ArrayList<MoPubAdRenderer> a = new ArrayList();

    public void registerAdRenderer(@NonNull MoPubAdRenderer moPubAdRenderer) {
        this.a.add(moPubAdRenderer);
    }

    public int getAdRendererCount() {
        return this.a.size();
    }

    @NonNull
    public Iterable<MoPubAdRenderer> getRendererIterable() {
        return this.a;
    }

    public int getViewTypeForAd(@NonNull NativeAd nativeAd) {
        Preconditions.checkNotNull(nativeAd);
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            if (nativeAd.getMoPubAdRenderer() != this.a.get(i2)) continue;
            return i2 + 1;
        }
        return 0;
    }

    @Nullable
    public MoPubAdRenderer getRendererForAd(@NonNull BaseNativeAd baseNativeAd) {
        Preconditions.checkNotNull(baseNativeAd);
        for (MoPubAdRenderer moPubAdRenderer : this.a) {
            if (!moPubAdRenderer.supports(baseNativeAd)) continue;
            return moPubAdRenderer;
        }
        return null;
    }

    @Nullable
    public MoPubAdRenderer getRendererForViewType(int n2) {
        try {
            return this.a.get(n2 - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }
}

