/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.LogUtil;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;

public abstract class BaseNativeAd {
    @NonNull
    private final Set<String> a = new HashSet<String>();
    @NonNull
    private final Set<String> b = new HashSet<String>();
    @Nullable
    private NativeEventListener c;
    private boolean d = false;

    protected BaseNativeAd() {
    }

    public abstract void prepare(@NonNull View var1);

    public abstract void clear(@NonNull View var1);

    public abstract void destroy();

    public void setNativeEventListener(@Nullable NativeEventListener nativeEventListener) {
        this.c = nativeEventListener;
    }

    protected final void notifyAdImpressed() {
        if (this.c != null) {
            this.c.onAdImpressed();
        }
    }

    protected final void notifyAdClicked() {
        if (this.c != null) {
            this.c.onAdClicked();
        }
    }

    protected final void addImpressionTrackers(Object object) {
        if (!(object instanceof JSONArray)) {
            throw new ClassCastException("Expected impression trackers of type JSONArray.");
        }
        JSONArray jSONArray = (JSONArray)object;
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                this.addImpressionTracker(jSONArray.getString(i2));
                continue;
            }
            catch (JSONException jSONException) {
                LogUtil.show("Unable to parse impression trackers.");
            }
        }
    }

    protected final void addClickTrackers(Object object) {
        if (!(object instanceof JSONArray)) {
            throw new ClassCastException("Expected click trackers of type JSONArray.");
        }
        JSONArray jSONArray = (JSONArray)object;
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                this.addClickTracker(jSONArray.getString(i2));
                continue;
            }
            catch (JSONException jSONException) {
                LogUtil.show("Unable to parse click trackers.");
            }
        }
    }

    public final void addImpressionTracker(@NonNull String string) {
        if (!Preconditions.NoThrow.checkNotNull(string, "impressionTracker url is not allowed to be null")) {
            return;
        }
        this.a.add(string);
    }

    public final void addClickTracker(@NonNull String string) {
        if (!Preconditions.NoThrow.checkNotNull(string, "clickTracker url is not allowed to be null")) {
            return;
        }
        this.b.add(string);
    }

    public void invalidate() {
        this.d = true;
    }

    public boolean isInvalidated() {
        return this.d;
    }

    public static interface NativeEventListener {
        public void onAdImpressed();

        public void onAdClicked();
    }
}

