/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.VisibilityTracker;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.nativeads.ImpressionInterface;
import com.tradplus.ads.nativeads.e;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ImpressionTracker {
    @NonNull
    private final VisibilityTracker a;
    @NonNull
    private final Map<View, ImpressionInterface> b;
    @NonNull
    private final Map<View, e<ImpressionInterface>> c;
    @NonNull
    private final Handler d;
    @NonNull
    private final a e;
    @NonNull
    private final VisibilityTracker.VisibilityChecker f;
    @Nullable
    private VisibilityTracker.VisibilityTrackerListener g;

    public ImpressionTracker(@NonNull Context context) {
        this(new WeakHashMap<View, ImpressionInterface>(), new WeakHashMap<View, e<ImpressionInterface>>(), new VisibilityTracker.VisibilityChecker(), new VisibilityTracker(context), new Handler(Looper.getMainLooper()));
    }

    @VisibleForTesting
    ImpressionTracker(@NonNull Map<View, ImpressionInterface> map, @NonNull Map<View, e<ImpressionInterface>> map2, @NonNull VisibilityTracker.VisibilityChecker visibilityChecker, @NonNull VisibilityTracker visibilityTracker, @NonNull Handler handler) {
        this.b = map;
        this.c = map2;
        this.f = visibilityChecker;
        this.a = visibilityTracker;
        this.g = new VisibilityTracker.VisibilityTrackerListener(){

            @Override
            public void onVisibilityChanged(@NonNull List<View> list, @NonNull List<View> list2) {
                for (View view : list) {
                    ImpressionInterface impressionInterface = (ImpressionInterface)ImpressionTracker.this.b.get(view);
                    if (impressionInterface == null) {
                        ImpressionTracker.this.removeView(view);
                        continue;
                    }
                    e e2 = (e)ImpressionTracker.this.c.get(view);
                    if (e2 != null && impressionInterface.equals(e2.a)) continue;
                    ImpressionTracker.this.c.put(view, new e<ImpressionInterface>(impressionInterface));
                }
                for (View view : list2) {
                    ImpressionTracker.this.c.remove(view);
                }
                ImpressionTracker.this.a();
            }
        };
        this.a.setVisibilityTrackerListener(this.g);
        this.d = handler;
        this.e = new a();
    }

    public void addView(View view, @NonNull ImpressionInterface impressionInterface) {
        if (this.b.get(view) == impressionInterface) {
            return;
        }
        this.removeView(view);
        if (impressionInterface.isImpressionRecorded()) {
            return;
        }
        this.b.put(view, impressionInterface);
        this.a.addView(view, impressionInterface.getImpressionMinPercentageViewed(), impressionInterface.getImpressionMinVisiblePx());
    }

    public void removeView(View view) {
        this.b.remove(view);
        this.a(view);
        this.a.removeView(view);
    }

    public void clear() {
        this.b.clear();
        this.c.clear();
        this.a.clear();
        this.d.removeMessages(0);
    }

    public void destroy() {
        this.clear();
        this.a.destroy();
        this.g = null;
    }

    @VisibleForTesting
    void a() {
        if (this.d.hasMessages(0)) {
            return;
        }
        this.d.postDelayed((Runnable)this.e, 250L);
    }

    private void a(View view) {
        this.c.remove(view);
    }

    @VisibleForTesting
    class a
    implements Runnable {
        @NonNull
        private final ArrayList<View> b = new ArrayList();

        a() {
        }

        @Override
        public void run() {
            for (Map.Entry view : ImpressionTracker.this.c.entrySet()) {
                View view2 = (View)view.getKey();
                e e2 = (e)view.getValue();
                if (!ImpressionTracker.this.f.hasRequiredTimeElapsed(e2.b, ((ImpressionInterface)e2.a).getImpressionMinTimeViewed())) continue;
                ((ImpressionInterface)e2.a).recordImpression(view2);
                ((ImpressionInterface)e2.a).setImpressionRecorded();
                this.b.add(view2);
            }
            for (View view : this.b) {
                ImpressionTracker.this.removeView(view);
            }
            this.b.clear();
            if (!ImpressionTracker.this.c.isEmpty()) {
                ImpressionTracker.this.a();
            }
        }
    }
}

