/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.Dips;
import com.tradplus.ads.common.util.Drawables;
import com.tradplus.ads.common.util.Utils;
import com.tradplus.ads.mobileads.c.b;
import com.tradplus.ads.nativeads.VastVideoProgressBarWidget;

public class MediaLayout
extends RelativeLayout {
    @NonNull
    private volatile Mode a = Mode.IMAGE;
    @NonNull
    private MuteState b;
    @NonNull
    private ImageView c;
    @Nullable
    private TextureView d;
    @Nullable
    private ProgressBar e;
    @Nullable
    private ImageView f;
    @Nullable
    private ImageView g;
    @Nullable
    private ImageView h;
    @Nullable
    private VastVideoProgressBarWidget i;
    @Nullable
    private ImageView j;
    @Nullable
    private View k;
    @Nullable
    private Drawable l;
    @Nullable
    private Drawable m;
    private boolean n;
    private final int o;
    private final int p;
    private final int q;
    private final int r;

    public MediaLayout(@NonNull Context context) {
        this(context, null);
    }

    public MediaLayout(@NonNull Context context, @Nullable AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public MediaLayout(@NonNull Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        Preconditions.checkNotNull(context);
        this.b = MuteState.MUTED;
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.c = new ImageView(context);
        this.c.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.c.setScaleType(ImageView.ScaleType.CENTER_CROP);
        this.addView((View)this.c);
        this.o = Dips.asIntPixels(40.0f, context);
        this.p = Dips.asIntPixels(35.0f, context);
        this.q = Dips.asIntPixels(36.0f, context);
        this.r = Dips.asIntPixels(10.0f, context);
    }

    public void setSurfaceTextureListener(@Nullable TextureView.SurfaceTextureListener surfaceTextureListener) {
        if (this.d != null) {
            this.d.setSurfaceTextureListener(surfaceTextureListener);
            SurfaceTexture surfaceTexture = this.d.getSurfaceTexture();
            if (surfaceTexture != null && surfaceTextureListener != null) {
                surfaceTextureListener.onSurfaceTextureAvailable(surfaceTexture, this.d.getWidth(), this.d.getHeight());
            }
        }
    }

    public void initForVideo() {
        if (this.n) {
            return;
        }
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams.addRule(13);
        this.d = new TextureView(this.getContext());
        this.d.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.d.setId((int)Utils.generateUniqueId());
        this.addView((View)this.d);
        this.c.bringToFront();
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(this.o, this.o);
        layoutParams2.addRule(10);
        layoutParams2.addRule(11);
        this.e = new ProgressBar(this.getContext());
        this.e.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.e.setPadding(0, this.r, this.r, 0);
        this.e.setIndeterminate(true);
        this.addView((View)this.e);
        RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-1, this.p);
        layoutParams3.addRule(8, this.d.getId());
        this.g = new ImageView(this.getContext());
        this.g.setLayoutParams((ViewGroup.LayoutParams)layoutParams3);
        GradientDrawable gradientDrawable = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{b.a.a, b.a.b});
        this.g.setImageDrawable((Drawable)gradientDrawable);
        this.addView((View)this.g);
        RelativeLayout.LayoutParams layoutParams4 = new RelativeLayout.LayoutParams(-1, this.p);
        layoutParams4.addRule(6, this.d.getId());
        this.h = new ImageView(this.getContext());
        this.h.setLayoutParams((ViewGroup.LayoutParams)layoutParams4);
        GradientDrawable gradientDrawable2 = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{b.a.a, b.a.b});
        this.h.setImageDrawable((Drawable)gradientDrawable2);
        this.addView((View)this.h);
        this.i = new VastVideoProgressBarWidget(this.getContext());
        this.i.setAnchorId(this.d.getId());
        this.i.calibrateAndMakeVisible(1000, 0);
        this.addView((View)this.i);
        this.l = Drawables.NATIVE_MUTED.createDrawable(this.getContext());
        this.m = Drawables.NATIVE_UNMUTED.createDrawable(this.getContext());
        RelativeLayout.LayoutParams layoutParams5 = new RelativeLayout.LayoutParams(this.q, this.q);
        layoutParams5.addRule(9);
        layoutParams5.addRule(2, this.i.getId());
        this.j = new ImageView(this.getContext());
        this.j.setLayoutParams((ViewGroup.LayoutParams)layoutParams5);
        this.j.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        this.j.setPadding(this.r, this.r, this.r, this.r);
        this.j.setImageDrawable(this.l);
        this.addView((View)this.j);
        RelativeLayout.LayoutParams layoutParams6 = new RelativeLayout.LayoutParams(-1, -1);
        layoutParams6.addRule(13);
        this.k = new View(this.getContext());
        this.k.setLayoutParams((ViewGroup.LayoutParams)layoutParams6);
        this.k.setBackgroundColor(0);
        this.addView(this.k);
        RelativeLayout.LayoutParams layoutParams7 = new RelativeLayout.LayoutParams(this.o, this.o);
        layoutParams7.addRule(13);
        this.f = new ImageView(this.getContext());
        this.f.setLayoutParams((ViewGroup.LayoutParams)layoutParams7);
        this.f.setImageDrawable(Drawables.NATIVE_PLAY.createDrawable(this.getContext()));
        this.addView((View)this.f);
        this.n = true;
        this.a();
    }

    public void reset() {
        this.setMode(Mode.IMAGE);
        this.setPlayButtonClickListener(null);
        this.setMuteControlClickListener(null);
        this.setVideoClickListener(null);
    }

    protected void onMeasure(int n2, int n3) {
        int n4 = View.MeasureSpec.getMode((int)n2);
        int n5 = View.MeasureSpec.getMode((int)n3);
        int n6 = View.MeasureSpec.getSize((int)n2);
        int n7 = View.MeasureSpec.getSize((int)n3);
        int n8 = this.getMeasuredWidth();
        int n9 = this.getMeasuredHeight();
        int n10 = n4 == 0x40000000 ? n6 : (n4 == Integer.MIN_VALUE ? Math.min(n6, n8) : n8);
        int n11 = (int)(0.5625f * (float)n10);
        if (n5 == 0x40000000 && n7 < n11) {
            n11 = n7;
            n10 = (int)(1.7777778f * (float)n11);
        }
        if (Math.abs(n11 - n9) >= 2 || Math.abs(n10 - n8) >= 2) {
            this.getLayoutParams().width = n10;
            this.getLayoutParams().height = n11;
        }
        super.onMeasure(n2, n3);
    }

    public void setMainImageDrawable(@NonNull Drawable drawable2) {
        Preconditions.checkNotNull(drawable2);
        this.c.setImageDrawable(drawable2);
    }

    public void resetProgress() {
        if (this.i != null) {
            this.i.reset();
        }
    }

    public void updateProgress(int n2) {
        if (this.i != null) {
            this.i.updateProgress(n2);
        }
    }

    public TextureView getTextureView() {
        return this.d;
    }

    public void setMode(@NonNull Mode mode) {
        Preconditions.checkNotNull((Object)mode);
        this.a = mode;
        this.post(new Runnable(){

            @Override
            public void run() {
                MediaLayout.this.a();
            }
        });
    }

    @Nullable
    public ImageView getMainImageView() {
        return this.c;
    }

    public void setMuteControlClickListener(@Nullable View.OnClickListener onClickListener) {
        if (this.j != null) {
            this.j.setOnClickListener(onClickListener);
        }
    }

    public void setPlayButtonClickListener(@Nullable View.OnClickListener onClickListener) {
        if (this.f != null && this.k != null) {
            this.k.setOnClickListener(onClickListener);
            this.f.setOnClickListener(onClickListener);
        }
    }

    public void setVideoClickListener(@Nullable View.OnClickListener onClickListener) {
        if (this.d != null) {
            this.d.setOnClickListener(onClickListener);
        }
    }

    public void setMuteState(@NonNull MuteState muteState) {
        Preconditions.checkNotNull((Object)muteState);
        if (muteState == this.b) {
            return;
        }
        this.b = muteState;
        if (this.j != null) {
            switch (this.b) {
                case MUTED: {
                    this.j.setImageDrawable(this.l);
                    break;
                }
                default: {
                    this.j.setImageDrawable(this.m);
                }
            }
        }
    }

    private void a() {
        switch (this.a) {
            case IMAGE: {
                this.setMainImageVisibility(0);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(4);
                this.setPlayButtonVisibility(4);
                break;
            }
            case LOADING: {
                this.setMainImageVisibility(0);
                this.setLoadingSpinnerVisibility(0);
                this.setVideoControlVisibility(4);
                this.setPlayButtonVisibility(4);
                break;
            }
            case BUFFERING: {
                this.setMainImageVisibility(4);
                this.setLoadingSpinnerVisibility(0);
                this.setVideoControlVisibility(0);
                this.setPlayButtonVisibility(4);
            }
            case PLAYING: {
                this.setMainImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(0);
                this.setPlayButtonVisibility(4);
                break;
            }
            case PAUSED: {
                this.setMainImageVisibility(4);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(0);
                this.setPlayButtonVisibility(0);
                break;
            }
            case FINISHED: {
                this.setMainImageVisibility(0);
                this.setLoadingSpinnerVisibility(4);
                this.setVideoControlVisibility(4);
                this.setPlayButtonVisibility(0);
                break;
            }
        }
    }

    private void setMainImageVisibility(int n2) {
        this.c.setVisibility(n2);
    }

    private void setLoadingSpinnerVisibility(int n2) {
        if (this.e != null) {
            this.e.setVisibility(n2);
        }
        if (this.h != null) {
            this.h.setVisibility(n2);
        }
    }

    private void setVideoControlVisibility(int n2) {
        if (this.g != null) {
            this.g.setVisibility(n2);
        }
        if (this.i != null) {
            this.i.setVisibility(n2);
        }
        if (this.j != null) {
            this.j.setVisibility(n2);
        }
    }

    private void setPlayButtonVisibility(int n2) {
        if (this.f != null && this.k != null) {
            this.f.setVisibility(n2);
            this.k.setVisibility(n2);
        }
    }

    public static enum MuteState {
        MUTED,
        UNMUTED;

    }

    public static enum Mode {
        IMAGE,
        PLAYING,
        LOADING,
        BUFFERING,
        PAUSED,
        FINISHED;

    }
}

