/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.nativeads.ClickInterface;
import com.tradplus.ads.nativeads.d;

public class NativeClickHandler {
    @NonNull
    private final Context a;
    @Nullable
    private final String b;
    private boolean c;

    public NativeClickHandler(@NonNull Context context) {
        this(context, null);
    }

    public NativeClickHandler(@NonNull Context context, @Nullable String string) {
        Preconditions.checkNotNull(context);
        this.a = context.getApplicationContext();
        this.b = string;
    }

    public void setOnClickListener(@NonNull View view, final @NonNull ClickInterface clickInterface) {
        if (!Preconditions.NoThrow.checkNotNull(view, "Cannot set click listener on a null view")) {
            return;
        }
        if (!Preconditions.NoThrow.checkNotNull(clickInterface, "Cannot set click listener with a null ClickInterface")) {
            return;
        }
        this.a(view, new View.OnClickListener(){

            public void onClick(View view) {
                clickInterface.handleClick(view);
            }
        });
    }

    private void a(@NonNull View view, @Nullable View.OnClickListener onClickListener) {
        view.setOnClickListener(onClickListener);
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            for (int i2 = 0; i2 < viewGroup.getChildCount(); ++i2) {
                this.a(viewGroup.getChildAt(i2), onClickListener);
            }
        }
    }

    public void clearOnClickListener(@NonNull View view) {
        if (!Preconditions.NoThrow.checkNotNull(view, "Cannot clear click listener from a null view")) {
            return;
        }
        this.a(view, null);
    }

    public void openClickDestinationUrl(@NonNull String string, @Nullable View view) {
        this.a(string, view, new d(this.a));
    }

    @VisibleForTesting
    void a(@NonNull String string, final @Nullable View view, final @NonNull d d2) {
        if (!Preconditions.NoThrow.checkNotNull(string, "Cannot open a null click destination url")) {
            return;
        }
        Preconditions.checkNotNull((Object)d2);
        if (this.c) {
            return;
        }
        this.c = true;
        if (view != null) {
            d2.a(view);
        }
        UrlHandler.Builder builder = new UrlHandler.Builder();
        if (!TextUtils.isEmpty((CharSequence)this.b)) {
            builder.withDspCreativeId(this.b);
        }
        builder.withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_APP_MARKET, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK).withResultActions(new UrlHandler.ResultActions(){

            @Override
            public void urlHandlingSucceeded(@NonNull String string, @NonNull UrlAction urlAction) {
                this.a();
                NativeClickHandler.this.c = false;
            }

            @Override
            public void urlHandlingFailed(@NonNull String string, @NonNull UrlAction urlAction) {
                this.a();
                NativeClickHandler.this.c = false;
            }

            private void a() {
                if (view != null) {
                    d2.a();
                }
            }
        }).build().handleUrl(this.a, string);
    }
}

