/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.content.Context;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.NativeImageHelper;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.util.Drawables;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Map;

public class NativeRendererHelper {
    public static void addTextView(@Nullable TextView textView, @Nullable String string) {
        if (textView == null) {
            LogUtil.show("Attempted to add text (" + string + ") to null TextView.");
            return;
        }
        textView.setText(null);
        if (string == null) {
            LogUtil.show("Attempted to set TextView contents to null.");
        } else {
            textView.setText((CharSequence)string);
        }
    }

    public static void addButton(@Nullable Button button, @Nullable String string) {
        if (button == null) {
            LogUtil.show("Attempted to add text (" + string + ") to null TextView.");
            return;
        }
        button.setText(null);
        if (string == null) {
            LogUtil.show("Attempted to set TextView contents to null.");
        } else {
            button.setText((CharSequence)string);
        }
    }

    public static void addPrivacyInformationIcon(ImageView imageView, String string, final String string2) {
        if (imageView == null) {
            return;
        }
        if (string2 == null) {
            imageView.setImageDrawable(null);
            imageView.setOnClickListener(null);
            imageView.setVisibility(4);
            return;
        }
        final Context context = imageView.getContext();
        if (context == null) {
            return;
        }
        if (string == null) {
            imageView.setImageDrawable(Drawables.NATIVE_PRIVACY_INFORMATION_ICON.createDrawable(context));
        } else {
            NativeImageHelper.loadImageView(string, imageView);
        }
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                new UrlHandler.Builder().withSupportedUrlActions(UrlAction.IGNORE_ABOUT_SCHEME, UrlAction.OPEN_NATIVE_BROWSER, UrlAction.OPEN_IN_APP_BROWSER, UrlAction.HANDLE_SHARE_TWEET, UrlAction.FOLLOW_DEEP_LINK_WITH_FALLBACK, UrlAction.FOLLOW_DEEP_LINK).build().handleUrl(context, string2);
            }
        });
        imageView.setVisibility(0);
    }

    public static void addCtaButton(@Nullable TextView textView, final @Nullable View view, @Nullable String string) {
        NativeRendererHelper.addTextView(textView, string);
        if (textView == null || view == null) {
            return;
        }
        textView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view2) {
                view.performClick();
            }
        });
    }

    public static void updateExtras(@Nullable View view, @NonNull Map<String, Integer> map, @NonNull Map<String, Object> map2) {
        if (view == null) {
            LogUtil.show("Attempted to bind extras on a null main view.");
            return;
        }
        for (String string : map.keySet()) {
            int n2 = map.get(string);
            View view2 = view.findViewById(n2);
            Object object = map2.get(string);
            if (view2 instanceof ImageView) {
                ((ImageView)view2).setImageDrawable(null);
                Object object2 = map2.get(string);
                if (object2 == null || !(object2 instanceof String)) continue;
                NativeImageHelper.loadImageView((String)object2, (ImageView)view2);
                continue;
            }
            if (view2 instanceof TextView) {
                ((TextView)view2).setText(null);
                if (!(object instanceof String)) continue;
                NativeRendererHelper.addTextView((TextView)view2, (String)object);
                continue;
            }
            LogUtil.show("View bound to " + string + " should be an instance of TextView or ImageView.");
        }
    }
}

