/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.NativeImageHelper;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Numbers;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.nativeads.CustomEventNative;
import com.tradplus.ads.nativeads.ImpressionTracker;
import com.tradplus.ads.nativeads.NativeClickHandler;
import com.tradplus.ads.nativeads.StaticNativeAd;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class TradPlusCustomEventNative
extends CustomEventNative {
    public static final String ADAPTER_NAME = TradPlusCustomEventNative.class.getSimpleName();
    private a a;

    @Override
    protected void loadNativeAd(@NonNull Context context, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener, @NonNull Map<String, Object> map, @NonNull Map<String, String> map2) {
        LogUtil.show(ADAPTER_NAME);
        if (this.a != null && !this.a.isInvalidated()) {
            return;
        }
        Object object = map.get("com_mopub_native_json");
        if (!(object instanceof JSONObject)) {
            LogUtil.show(ADAPTER_NAME + (Object)((Object)TradPlusErrorCode.INVALID_RESPONSE));
            customEventNativeListener.onNativeAdFailed(TradPlusErrorCode.INVALID_RESPONSE);
            return;
        }
        this.a = new a(context, (JSONObject)object, new ImpressionTracker(context), new NativeClickHandler(context), customEventNativeListener);
        if (map2.containsKey("Impression-Min-Visible-Percent")) {
            try {
                this.a.setImpressionMinPercentageViewed(Integer.parseInt(map2.get("Impression-Min-Visible-Percent")));
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.show(ADAPTER_NAME, "Unable to format min visible percent: " + map2.get("Impression-Min-Visible-Percent"));
            }
        }
        if (map2.containsKey("Impression-Visible-Ms")) {
            try {
                this.a.setImpressionMinTimeViewed(Integer.parseInt(map2.get("Impression-Visible-Ms")));
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.show(ADAPTER_NAME, "Unable to format min time: " + map2.get("Impression-Visible-Ms"));
            }
        }
        if (map2.containsKey("impression-min-visible-px")) {
            try {
                this.a.setImpressionMinVisiblePx(Integer.parseInt(map2.get("impression-min-visible-px")));
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.show(ADAPTER_NAME, "Unable to format min visible px: " + map2.get("impression-min-visible-px"));
            }
        }
        try {
            this.a.a();
            LogUtil.show(ADAPTER_NAME);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogUtil.show(ADAPTER_NAME + (Object)((Object)TradPlusErrorCode.UNSPECIFIED));
            customEventNativeListener.onNativeAdFailed(TradPlusErrorCode.UNSPECIFIED);
        }
    }

    @Override
    protected void onInvalidate() {
        if (this.a == null) {
            return;
        }
        this.a.invalidate();
    }

    static class com.tradplus.ads.nativeads.TradPlusCustomEventNative$a
    extends StaticNativeAd {
        @NonNull
        private final Context a;
        @NonNull
        private final CustomEventNative.CustomEventNativeListener b;
        @NonNull
        private final JSONObject c;
        @NonNull
        private final ImpressionTracker d;
        @NonNull
        private final NativeClickHandler e;

        com.tradplus.ads.nativeads.TradPlusCustomEventNative$a(@NonNull Context context, @NonNull JSONObject jSONObject, @NonNull ImpressionTracker impressionTracker, @NonNull NativeClickHandler nativeClickHandler, @NonNull CustomEventNative.CustomEventNativeListener customEventNativeListener) {
            this.c = jSONObject;
            this.a = context.getApplicationContext();
            this.d = impressionTracker;
            this.e = nativeClickHandler;
            this.b = customEventNativeListener;
        }

        void a() {
            if (!this.a(this.c)) {
                throw new IllegalArgumentException("JSONObject did not contain required keys.");
            }
            Iterator iterator = this.c.keys();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                a a2 = a.a(string);
                if (a2 != null) {
                    try {
                        this.a(a2, this.c.opt(string));
                        continue;
                    }
                    catch (ClassCastException classCastException) {
                        throw new IllegalArgumentException("JSONObject key (" + string + ") contained unexpected value.");
                    }
                }
                this.addExtra(string, this.c.opt(string));
            }
            if (TextUtils.isEmpty((CharSequence)this.getPrivacyInformationIconClickThroughUrl())) {
                this.setPrivacyInformationIconClickThroughUrl("https://www.mopub.com/optout");
            }
            NativeImageHelper.preCacheImages(this.a, this.c(), new NativeImageHelper.ImageListener(){

                @Override
                public void onImagesCached() {
                    if (a.this.isInvalidated()) {
                        return;
                    }
                    a.this.b.onNativeAdLoaded(a.this);
                }

                @Override
                public void onImagesFailedToCache(TradPlusErrorCode tradPlusErrorCode) {
                    if (a.this.isInvalidated()) {
                        return;
                    }
                    a.this.b.onNativeAdFailed(tradPlusErrorCode);
                }
            });
        }

        private boolean a(@NonNull JSONObject jSONObject) {
            HashSet hashSet = new HashSet();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                hashSet.add(iterator.next());
            }
            return hashSet.containsAll(a.c);
        }

        private void a(@NonNull a a2, @Nullable Object object) {
            try {
                switch (a2) {
                    case MAIN_IMAGE: {
                        this.setMainImageUrl((String)object);
                        break;
                    }
                    case ICON_IMAGE: {
                        this.setIconImageUrl((String)object);
                        break;
                    }
                    case IMPRESSION_TRACKER: {
                        this.addImpressionTrackers(object);
                        break;
                    }
                    case CLICK_DESTINATION: {
                        this.setClickDestinationUrl((String)object);
                        break;
                    }
                    case CLICK_TRACKER: {
                        this.a(object);
                        break;
                    }
                    case CALL_TO_ACTION: {
                        this.setCallToAction((String)object);
                        break;
                    }
                    case TITLE: {
                        this.setTitle((String)object);
                        break;
                    }
                    case TEXT: {
                        this.setText((String)object);
                        break;
                    }
                    case STAR_RATING: {
                        this.setStarRating(Numbers.parseDouble(object));
                        break;
                    }
                    case PRIVACY_INFORMATION_ICON_IMAGE_URL: {
                        this.setPrivacyInformationIconImageUrl((String)object);
                        break;
                    }
                    case PRIVACY_INFORMATION_ICON_CLICKTHROUGH_URL: {
                        this.setPrivacyInformationIconClickThroughUrl((String)object);
                        break;
                    }
                    default: {
                        LogUtil.show(ADAPTER_NAME, "Unable to add JSON key to internal mapping: " + a2.a);
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                if (!a2.b) {
                    LogUtil.show(ADAPTER_NAME, "Ignoring class cast exception for optional key: " + a2.a);
                }
                throw classCastException;
            }
        }

        private void a(@NonNull Object object) {
            if (object instanceof JSONArray) {
                this.addClickTrackers(object);
            } else {
                this.addClickTracker((String)object);
            }
        }

        private boolean a(@Nullable String string) {
            return string != null && string.toLowerCase(Locale.ENGLISH).endsWith("image");
        }

        @NonNull
        List<String> b() {
            ArrayList<String> arrayList = new ArrayList<String>(this.getExtras().size());
            for (Map.Entry<String, Object> entry : this.getExtras().entrySet()) {
                if (!this.a(entry.getKey()) || !(entry.getValue() instanceof String)) continue;
                arrayList.add((String)entry.getValue());
            }
            return arrayList;
        }

        @NonNull
        List<String> c() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (!TextUtils.isEmpty((CharSequence)this.getMainImageUrl())) {
                arrayList.add(this.getMainImageUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getIconImageUrl())) {
                arrayList.add(this.getIconImageUrl());
            }
            if (!TextUtils.isEmpty((CharSequence)this.getPrivacyInformationIconImageUrl())) {
                arrayList.add(this.getPrivacyInformationIconImageUrl());
            }
            arrayList.addAll(this.b());
            return arrayList;
        }

        @Override
        public void prepare(@NonNull View view) {
            this.d.addView(view, this);
            this.e.setOnClickListener(view, this);
        }

        @Override
        public void clear(@NonNull View view) {
            this.d.removeView(view);
            this.e.clearOnClickListener(view);
        }

        @Override
        public void destroy() {
            this.d.destroy();
            super.destroy();
        }

        @Override
        public void recordImpression(@NonNull View view) {
            this.notifyAdImpressed();
        }

        @Override
        public void handleClick(@Nullable View view) {
            LogUtil.show(ADAPTER_NAME);
            this.notifyAdClicked();
            this.e.openClickDestinationUrl(this.getClickDestinationUrl(), view);
        }

        static enum a {
            IMPRESSION_TRACKER("imptracker", true),
            CLICK_TRACKER("clktracker", true),
            TITLE("title", false),
            TEXT("text", false),
            MAIN_IMAGE("mainimage", false),
            ICON_IMAGE("iconimage", false),
            CLICK_DESTINATION("clk", false),
            FALLBACK("fallback", false),
            CALL_TO_ACTION("ctatext", false),
            STAR_RATING("starrating", false),
            PRIVACY_INFORMATION_ICON_IMAGE_URL("privacyicon", false),
            PRIVACY_INFORMATION_ICON_CLICKTHROUGH_URL("privacyclkurl", false);

            @NonNull
            final String a;
            final boolean b;
            @NonNull
            @VisibleForTesting
            static final Set<String> c;

            private a(@NonNull String string2, boolean bl) {
                this.a = string2;
                this.b = bl;
            }

            @Nullable
            static a a(@NonNull String string) {
                for (a a2 : com.tradplus.ads.nativeads.TradPlusCustomEventNative$a$a.values()) {
                    if (!a2.a.equals(string)) continue;
                    return a2;
                }
                return null;
            }

            static {
                c = new HashSet<String>();
                for (a a2 : com.tradplus.ads.nativeads.TradPlusCustomEventNative$a$a.values()) {
                    if (!a2.b) continue;
                    c.add(a2.a);
                }
            }
        }
    }
}

