/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.content.Context;
import android.os.Environment;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.CustomLogUtils;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.FrequencyUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.TradPlusWebViewAdUrlGenerator;
import com.tradplus.ads.nativeads.AdRendererRegistry;
import com.tradplus.ads.nativeads.MoPubAdRenderer;
import com.tradplus.ads.nativeads.NativeAd;
import com.tradplus.ads.network.FSAdRequest;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.pushcenter.PushCenter;
import com.tradplus.ads.pushcenter.reqeust.AdconfRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.pushcenter.utils.SendMessageUtil;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.VolleyError;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

public class TradPlusNative {
    static final MoPubNativeNetworkListener a = new MoPubNativeNetworkListener(){

        @Override
        public void onNativeLoad(@NonNull NativeAd nativeAd) {
            nativeAd.destroy();
        }

        @Override
        public void onNativeFail(TradPlusErrorCode tradPlusErrorCode) {
        }

        @Override
        public void onNativeClick(String string) {
        }
    };
    @NonNull
    private final WeakReference<Context> c;
    @NonNull
    private final String d;
    @NonNull
    private MoPubNativeNetworkListener e;
    @NonNull
    private Map<String, Object> f = new TreeMap<String, Object>();
    @NonNull
    AdRendererRegistry b;
    @Nullable
    private TradPlusWebViewAdUrlGenerator g;
    @NonNull
    private final FSAdRequest.Listener h;
    @Nullable
    private AdconfRequest i;
    @Nullable
    private FSAdRequest j;
    private int k;
    private Integer l;
    private ArrayList<ConfigResponse.WaterfallBean> m;
    private ConfigResponse n;

    public TradPlusNative(@NonNull Context context, @NonNull String string, @NonNull MoPubNativeNetworkListener moPubNativeNetworkListener) {
        this(context, string, new AdRendererRegistry(), moPubNativeNetworkListener);
    }

    @VisibleForTesting
    public TradPlusNative(@NonNull Context context, @NonNull String string, @NonNull AdRendererRegistry adRendererRegistry, @NonNull MoPubNativeNetworkListener moPubNativeNetworkListener) {
        Preconditions.checkNotNull(context, "context may not be null.");
        Preconditions.checkNotNull(string, "AdUnitId may not be null.");
        Preconditions.checkNotNull(adRendererRegistry, "AdRendererRegistry may not be null.");
        Preconditions.checkNotNull(moPubNativeNetworkListener, "MoPubNativeNetworkListener may not be null.");
        this.c = new WeakReference<Context>(context);
        this.d = string;
        this.h = new FSAdRequest.Listener(){

            @Override
            public void onSuccess(ConfigResponse configResponse) {
                if (configResponse != null) {
                    TradPlusNative.this.a(false, configResponse);
                } else if (TradPlusNative.this.e != null) {
                    TradPlusNative.this.e.onNativeFail(TradPlusErrorCode.UNSPECIFIED);
                }
            }

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                TradPlusNative.this.b(volleyError);
            }
        };
        this.m = new ArrayList();
        this.e = moPubNativeNetworkListener;
        this.b = adRendererRegistry;
    }

    private void a(boolean bl, ConfigResponse configResponse) {
        if (this.n != null) {
            this.i.setRt(RequestUtils.getInstance().countRuntime(this.i.getCreateTime()) + "");
            this.i.setEc("1");
            if (bl) {
                this.i.setCf("2");
            } else {
                this.i.setCf("1");
            }
            if (configResponse.getCode() != null) {
                if (!configResponse.getCode().equals("0")) {
                    CustomLogUtils.getInstance().log(CustomLogUtils.TradPlusLog.APPID_MATCH_ADUNITAD);
                }
                this.i.setSc(configResponse.getCode());
            }
            PushCenter.getInstance().sendMessageToCenter((Context)this.c.get(), this.i, PushMessageUtils.Type.EV_TRADPLUS.getValue());
            try {
                if (this.n != null && this.n.getStatus() == 0) {
                    int n2;
                    this.k = n2 = this.n.getCacheNum();
                    FrequencyUtils.getInstance().saveFrequency((Context)this.c.get(), this.n.getFrequency(), this.d, PushMessageUtils.Type.EV_TRADPLUS.getValue());
                    FrequencyUtils.getInstance().saveFrequencyLoadTime((Context)this.c.get(), this.d, PushMessageUtils.Type.EV_TRADPLUS.getValue());
                    this.a();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.i.setRt(RequestUtils.getInstance().countRuntime(this.i.getCreateTime()) + "");
            if (bl) {
                this.i.setCf("2");
            } else {
                this.i.setCf("1");
            }
            this.i.setEc("10");
            PushCenter.getInstance().sendMessageToCenter((Context)this.c.get(), this.i, PushMessageUtils.Type.EV_TRADPLUS.getValue());
            if (this.e != null) {
                this.e.onNativeFail(TradPlusErrorCode.NO_CONFIG);
            }
        }
    }

    private void b(VolleyError volleyError) {
        this.i.setRt(RequestUtils.getInstance().countRuntime(this.i.getCreateTime()) + "");
        this.i.setCf("1");
        if (volleyError.networkResponse != null) {
            this.i.setEc(RequestUtils.getInstance().getNetWorkStatus(volleyError.networkResponse.statusCode));
        } else {
            this.i.setEc("7");
        }
        PushCenter.getInstance().sendMessageToCenter((Context)this.c.get(), this.i, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        try {
            this.a(volleyError);
        }
        catch (Exception exception) {
            this.a(volleyError);
        }
    }

    @VisibleForTesting
    void a() {
        this.b();
        this.m.clear();
        for (int i2 = 0; i2 < this.n.getWaterfall().size(); ++i2) {
            this.m.add(this.n.getWaterfall().get(i2));
        }
        if (this.m.size() < 1) {
            return;
        }
        this.l = this.k < this.m.size() ? Integer.valueOf(this.k) : Integer.valueOf(this.m.size());
        this.d();
    }

    private void d() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.m.size() > 1) {
            hashMap.put("passScan", "pass");
        } else {
            hashMap.put("passScan", "keep");
        }
    }

    public String getPlacementId() {
        return "";
    }

    public String getPlacementId(boolean bl) {
        if (this.m.size() > 0) {
            String string = this.m.get(0).getAdsource_placement_id();
            if (string == null) {
                string = "";
            }
            return string;
        }
        return "";
    }

    public String getCustomName() {
        if (this.m != null && this.m.size() > 0) {
            return this.m.get(0).getName();
        }
        return "";
    }

    void b() {
        if (this.j != null) {
            if (!this.j.isCanceled()) {
                this.j.cancel();
            }
            this.j = null;
        }
    }

    public void registerAdRenderer(MoPubAdRenderer moPubAdRenderer) {
        this.b.registerAdRenderer(moPubAdRenderer);
    }

    public void destroy() {
        this.c.clear();
        if (this.j != null) {
            this.j.cancel();
            this.j = null;
        }
        this.e = a;
    }

    public void setLocalExtras(@Nullable Map<String, Object> map) {
        this.f = map == null ? new TreeMap<String, Object>() : new TreeMap<String, Object>(map);
    }

    private boolean a(Context context) {
        return "mounted".equals(Environment.getExternalStorageState()) && DeviceUtils.isPermissionGranted(context, "android.permission.WRITE_EXTERNAL_STORAGE");
    }

    public void makeRequest() {
        this.makeRequest(null);
    }

    public void makeRequest(@Nullable Integer n2) {
        if (this.c.get() == null) {
            return;
        }
        if (!DeviceUtils.isNetworkAvailable((Context)this.c.get())) {
            this.e.onNativeFail(TradPlusErrorCode.CONNECTION_ERROR);
            return;
        }
        this.a(n2);
    }

    private void a(@Nullable Integer n2) {
        if (this.c.get() == null) {
            return;
        }
        this.a(this.e());
    }

    private String e() {
        this.g = new TradPlusWebViewAdUrlGenerator((Context)this.c.get(), this.a((Context)this.c.get()));
        String string = this.c();
        if (string != null) {
            LogUtil.ownShow("TradPlus Native Loading ad from: " + string);
        }
        return string;
    }

    @Nullable
    String c() {
        return this.g == null ? null : this.g.withAdUnitId(this.d).withKeywords("").withLocation(null).generateUrlString("api.tradplusad.com");
    }

    void a(@Nullable String string) {
        if (this.c.get() == null) {
            return;
        }
        SendMessageUtil.getInstance().sendLoadAdconfStart((Context)this.c.get(), this.d, true);
        this.i = new AdconfRequest((Context)this.c.get(), PushMessageUtils.PushStatus.EV_PRE_LOAD_ADCONF.getValue());
        this.i.setRt(RequestUtils.getInstance().countRuntime(this.i.getCreateTime()) + "");
        this.i.setLuid(this.d);
    }

    @VisibleForTesting
    void a(@NonNull VolleyError volleyError) {
        LogUtil.show("Native ad request failed." + volleyError);
        NetworkResponse networkResponse = volleyError.networkResponse;
        if (networkResponse != null && networkResponse.statusCode >= 500 && networkResponse.statusCode < 600) {
            this.e.onNativeFail(TradPlusErrorCode.SERVER_ERROR_RESPONSE_CODE);
        } else if (networkResponse == null && !DeviceUtils.isNetworkAvailable((Context)this.c.get())) {
            this.e.onNativeFail(TradPlusErrorCode.CONNECTION_ERROR);
        } else {
            this.e.onNativeFail(TradPlusErrorCode.UNSPECIFIED);
        }
    }

    public static interface MoPubNativeNetworkListener {
        public void onNativeLoad(NativeAd var1);

        public void onNativeFail(TradPlusErrorCode var1);

        public void onNativeClick(String var1);
    }
}

