/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.nativeads;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibilityTracker;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.util.TradPlusListNativeOption;
import com.tradplus.ads.nativeads.MoPubAdRenderer;
import com.tradplus.ads.nativeads.NativeAd;
import com.tradplus.ads.nativeads.TradPlusNativeAdLoadedListener;
import com.tradplus.ads.nativeads.TradPlusNativeAdPositioning;
import com.tradplus.ads.nativeads.TradPlusRecyclerViewHolder;
import com.tradplus.ads.nativeads.TradPlusStreamAdPlacer;
import com.tradplus.ads.nativeads.VideoStatusUtils;
import java.util.List;
import java.util.WeakHashMap;

public class TradPlusRecyclerAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    @NonNull
    private final RecyclerView.AdapterDataObserver a;
    @Nullable
    private RecyclerView b;
    @NonNull
    private final TradPlusStreamAdPlacer c;
    @NonNull
    private final RecyclerView.Adapter d;
    @NonNull
    private final VisibilityTracker e;
    @NonNull
    private final WeakHashMap<View, Integer> f;
    @NonNull
    private ContentChangeStrategy g = ContentChangeStrategy.INSERT_AT_END;
    @Nullable
    private TradPlusNativeAdLoadedListener h;
    private TradPlusListNativeOption i;

    public TradPlusListNativeOption getOption() {
        return this.i;
    }

    public void setOption(TradPlusListNativeOption tradPlusListNativeOption) {
        this.i = tradPlusListNativeOption;
    }

    public void setOnListAdsClickedListener(OnListAdsClickedListener onListAdsClickedListener) {
        this.c.setOnListAdsClickedListener(onListAdsClickedListener);
    }

    public TradPlusRecyclerAdapter(@NonNull Activity activity, @NonNull RecyclerView.Adapter adapter, @NonNull TradPlusNativeAdPositioning.TradPlusClientPositioning tradPlusClientPositioning, @NonNull TradPlusListNativeOption tradPlusListNativeOption) {
        this(new TradPlusStreamAdPlacer(activity, tradPlusClientPositioning, tradPlusListNativeOption), adapter, new VisibilityTracker((Context)activity));
    }

    public void setItemCount() {
        this.c.setItemCount(this.d.getItemCount());
    }

    @VisibleForTesting
    TradPlusRecyclerAdapter(@NonNull TradPlusStreamAdPlacer tradPlusStreamAdPlacer, @NonNull RecyclerView.Adapter adapter, @NonNull VisibilityTracker visibilityTracker) {
        this.f = new WeakHashMap();
        this.d = adapter;
        this.e = visibilityTracker;
        this.e.setVisibilityTrackerListener(new VisibilityTracker.VisibilityTrackerListener(){

            @Override
            public void onVisibilityChanged(List<View> list, List<View> list2) {
                if (!VideoStatusUtils.getInstance().isVideoPlaying()) {
                    TradPlusRecyclerAdapter.this.a(list, list2);
                }
            }
        });
        this.a(this.d.hasStableIds());
        this.c = tradPlusStreamAdPlacer;
        this.c.setAdLoadedListener(new TradPlusNativeAdLoadedListener(){

            @Override
            public void onAdLoaded(int n2) {
                TradPlusRecyclerAdapter.this.handleAdLoaded(n2);
            }

            @Override
            public void onAdRemoved(int n2) {
                TradPlusRecyclerAdapter.this.a(n2);
            }
        });
        this.c.setItemCount(this.d.getItemCount());
        this.a = new RecyclerView.AdapterDataObserver(){

            public void onChanged() {
                TradPlusRecyclerAdapter.this.c.setItemCount(TradPlusRecyclerAdapter.this.d.getItemCount());
                TradPlusRecyclerAdapter.this.notifyDataSetChanged();
            }

            public void onItemRangeChanged(int n2, int n3) {
                int n4 = TradPlusRecyclerAdapter.this.c.getAdjustedPosition(n2 + n3 - 1);
                int n5 = TradPlusRecyclerAdapter.this.c.getAdjustedPosition(n2);
                int n6 = n4 - n5 + 1;
                TradPlusRecyclerAdapter.this.notifyItemRangeChanged(n5, n6);
            }

            public void onItemRangeInserted(int n2, int n3) {
                boolean bl;
                int n4 = TradPlusRecyclerAdapter.this.c.getAdjustedPosition(n2);
                int n5 = TradPlusRecyclerAdapter.this.d.getItemCount();
                TradPlusRecyclerAdapter.this.c.setItemCount(n5);
                boolean bl2 = bl = n2 + n3 >= n5;
                if (ContentChangeStrategy.KEEP_ADS_FIXED == TradPlusRecyclerAdapter.this.g || ContentChangeStrategy.INSERT_AT_END == TradPlusRecyclerAdapter.this.g && bl) {
                    TradPlusRecyclerAdapter.this.notifyDataSetChanged();
                } else {
                    for (int i2 = 0; i2 < n3; ++i2) {
                        TradPlusRecyclerAdapter.this.c.insertItem(n2);
                    }
                    TradPlusRecyclerAdapter.this.notifyItemRangeInserted(n4, n3);
                }
            }

            public void onItemRangeRemoved(int n2, int n3) {
                boolean bl;
                int n4 = TradPlusRecyclerAdapter.this.c.getAdjustedPosition(n2);
                int n5 = TradPlusRecyclerAdapter.this.d.getItemCount();
                TradPlusRecyclerAdapter.this.c.setItemCount(n5);
                boolean bl2 = bl = n2 + n3 >= n5;
                if (ContentChangeStrategy.KEEP_ADS_FIXED == TradPlusRecyclerAdapter.this.g || ContentChangeStrategy.INSERT_AT_END == TradPlusRecyclerAdapter.this.g && bl) {
                    TradPlusRecyclerAdapter.this.notifyDataSetChanged();
                } else {
                    int n6;
                    int n7 = TradPlusRecyclerAdapter.this.c.getAdjustedCount(n5 + n3);
                    for (n6 = 0; n6 < n3; ++n6) {
                        TradPlusRecyclerAdapter.this.c.removeItem(n2);
                    }
                    n6 = n7 - TradPlusRecyclerAdapter.this.c.getAdjustedCount(n5);
                    TradPlusRecyclerAdapter.this.notifyItemRangeRemoved(n4 -= n6 - n3, n6);
                }
            }

            public void onItemRangeMoved(int n2, int n3, int n4) {
                TradPlusRecyclerAdapter.this.notifyDataSetChanged();
            }
        };
        this.d.registerAdapterDataObserver(this.a);
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        this.b = recyclerView;
    }

    public void onDetachedFromRecyclerView(RecyclerView recyclerView) {
        super.onDetachedFromRecyclerView(recyclerView);
        this.b = null;
    }

    public void addFixedPositionByRefresh(TradPlusListNativeOption tradPlusListNativeOption) {
        this.c.addFixedPositionByRefresh(tradPlusListNativeOption);
    }

    public void setAdLoadedListener(@Nullable TradPlusNativeAdLoadedListener tradPlusNativeAdLoadedListener) {
        this.h = tradPlusNativeAdLoadedListener;
    }

    public void registerAdRenderer(@NonNull MoPubAdRenderer moPubAdRenderer) {
        if (!Preconditions.NoThrow.checkNotNull(moPubAdRenderer, "Cannot register a null adRenderer")) {
            return;
        }
        this.c.registerAdRenderer(moPubAdRenderer);
    }

    public void loadAds(@NonNull String string) {
        this.c.loadAds(string);
    }

    public static int computeScrollOffset(@NonNull LinearLayoutManager linearLayoutManager, @Nullable RecyclerView.ViewHolder viewHolder) {
        if (viewHolder == null) {
            return 0;
        }
        View view = viewHolder.itemView;
        int n2 = 0;
        if (linearLayoutManager.canScrollVertically()) {
            n2 = linearLayoutManager.getStackFromEnd() ? view.getBottom() : view.getTop();
        } else if (linearLayoutManager.canScrollHorizontally()) {
            n2 = linearLayoutManager.getStackFromEnd() ? view.getRight() : view.getLeft();
        }
        return n2;
    }

    public void refreshAds(@NonNull String string) {
        if (this.b == null) {
            LogUtil.show("This adapter is not attached to a RecyclerView and cannot be refreshed.");
            return;
        }
        RecyclerView.LayoutManager layoutManager = this.b.getLayoutManager();
        if (layoutManager == null) {
            LogUtil.show("Can't refresh ads when there is no layout manager on a RecyclerView.");
            return;
        }
        if (layoutManager instanceof LinearLayoutManager) {
            int n2;
            int n3;
            LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
            int n4 = linearLayoutManager.findFirstVisibleItemPosition();
            RecyclerView.ViewHolder viewHolder = this.b.findViewHolderForLayoutPosition(n4);
            int n5 = TradPlusRecyclerAdapter.computeScrollOffset(linearLayoutManager, viewHolder);
            for (n3 = Math.max(0, n4 - 1); this.c.isAd(n3) && n3 > 0; --n3) {
            }
            int n6 = this.getItemCount();
            for (n2 = linearLayoutManager.findLastVisibleItemPosition(); this.c.isAd(n2) && n2 < n6 - 1; ++n2) {
            }
            int n7 = this.c.getOriginalPosition(n3);
            int n8 = this.c.getOriginalPosition(n2);
            int n9 = this.d.getItemCount();
            this.c.removeAdsInRange(n8, n9);
            int n10 = this.c.removeAdsInRange(0, n7);
            if (n10 > 0) {
                linearLayoutManager.scrollToPositionWithOffset(n4 - n10, n5);
            }
            this.loadAds(string);
        } else {
            LogUtil.show("This LayoutManager can't be refreshed.");
        }
    }

    public void clearAds() {
        this.c.clearAds();
    }

    public boolean isAd(int n2) {
        return this.c.isAd(n2);
    }

    public int getAdjustedPosition(int n2) {
        return this.c.getAdjustedPosition(n2);
    }

    public int getOriginalPosition(int n2) {
        return this.c.getOriginalPosition(n2);
    }

    public void setContentChangeStrategy(@NonNull ContentChangeStrategy contentChangeStrategy) {
        if (!Preconditions.NoThrow.checkNotNull((Object)contentChangeStrategy)) {
            return;
        }
        this.g = contentChangeStrategy;
    }

    public int getItemCount() {
        return this.c.getAdjustedCount(this.d.getItemCount());
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        if (n2 >= -56 && n2 <= -56 + this.c.getAdViewTypeCount()) {
            MoPubAdRenderer moPubAdRenderer = this.c.getAdRendererForViewType(n2 - -56);
            if (moPubAdRenderer == null) {
                return null;
            }
            return new TradPlusRecyclerViewHolder(moPubAdRenderer.createAdView((Context)((Activity)viewGroup.getContext()), viewGroup));
        }
        return this.d.onCreateViewHolder(viewGroup, n2);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n2) {
        Object object = this.c.getAdData(n2);
        if (object != null) {
            this.c.bindAdView((NativeAd)object, viewHolder.itemView);
            return;
        }
        this.f.put(viewHolder.itemView, n2);
        this.e.addView(viewHolder.itemView, 0, null);
        this.d.onBindViewHolder(viewHolder, this.c.getOriginalPosition(n2));
    }

    public int getItemViewType(int n2) {
        int n3 = this.c.getAdViewType(n2);
        if (n3 != 0) {
            return -56 + n3;
        }
        return this.d.getItemViewType(this.c.getOriginalPosition(n2));
    }

    public boolean isADSView(int n2) {
        int n3 = this.c.getAdViewType(n2);
        return n3 != 0;
    }

    public void setHasStableIds(boolean bl) {
        this.a(bl);
        this.d.unregisterAdapterDataObserver(this.a);
        this.d.setHasStableIds(bl);
        this.d.registerAdapterDataObserver(this.a);
    }

    public void destroy() {
        VideoStatusUtils.getInstance().setVideoPlaying(false);
        this.d.unregisterAdapterDataObserver(this.a);
        this.c.destroy();
        this.e.destroy();
    }

    public long getItemId(int n2) {
        if (!this.d.hasStableIds()) {
            return -1L;
        }
        Object object = this.c.getAdData(n2);
        if (object != null) {
            return -System.identityHashCode(object);
        }
        return this.d.getItemId(this.c.getOriginalPosition(n2));
    }

    public boolean onFailedToRecycleView(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof TradPlusRecyclerViewHolder) {
            return super.onFailedToRecycleView(viewHolder);
        }
        return this.d.onFailedToRecycleView(viewHolder);
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof TradPlusRecyclerViewHolder) {
            super.onViewAttachedToWindow(viewHolder);
            return;
        }
        this.d.onViewAttachedToWindow(viewHolder);
    }

    public void onViewDetachedFromWindow(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof TradPlusRecyclerViewHolder) {
            super.onViewDetachedFromWindow(viewHolder);
            return;
        }
        this.d.onViewDetachedFromWindow(viewHolder);
    }

    public void onViewRecycled(RecyclerView.ViewHolder viewHolder) {
        if (viewHolder instanceof TradPlusRecyclerViewHolder) {
            super.onViewRecycled(viewHolder);
            return;
        }
        this.d.onViewRecycled(viewHolder);
    }

    @VisibleForTesting
    public void handleAdLoaded(int n2) {
        if (this.h != null) {
            this.h.onAdLoaded(n2);
        }
        this.notifyItemInserted(n2);
    }

    @VisibleForTesting
    void a(int n2) {
        if (this.h != null) {
            this.h.onAdRemoved(n2);
        }
        this.notifyItemRemoved(n2);
    }

    private void a(List<View> list, List<View> list2) {
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (View view : list) {
            Integer n4 = this.f.get(view);
            if (n4 == null) continue;
            n2 = Math.min(n4, n2);
            n3 = Math.max(n4, n3);
        }
        this.c.placeAdsInRange(n2, n3 + 1);
    }

    private void a(boolean bl) {
        super.setHasStableIds(bl);
    }

    public static interface OnListAdsClickedListener {
        public void onAdsClick(String var1);
    }

    public static enum ContentChangeStrategy {
        INSERT_AT_END,
        MOVE_ALL_ADS_WITH_CONTENT,
        KEEP_ADS_FIXED;

    }
}

