/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.FSMoPubRequestQueue;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.TPNetworkError;
import com.tradplus.ads.volley.DefaultRetryPolicy;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.HttpHeaderParser;
import java.util.Arrays;

public class TrackingRequest
extends Request<Void> {
    @Nullable
    private final Listener a;

    private TrackingRequest(@NonNull String string, @Nullable Listener listener) {
        super(0, string, listener);
        this.a = listener;
        this.setShouldCache(false);
        this.setRetryPolicy(new DefaultRetryPolicy(2500, 0, 1.0f));
    }

    @Override
    protected Response<Void> a(NetworkResponse networkResponse) {
        if (networkResponse.statusCode != 200) {
            return Response.error(new TPNetworkError("Failed to log tracking request. Response code: " + networkResponse.statusCode + " for url: " + this.getUrl(), TPNetworkError.Reason.TRACKING_FAILURE));
        }
        return Response.success(null, HttpHeaderParser.parseCacheHeaders(networkResponse));
    }

    @Override
    public void deliverResponse(Void void_) {
        if (this.a != null) {
            this.a.onResponse(this.getUrl());
        }
    }

    public static void makeTrackingHttpRequest(@Nullable Iterable<String> iterable, @Nullable Context context, final @Nullable Listener listener, BaseEvent.Name name) {
        if (iterable == null || context == null) {
            return;
        }
        FSMoPubRequestQueue fSMoPubRequestQueue = Networking.getRequestQueue(context);
        for (final String string : iterable) {
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            Listener listener2 = new Listener(){

                @Override
                public void onResponse(@NonNull String string2) {
                    LogUtil.show("Successfully hit tracking endpoint: " + string2);
                    if (listener != null) {
                        listener.onResponse(string2);
                    }
                }

                @Override
                public void onErrorResponse(VolleyError volleyError) {
                    LogUtil.show("Failed to hit tracking endpoint: " + string);
                    if (listener != null) {
                        listener.onErrorResponse(volleyError);
                    }
                }
            };
            TrackingRequest trackingRequest = new TrackingRequest(string, listener2);
            if (fSMoPubRequestQueue == null) continue;
            fSMoPubRequestQueue.add(trackingRequest);
        }
    }

    public static void makeTrackingHttpRequest(@Nullable String string, @Nullable Context context) {
        TrackingRequest.makeTrackingHttpRequest(string, context, null, null);
    }

    public static void makeTrackingHttpRequest(@Nullable String string, @Nullable Context context, @Nullable Listener listener) {
        TrackingRequest.makeTrackingHttpRequest(string, context, listener, null);
    }

    public static void makeTrackingHttpRequest(@Nullable String string, @Nullable Context context, BaseEvent.Name name) {
        TrackingRequest.makeTrackingHttpRequest(string, context, null, name);
    }

    public static void makeTrackingHttpRequest(@Nullable String string, @Nullable Context context, @Nullable Listener listener, BaseEvent.Name name) {
        if (string != null) {
            TrackingRequest.makeTrackingHttpRequest(Arrays.asList(string), context, listener, name);
        }
    }

    public static void makeTrackingHttpRequest(@Nullable Iterable<String> iterable, @Nullable Context context) {
        TrackingRequest.makeTrackingHttpRequest(iterable, context, null, null);
    }

    public static void makeTrackingHttpRequest(@Nullable Iterable<String> iterable, @Nullable Context context, BaseEvent.Name name) {
        TrackingRequest.makeTrackingHttpRequest(iterable, context, null, name);
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onResponse(@NonNull String var1);
    }
}

