/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network.util;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.tradplus.ads.common.util.BitmapUtil;
import com.tradplus.ads.common.util.FileUtil;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.network.util.ImageLruCache;
import com.tradplus.ads.network.util.ImageUrlLoader;
import com.tradplus.ads.network.util.ResourceDiskCacheManager;
import com.tradplus.ads.network.util.ResourceEntry;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class ImageLoader {
    private static ImageLoader b;
    private ImageLruCache<String, WeakReference<Bitmap>> c;
    private final Object d = new Object();
    Context a;
    private LinkedHashMap<String, List<ImageLoaderListener>> e = new LinkedHashMap();
    private Handler f = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message message) {
            if (message.what == 1) {
                String string = message.getData().getString("image_key");
                Bitmap bitmap = ImageLoader.this.getBitmapFromMemCache(string);
                LinkedList linkedList = (LinkedList)ImageLoader.this.e.get(string);
                if (linkedList != null) {
                    for (ImageLoaderListener imageLoaderListener : linkedList) {
                        if (imageLoaderListener == null) continue;
                        if (bitmap != null) {
                            imageLoaderListener.onSuccess(string, bitmap);
                            continue;
                        }
                        imageLoaderListener.onFail(string, "Bitmap load fail");
                    }
                }
                ImageLoader.this.e.remove(string);
            } else if (message.what == 2) {
                String string = message.getData().getString("image_key");
                String string2 = message.getData().getString("image_message");
                LinkedList linkedList = (LinkedList)ImageLoader.this.e.get(string);
                if (linkedList != null) {
                    for (ImageLoaderListener imageLoaderListener : linkedList) {
                        if (imageLoaderListener == null) continue;
                        imageLoaderListener.onFail(string, string2);
                    }
                }
                ImageLoader.this.e.remove(string);
            }
        }
    };

    public void addBitmapToMemoryCache(String string, Bitmap bitmap) {
        if (this.getBitmapFromMemCache(string) == null && bitmap != null) {
            this.c.put(string, new WeakReference<Bitmap>(bitmap));
        }
    }

    public Bitmap getBitmapFromMemCache(String string) {
        WeakReference<Bitmap> weakReference = this.c.get(string);
        return weakReference != null ? (Bitmap)weakReference.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapFromDiskCache(ResourceEntry resourceEntry, int n2, int n3) {
        if (resourceEntry == null || TextUtils.isEmpty((CharSequence)resourceEntry.resourceUrl)) {
            return null;
        }
        String string = FileUtil.hashKeyForDisk(resourceEntry.resourceUrl);
        Bitmap bitmap = null;
        Object object = this.d;
        synchronized (object) {
            FileInputStream fileInputStream = ResourceDiskCacheManager.getInstance(this.a).getFileInputStream(resourceEntry.resourceType, string);
            if (fileInputStream == null) {
                return null;
            }
            try {
                FileDescriptor fileDescriptor = fileInputStream.getFD();
                bitmap = BitmapUtil.getBitmap(fileDescriptor, n2, n3);
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
            return bitmap;
        }
    }

    private ImageLoader(Context context) {
        this.a = context.getApplicationContext();
        int n2 = (int)Runtime.getRuntime().maxMemory();
        int n3 = n2 / 5;
        LogUtil.ownShow("ImageLoad init cache size: " + n3 + "B");
        this.c = new ImageLruCache<String, WeakReference<Bitmap>>(n3){

            @Override
            protected int a(String string, WeakReference<Bitmap> weakReference) {
                Bitmap bitmap = weakReference != null ? (Bitmap)weakReference.get() : null;
                int n2 = bitmap != null ? bitmap.getRowBytes() * bitmap.getHeight() : 0;
                LogUtil.ownShow("sizeOf: Bitmap size:" + n2 + "B.");
                return n2;
            }

            @Override
            protected void a(boolean bl, String string, WeakReference<Bitmap> weakReference, WeakReference<Bitmap> weakReference2) {
                block4: {
                    super.a(bl, string, weakReference, weakReference2);
                    try {
                        Bitmap bitmap;
                        Bitmap bitmap2 = bitmap = weakReference != null ? (Bitmap)weakReference.get() : null;
                        if (bitmap == null) {
                            LogUtil.ownShow("entryRemoved: Bitmap has been release.");
                        }
                        if (weakReference != null && !weakReference.equals(weakReference2) && bitmap != null && !bitmap.isRecycled()) {
                            bitmap.recycle();
                            bitmap = null;
                            weakReference = null;
                            LogUtil.ownShow("entryRemoved: Bitmap recycle.");
                        }
                    }
                    catch (Exception exception) {
                        if (!TradPlus.getLocalDebugMode()) break block4;
                        exception.printStackTrace();
                    }
                }
            }
        };
    }

    public static ImageLoader getInstance(Context context) {
        if (b == null) {
            b = new ImageLoader(context);
        }
        return b;
    }

    public void load(ResourceEntry resourceEntry, ImageLoaderListener imageLoaderListener) {
        this.load(resourceEntry, -1, -1, imageLoaderListener);
    }

    public void load(ResourceEntry resourceEntry, int n2, int n3, ImageLoaderListener imageLoaderListener) {
        if (resourceEntry == null || TextUtils.isEmpty((CharSequence)resourceEntry.resourceUrl)) {
            if (imageLoaderListener != null) {
                imageLoaderListener.onFail("", "No url info.");
            }
            return;
        }
        Bitmap bitmap = this.getBitmapFromMemCache(resourceEntry.resourceUrl);
        if (bitmap != null) {
            imageLoaderListener.onSuccess(resourceEntry.resourceUrl, bitmap);
            return;
        }
        Bitmap bitmap2 = this.getBitmapFromDiskCache(resourceEntry, n2, n3);
        if (bitmap2 != null) {
            imageLoaderListener.onSuccess(resourceEntry.resourceUrl, bitmap2);
        } else {
            this.a(resourceEntry, n2, n3, imageLoaderListener);
        }
    }

    private void a(ResourceEntry resourceEntry, final int n2, final int n3, ImageLoaderListener imageLoaderListener) {
        if (!this.e.containsKey(resourceEntry.resourceUrl)) {
            LinkedList<ImageLoaderListener> linkedList = new LinkedList<ImageLoaderListener>();
            linkedList.add(imageLoaderListener);
            this.e.put(resourceEntry.resourceUrl, linkedList);
            ImageUrlLoader imageUrlLoader = new ImageUrlLoader(resourceEntry);
            imageUrlLoader.setListener(new ImageUrlLoader.HttpLoadListener(){

                @Override
                public void onLoadSuccess(ResourceEntry resourceEntry) {
                    LogUtil.ownShow("Load Success:" + resourceEntry.resourceUrl);
                    Message message = ImageLoader.this.f.obtainMessage();
                    message.what = 1;
                    Bundle bundle = new Bundle();
                    bundle.putString("image_key", resourceEntry.resourceUrl);
                    message.setData(bundle);
                    Bitmap bitmap = ImageLoader.this.getBitmapFromDiskCache(resourceEntry, n2, n3);
                    if (bitmap != null) {
                        ImageLoader.this.addBitmapToMemoryCache(resourceEntry.resourceUrl, bitmap);
                    }
                    ImageLoader.this.f.sendMessage(message);
                }

                @Override
                public void onLoadFail(ResourceEntry resourceEntry, String string) {
                    Message message = ImageLoader.this.f.obtainMessage();
                    message.what = 2;
                    Bundle bundle = new Bundle();
                    bundle.putString("image_key", resourceEntry.resourceUrl);
                    message.setData(bundle);
                    ImageLoader.this.f.sendMessage(message);
                }
            });
            imageUrlLoader.start();
        } else {
            LinkedList linkedList = (LinkedList)this.e.get(resourceEntry.resourceUrl);
            if (linkedList != null && !linkedList.contains(imageLoaderListener)) {
                linkedList.add(imageLoaderListener);
            }
        }
    }

    public void recycle() {
        block4: {
            try {
                if (this.c != null) {
                    this.c.evictAll();
                }
                if (this.e != null) {
                    this.e.clear();
                }
            }
            catch (Exception exception) {
                if (!TradPlus.getLocalDebugMode()) break block4;
                exception.printStackTrace();
            }
        }
    }

    public static interface ImageLoaderListener {
        public void onSuccess(String var1, Bitmap var2);

        public void onFail(String var1, String var2);
    }
}

