/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.pushcenter.utils;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.ACache;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.pushcenter.PushCenter;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessageUtils {
    public static final String PUSHMESSAGEARRAY = "push_message_array";
    public static final int MAXMESSAGELENGTH = 100;
    private static PushMessageUtils a;

    public static PushMessageUtils getInstance() {
        if (a == null) {
            a = new PushMessageUtils();
        }
        return a;
    }

    public JSONArray getPushMessageArray(Context context, int n2) {
        if (ACache.get(context, n2) == null) {
            return new JSONArray();
        }
        if (context == null) {
            return null;
        }
        JSONArray jSONArray = ACache.get(context, n2).getAsJSONArray(PUSHMESSAGEARRAY);
        if (jSONArray == null) {
            jSONArray = new JSONArray();
        }
        return jSONArray;
    }

    public void setPushMessageArray(Context context, JSONObject jSONObject, int n2) {
        LogUtil.ownShow(jSONObject.toString(), this.getCacheType(n2) + "  : PUSHMESSAGEARRAY");
        if (ACache.get(context, n2) == null) {
            return;
        }
        JSONArray jSONArray = this.getPushMessageArray(context, n2);
        if (jSONArray != null) {
            jSONArray.put((Object)jSONObject);
            ACache.get(context, n2).put(PUSHMESSAGEARRAY, jSONArray);
        }
    }

    public void initPushMessageArray(Context context, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        PushCenter.getInstance().saveMessageToLocal(PUSHMESSAGEARRAY, jSONArray, n2);
    }

    public void initPushMessageArray(Context context, JSONArray jSONArray, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        PushCenter.getInstance().saveMessageToLocal(PUSHMESSAGEARRAY, jSONArray, n2);
    }

    public JSONArray sortPushMessageArray(Context context, int n2) {
        JSONArray jSONArray = this.getPushMessageArray(context, n2);
        int n3 = jSONArray.length();
        if (n3 == 0) {
            return new JSONArray();
        }
        if (n3 <= 100) {
            return this.readyToSendMessage(context, jSONArray, n2);
        }
        return this.sortAndReadyToSendMessage(context, jSONArray, n2);
    }

    public JSONArray sortAndReadyToSendMessage(Context context, JSONArray jSONArray, int n2) {
        JSONObject jSONObject;
        int n3;
        JSONArray jSONArray2 = new JSONArray();
        JSONArray jSONArray3 = new JSONArray();
        for (n3 = 100; n3 < jSONArray.length(); ++n3) {
            try {
                jSONObject = jSONArray.getJSONObject(n3);
                jSONArray2.put((Object)jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        for (n3 = 0; n3 < 100; ++n3) {
            try {
                jSONObject = jSONArray.getJSONObject(n3);
                long l2 = jSONObject.getLong("createtime");
                jSONObject.put("time", (System.currentTimeMillis() - l2) / 1000L);
                jSONArray3.put((Object)jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.initPushMessageArray(context, jSONArray2, n2);
        return jSONArray3;
    }

    public JSONArray readyToSendMessage(Context context, JSONArray jSONArray, int n2) {
        JSONArray jSONArray2 = new JSONArray();
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i2);
                long l2 = jSONObject.getLong("createtime");
                jSONObject.put("time", (System.currentTimeMillis() - l2) / 1000L);
                jSONArray2.put((Object)jSONObject);
                continue;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        this.initPushMessageArray(context, n2);
        return jSONArray2;
    }

    public String setTradPlusErrorMessage(TradPlusErrorCode tradPlusErrorCode) {
        String string = "";
        String string2 = "";
        if (!TextUtils.isEmpty((CharSequence)tradPlusErrorCode.getCode())) {
            string = tradPlusErrorCode.getCode();
        }
        if (!TextUtils.isEmpty((CharSequence)tradPlusErrorCode.getErrormessage())) {
            string2 = tradPlusErrorCode.getErrormessage();
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string)) {
            return "errCode:0,errMsg:unknown error";
        }
        return "errCode:" + string + ",errMsg:" + string2;
    }

    public TradPlusErrorCode getTradPlusErrorCode(TradPlusErrorCode tradPlusErrorCode, String string) {
        TradPlusErrorCode tradPlusErrorCode2 = tradPlusErrorCode;
        tradPlusErrorCode2.setErrormessage(string);
        return tradPlusErrorCode2;
    }

    public String getCacheType(int n2) {
        if (n2 == TradPlusDataConstants.CACHETRADPLUSTYPE) {
            return "TradPlus";
        }
        if (n2 == TradPlusDataConstants.CACHETYPE) {
            return "CrossPro";
        }
        if (n2 == TradPlusDataConstants.TRACKTYPE) {
            return "Track";
        }
        return "";
    }

    public static enum Type {
        EV_TRADPLUS(1),
        EV_CROSSPRO(2),
        EV_TRACK(3);

        private final int a;

        private Type(int n3) {
            this.a = n3;
        }

        public int getValue() {
            return this.a;
        }
    }

    public static enum PushStatus {
        EV_REQ_OPEN_API_START("100"),
        EV_REQ_OPEN_API("200"),
        EV_PRE_LOAD_ADCONF_START("300"),
        EV_PRE_LOAD_ADCONF("400"),
        EV_LOAD_AD_START("500"),
        EV_LOAD_AD("600"),
        BIDDING_LOAD_START_AD("610"),
        BIDDING_LOAD_AD("611"),
        EV_LOAD_NETWORK_AD_START("700"),
        EV_LOAD_NETWORK_AD("800"),
        EV_LOAD_FIRST_NETWORK_AD("805"),
        EV_ALLLOAD_NETWORK_AD_END("810"),
        EV_CONFIRM_USER_IS_VIEW_AD("850"),
        EV_IS_READY("900"),
        EV_SHOW_AD_START("1000"),
        EV_SHOW_AD("1100"),
        EV_CLICK_AD("1200"),
        EV_AD_VIDEO_START("1300"),
        EV_AD_VIDEO_CLOSE("1400"),
        EV_ADVIDEO_REWARD("1500");

        private final String a;

        private PushStatus(String string2) {
            this.a = string2;
        }

        public String getValue() {
            return this.a;
        }
    }
}

