/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley;

import android.annotation.TargetApi;
import android.net.TrafficStats;
import android.os.Build;
import android.os.Process;
import android.os.SystemClock;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.Network;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.ResponseDelivery;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.VolleyLog;
import java.util.concurrent.BlockingQueue;

public class NetworkDispatcher
extends Thread {
    private final BlockingQueue<Request<?>> a;
    private final Network b;
    private final Cache c;
    private final ResponseDelivery d;
    private volatile boolean e = false;

    public NetworkDispatcher(BlockingQueue<Request<?>> blockingQueue, Network network, Cache cache, ResponseDelivery responseDelivery) {
        this.a = blockingQueue;
        this.b = network;
        this.c = cache;
        this.d = responseDelivery;
    }

    public void quit() {
        this.e = true;
        this.interrupt();
    }

    @TargetApi(value=14)
    private void a(Request<?> request) {
        if (Build.VERSION.SDK_INT >= 14) {
            TrafficStats.setThreadStatsTag((int)request.getTrafficStatsTag());
        }
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            Object object;
            Request<?> request;
            long l2 = SystemClock.elapsedRealtime();
            try {
                request = this.a.take();
            }
            catch (InterruptedException interruptedException) {
                if (!this.e) continue;
                return;
            }
            try {
                request.addMarker("network-queue-take");
                if (request.isCanceled()) {
                    request.a("network-discard-cancelled");
                    continue;
                }
                this.a(request);
                NetworkResponse networkResponse = this.b.performRequest(request);
                request.addMarker("network-http-complete");
                if (networkResponse.notModified && request.hasHadResponseDelivered()) {
                    request.a("not-modified");
                    continue;
                }
                object = request.a(networkResponse);
                request.addMarker("network-parse-complete");
                if (request.shouldCache() && ((Response)object).cacheEntry != null) {
                    this.c.put(request.getCacheKey(), ((Response)object).cacheEntry);
                    request.addMarker("network-cache-written");
                }
                request.markDelivered();
                this.d.postResponse(request, (Response<?>)object);
                continue;
            }
            catch (VolleyError volleyError) {
                volleyError.a(SystemClock.elapsedRealtime() - l2);
                this.a(request, volleyError);
                continue;
            }
            catch (Exception exception) {
                VolleyLog.e(exception, "Unhandled exception %s", exception.toString());
                object = new VolleyError(exception);
                ((VolleyError)object).a(SystemClock.elapsedRealtime() - l2);
                this.d.postError(request, (VolleyError)object);
                continue;
            }
            break;
        }
    }

    private void a(Request<?> request, VolleyError volleyError) {
        volleyError = request.a(volleyError);
        this.d.postError(request, volleyError);
    }
}

