/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley.toolbox;

import android.os.SystemClock;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.VolleyLog;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiskBasedCache
implements Cache {
    private final Map<String, a> a = new LinkedHashMap<String, a>(16, 0.75f, true);
    private long b = 0L;
    private final File c;
    private final int d;

    public DiskBasedCache(File file, int n2) {
        this.c = file;
        this.d = n2;
    }

    public DiskBasedCache(File file) {
        this(file, 0x500000);
    }

    @Override
    public synchronized void clear() {
        File[] fileArray = this.c.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                file.delete();
            }
        }
        this.a.clear();
        this.b = 0L;
        VolleyLog.d("Cache cleared.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Cache.Entry get(String string) {
        a a2 = this.a.get(string);
        if (a2 == null) {
            return null;
        }
        File file = this.getFileForKey(string);
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new b(new FileInputStream(file));
            com.tradplus.ads.volley.toolbox.DiskBasedCache$a.readHeader(filterInputStream);
            byte[] byArray = DiskBasedCache.a(filterInputStream, (int)(file.length() - (long)((b)filterInputStream).a));
            Cache.Entry entry = a2.toCacheEntry(byArray);
            return entry;
        }
        catch (IOException iOException) {
            VolleyLog.d("%s: %s", file.getAbsolutePath(), iOException.toString());
            this.remove(string);
            Cache.Entry entry = null;
            return entry;
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {
                    return null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void initialize() {
        if (!this.c.exists()) {
            if (!this.c.mkdirs()) {
                VolleyLog.e("Unable to create cache dir %s", this.c.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.c.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                a a2 = com.tradplus.ads.volley.toolbox.DiskBasedCache$a.readHeader(bufferedInputStream);
                a2.size = file.length();
                this.a(a2.key, a2);
            }
            catch (IOException iOException) {
                if (file == null) continue;
                file.delete();
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public synchronized void invalidate(String string, boolean bl) {
        Cache.Entry entry = this.get(string);
        if (entry != null) {
            entry.softTtl = 0L;
            if (bl) {
                entry.ttl = 0L;
            }
            this.put(string, entry);
        }
    }

    @Override
    public synchronized void put(String string, Cache.Entry entry) {
        this.a(entry.data.length);
        File file = this.getFileForKey(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            a a2 = new a(string, entry);
            boolean bl = a2.writeHeader(fileOutputStream);
            if (!bl) {
                fileOutputStream.close();
                VolleyLog.d("Failed to write header for %s", file.getAbsolutePath());
                throw new IOException();
            }
            fileOutputStream.write(entry.data);
            fileOutputStream.close();
            this.a(string, a2);
            return;
        }
        catch (IOException iOException) {
            boolean bl = file.delete();
            if (!bl) {
                VolleyLog.d("Could not clean up file %s", file.getAbsolutePath());
            }
            return;
        }
    }

    @Override
    public synchronized void remove(String string) {
        boolean bl = this.getFileForKey(string).delete();
        this.b(string);
        if (!bl) {
            VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", string, this.a(string));
        }
    }

    private String a(String string) {
        int n2 = string.length() / 2;
        String string2 = String.valueOf(string.substring(0, n2).hashCode());
        string2 = string2 + String.valueOf(string.substring(n2).hashCode());
        return string2;
    }

    public File getFileForKey(String string) {
        return new File(this.c, this.a(string));
    }

    private void a(int n2) {
        if (this.b + (long)n2 < (long)this.d) {
            return;
        }
        if (VolleyLog.DEBUG) {
            VolleyLog.v("Pruning old cache entries.", new Object[0]);
        }
        long l2 = this.b;
        int n3 = 0;
        long l3 = SystemClock.elapsedRealtime();
        Iterator<Map.Entry<String, a>> iterator = this.a.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, a> entry = iterator.next();
            a a2 = entry.getValue();
            boolean bl = this.getFileForKey(a2.key).delete();
            if (bl) {
                this.b -= a2.size;
            } else {
                VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", a2.key, this.a(a2.key));
            }
            iterator.remove();
            ++n3;
            if (!((float)(this.b + (long)n2) < (float)this.d * 0.9f)) continue;
            break;
        }
        if (VolleyLog.DEBUG) {
            VolleyLog.v("pruned %d files, %d bytes, %d ms", n3, this.b - l2, SystemClock.elapsedRealtime() - l3);
        }
    }

    private void a(String string, a a2) {
        if (!this.a.containsKey(string)) {
            this.b += a2.size;
        } else {
            a a3 = this.a.get(string);
            this.b += a2.size - a3.size;
        }
        this.a.put(string, a2);
    }

    private void b(String string) {
        a a2 = this.a.get(string);
        if (a2 != null) {
            this.b -= a2.size;
            this.a.remove(string);
        }
    }

    private static byte[] a(InputStream inputStream, int n2) {
        int n3;
        int n4;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Expected " + n2 + " bytes, read " + n3 + " bytes");
        }
        return byArray;
    }

    private static int e(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n2;
    }

    static void a(OutputStream outputStream, int n2) {
        outputStream.write(n2 >> 0 & 0xFF);
        outputStream.write(n2 >> 8 & 0xFF);
        outputStream.write(n2 >> 16 & 0xFF);
        outputStream.write(n2 >> 24 & 0xFF);
    }

    static int a(InputStream inputStream) {
        int n2 = 0;
        n2 |= DiskBasedCache.e(inputStream) << 0;
        n2 |= DiskBasedCache.e(inputStream) << 8;
        n2 |= DiskBasedCache.e(inputStream) << 16;
        return n2 |= DiskBasedCache.e(inputStream) << 24;
    }

    static void a(OutputStream outputStream, long l2) {
        outputStream.write((byte)(l2 >>> 0));
        outputStream.write((byte)(l2 >>> 8));
        outputStream.write((byte)(l2 >>> 16));
        outputStream.write((byte)(l2 >>> 24));
        outputStream.write((byte)(l2 >>> 32));
        outputStream.write((byte)(l2 >>> 40));
        outputStream.write((byte)(l2 >>> 48));
        outputStream.write((byte)(l2 >>> 56));
    }

    static long b(InputStream inputStream) {
        long l2 = 0L;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 0;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 8;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 16;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 24;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 32;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 40;
        l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 48;
        return l2 |= ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 56;
    }

    static void a(OutputStream outputStream, String string) {
        byte[] byArray = string.getBytes("UTF-8");
        DiskBasedCache.a(outputStream, (long)byArray.length);
        outputStream.write(byArray, 0, byArray.length);
    }

    static String c(InputStream inputStream) {
        int n2 = (int)DiskBasedCache.b(inputStream);
        byte[] byArray = DiskBasedCache.a(inputStream, n2);
        return new String(byArray, "UTF-8");
    }

    static void a(Map<String, String> map, OutputStream outputStream) {
        if (map != null) {
            DiskBasedCache.a(outputStream, map.size());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                DiskBasedCache.a(outputStream, entry.getKey());
                DiskBasedCache.a(outputStream, entry.getValue());
            }
        } else {
            DiskBasedCache.a(outputStream, 0);
        }
    }

    static Map<String, String> d(InputStream inputStream) {
        int n2 = DiskBasedCache.a(inputStream);
        HashMap<String, String> hashMap = n2 == 0 ? Collections.emptyMap() : new HashMap<String, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = DiskBasedCache.c(inputStream).intern();
            String string2 = DiskBasedCache.c(inputStream).intern();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private static class b
    extends FilterInputStream {
        private int a = 0;

        private b(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public int read() {
            int n2 = super.read();
            if (n2 != -1) {
                ++this.a;
            }
            return n2;
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) {
            int n4 = super.read(byArray, n2, n3);
            if (n4 != -1) {
                this.a += n4;
            }
            return n4;
        }
    }

    static class a {
        public long size;
        public String key;
        public String etag;
        public long serverDate;
        public long ttl;
        public long softTtl;
        public Map<String, String> responseHeaders;

        private a() {
        }

        public a(String string, Cache.Entry entry) {
            this.key = string;
            this.size = entry.data.length;
            this.etag = entry.etag;
            this.serverDate = entry.serverDate;
            this.ttl = entry.ttl;
            this.softTtl = entry.softTtl;
            this.responseHeaders = entry.responseHeaders;
        }

        public static a readHeader(InputStream inputStream) {
            a a2 = new a();
            int n2 = DiskBasedCache.a(inputStream);
            if (n2 != 538183203) {
                throw new IOException();
            }
            a2.key = DiskBasedCache.c(inputStream);
            a2.etag = DiskBasedCache.c(inputStream);
            if (a2.etag.equals("")) {
                a2.etag = null;
            }
            a2.serverDate = DiskBasedCache.b(inputStream);
            a2.ttl = DiskBasedCache.b(inputStream);
            a2.softTtl = DiskBasedCache.b(inputStream);
            a2.responseHeaders = DiskBasedCache.d(inputStream);
            return a2;
        }

        public Cache.Entry toCacheEntry(byte[] byArray) {
            Cache.Entry entry = new Cache.Entry();
            entry.data = byArray;
            entry.etag = this.etag;
            entry.serverDate = this.serverDate;
            entry.ttl = this.ttl;
            entry.softTtl = this.softTtl;
            entry.responseHeaders = this.responseHeaders;
            return entry;
        }

        public boolean writeHeader(OutputStream outputStream) {
            try {
                DiskBasedCache.a(outputStream, 538183203);
                DiskBasedCache.a(outputStream, this.key);
                DiskBasedCache.a(outputStream, this.etag == null ? "" : this.etag);
                DiskBasedCache.a(outputStream, this.serverDate);
                DiskBasedCache.a(outputStream, this.ttl);
                DiskBasedCache.a(outputStream, this.softTtl);
                DiskBasedCache.a(this.responseHeaders, outputStream);
                outputStream.flush();
                return true;
            }
            catch (IOException iOException) {
                VolleyLog.d("%s", iOException.toString());
                return false;
            }
        }
    }
}

