/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.config.request.BiddingRequest;
import com.tradplus.ads.base.config.request.BiddingRequestInfo;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.TPRequestQueue;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.StringRequest;
import java.net.URLEncoder;

public class BiddingLoadManager {
    public static final String LC_WIN = "0";
    public static final String LC_NOFILL = "1";
    public static final String LC_PAYLOAD_TIMEOUT = "102";
    public static final String LC_NETWORK_TIMEOUT = "4902";
    private static BiddingLoadManager a = null;

    private BiddingLoadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized BiddingLoadManager getInstance() {
        if (a != null) return a;
        Class<BiddingLoadManager> clazz = BiddingLoadManager.class;
        synchronized (BiddingLoadManager.class) {
            if (a != null) return a;
            a = new BiddingLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public synchronized void loadBiddingRequest(BiddingRequestInfo biddingRequestInfo, final BiddingLoadListener biddingLoadListener) {
        BiddingRequest.Listener listener = new BiddingRequest.Listener(){

            @Override
            public void onResponse(BiddingResponse biddingResponse) {
                if (biddingResponse == null) {
                    biddingLoadListener.onFailed(new VolleyError("response is null"));
                }
                biddingLoadListener.onSuccess(biddingResponse);
            }

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                biddingLoadListener.onFailed(volleyError);
            }
        };
        BiddingRequest biddingRequest = new BiddingRequest(TradPlus.isLocalDebugMode ? "https://test-bidder.tradplusad.com/api/v1/headbidding" : "https://bidder.tradplusad.com/api/v1/headbidding", JSON.toJSONString(biddingRequestInfo), listener, biddingRequestInfo.getTmax());
        TPRequestQueue tPRequestQueue = Networking.getRequestQueue(GlobalTradPlus.getInstance().getContext());
        if (tPRequestQueue != null) {
            tPRequestQueue.add(biddingRequest);
        } else {
            biddingLoadListener.onFailed(new VolleyError("requestQueue is null"));
        }
    }

    public synchronized void biddingNotification(String string, String string2, String string3, final BiddingNotificationListener biddingNotificationListener) {
        if (string3 == null || string3.length() <= 0) {
            biddingNotificationListener.onFailed(new VolleyError("url is null"));
            return;
        }
        if (string2 == null || string2.length() <= 0) {
            string2 = LC_WIN;
        }
        try {
            string3 = string3.replace(URLEncoder.encode("${AUCTION_LOSS}", "UTF-8"), string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        string3 = string3.replace("${NOTIFY_VALUE}", string2);
        LogUtil.ownShow("BiddingLoadManager biddingNotification send url:" + string3);
        StringRequest stringRequest = new StringRequest(0, string3, new Response.Listener<String>(){

            public void a(String string) {
                if (string != null) {
                    biddingNotificationListener.onSuccess(string);
                } else {
                    biddingNotificationListener.onFailed(new VolleyError("response is null"));
                }
            }

            @Override
            public /* synthetic */ void onResponse(Object object) {
                this.a((String)object);
            }
        }, new Response.ErrorListener(){

            @Override
            public void onErrorResponse(VolleyError volleyError) {
                biddingNotificationListener.onFailed(volleyError);
            }
        });
        TPRequestQueue tPRequestQueue = Networking.getRequestQueue(GlobalTradPlus.getInstance().getContext());
        if (tPRequestQueue != null) {
            tPRequestQueue.add(stringRequest);
        } else {
            biddingNotificationListener.onFailed(new VolleyError("requestQueue is null"));
        }
    }

    public static interface BiddingNotificationListener {
        public void onSuccess(String var1);

        public void onFailed(VolleyError var1);
    }

    public static interface BiddingLoadListener {
        public void onSuccess(BiddingResponse var1);

        public void onFailed(VolleyError var1);
    }
}

