/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config.request;

import androidx.annotation.NonNull;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.volley.DefaultRetryPolicy;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.HttpHeaderParser;
import java.io.UnsupportedEncodingException;

public class BiddingRequest
extends Request<BiddingResponse> {
    private String a;
    private Listener b;

    public BiddingRequest(@NonNull String string, @NonNull String string2, @NonNull Listener listener, int n2) {
        super(1, string, listener);
        this.a = string2;
        LogUtil.ownShow("bidding request body = " + this.a);
        this.b = listener;
        DefaultRetryPolicy defaultRetryPolicy = new DefaultRetryPolicy(n2 == 0 ? 10000 : n2, 1, 1.0f);
        this.setShouldCache(false);
        this.setRetryPolicy(defaultRetryPolicy);
    }

    @Override
    public byte[] getBody() {
        try {
            return this.a.getBytes(this.getParamsEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    @Override
    protected Response<BiddingResponse> parseNetworkResponse(NetworkResponse networkResponse) {
        try {
            String string = new String(networkResponse.data);
            LogUtil.ownShow("bidding response data = " + string);
            BiddingResponse biddingResponse = JSON.parseObject(string, BiddingResponse.class);
            return Response.success(biddingResponse, HttpHeaderParser.parseCacheHeaders(networkResponse));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return Response.error(new VolleyError(exception.getMessage()));
        }
    }

    @Override
    protected void deliverResponse(BiddingResponse biddingResponse) {
        if (this.b != null) {
            this.b.onResponse(biddingResponse);
        }
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onResponse(BiddingResponse var1);
    }
}

