/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.a.a;
import com.tradplus.ads.a.b;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlHandler;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.Intents;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.TrackingRequest;
import java.net.URISyntaxException;
import java.util.List;

public enum UrlAction {
    HANDLE_TP_SCHEME(false){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "tp".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            String string2 = uri.getHost();
            UrlHandler.TPSchemeListener tPSchemeListener = urlHandler.a();
            if ("finishLoad".equalsIgnoreCase(string2)) {
                tPSchemeListener.onFinishLoad();
            } else if ("close".equalsIgnoreCase(string2)) {
                tPSchemeListener.onClose();
            } else if ("failLoad".equalsIgnoreCase(string2)) {
                tPSchemeListener.onFailLoad();
            } else {
                throw new a("Could not handle TradPlus Scheme url: " + uri);
            }
        }
    }
    ,
    IGNORE_ABOUT_SCHEME(false){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "about".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            LogUtil.show("Link to about page ignored.");
        }
    }
    ,
    HANDLE_PHONE_SCHEME(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String string = uri.getScheme();
            return "tel".equalsIgnoreCase(string) || "voicemail".equalsIgnoreCase(string) || "sms".equalsIgnoreCase(string) || "mailto".equalsIgnoreCase(string) || "geo".equalsIgnoreCase(string) || "google.streetview".equalsIgnoreCase(string);
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            String string2 = "Could not handle intent with URI: " + uri + "\n\tIs this intent supported on your phone?";
            Intents.launchActionViewIntent(context, uri, string2);
        }
    }
    ,
    OPEN_NATIVE_BROWSER(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "tpnativebrowser".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            String string2 = "Unable to load tp native browser url: " + uri;
            try {
                Intent intent = Intents.intentForNativeBrowserScheme(uri);
                Intents.launchIntentForUserClick(context, intent, string2);
            }
            catch (b b2) {
                throw new a(string2 + "\n\t" + b2.getMessage());
            }
        }
    }
    ,
    OPEN_APP_MARKET(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String string = uri.getScheme();
            String string2 = uri.getHost();
            return "play.google.com".equalsIgnoreCase(string2) || "market.android.com".equalsIgnoreCase(string2) || "market".equalsIgnoreCase(string) || uri.toString().toLowerCase().startsWith("play.google.com/") || uri.toString().toLowerCase().startsWith("market.android.com/");
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            Intents.launchApplicationUrl(context, uri);
        }
    }
    ,
    OPEN_IN_APP_BROWSER(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String string = uri.getScheme();
            return "http".equalsIgnoreCase(string) || "https".equalsIgnoreCase(string);
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            if (!urlHandler.b()) {
                Intents.showTPBrowserForUrl(context, uri, string);
            }
        }
    }
    ,
    HANDLE_SHARE_TWEET(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            Preconditions.checkNotNull(uri);
            return "tpshare".equalsIgnoreCase(uri.getScheme()) && "tweet".equalsIgnoreCase(uri.getHost());
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            Preconditions.checkNotNull(context);
            Preconditions.checkNotNull(uri);
            String string2 = "Share via";
            String string3 = "Could not handle share tweet intent with URI " + uri;
            try {
                Intent intent = Intents.intentForShareTweet(uri);
                Intent intent2 = Intent.createChooser((Intent)intent, (CharSequence)"Share via");
                Intents.launchIntentForUserClick(context, intent2, string3);
            }
            catch (b b2) {
                throw new a(string3 + "\n\t" + b2.getMessage());
            }
        }
    }
    ,
    FOLLOW_DEEP_LINK_WITH_FALLBACK(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return "deeplink+".equalsIgnoreCase(uri.getScheme());
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            List list;
            String string2;
            List list2;
            String string3;
            if (!"navigate".equalsIgnoreCase(uri.getHost())) {
                throw new a("Deeplink+ URL did not have 'navigate' as the host.");
            }
            try {
                string3 = uri.getQueryParameter("primaryUrl");
                list2 = uri.getQueryParameters("primaryTrackingUrl");
                string2 = uri.getQueryParameter("fallbackUrl");
                list = uri.getQueryParameters("fallbackTrackingUrl");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                throw new a("Deeplink+ URL was not a hierarchical URI.");
            }
            if (string3 == null) {
                throw new a("Deeplink+ did not have 'primaryUrl' query param.");
            }
            Uri uri2 = Uri.parse((String)string3);
            if (this.shouldTryHandlingUrl(uri2)) {
                throw new a("Deeplink+ had another Deeplink+ as the 'primaryUrl'.");
            }
            try {
                Intents.launchApplicationUrl(context, uri2);
                TrackingRequest.makeTrackingHttpRequest(list2, context, BaseEvent.Name.CLICK_REQUEST);
                return;
            }
            catch (a a2) {
                if (string2 == null) {
                    throw new a("Unable to handle 'primaryUrl' for Deeplink+ and 'fallbackUrl' was missing.");
                }
                if (this.shouldTryHandlingUrl(Uri.parse((String)string2))) {
                    throw new a("Deeplink+ URL had another Deeplink+ URL as the 'fallbackUrl'.");
                }
                boolean bl = true;
                urlHandler.handleUrl(context, string2, true, list);
                return;
            }
        }
    }
    ,
    FOLLOW_DEEP_LINK(true){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            String string = uri.getScheme();
            return !TextUtils.isEmpty((CharSequence)string);
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
            if ("intent".equalsIgnoreCase(uri.getScheme())) {
                try {
                    Intent intent = Intent.parseUri((String)uri.toString(), (int)1);
                    Intents.launchApplicationIntent(context, intent);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new a("Intent uri had invalid syntax: " + uri.toString());
                }
            } else {
                Intents.launchApplicationUrl(context, uri);
            }
        }
    }
    ,
    NOOP(false){

        @Override
        public boolean shouldTryHandlingUrl(@NonNull Uri uri) {
            return false;
        }

        @Override
        protected void a(@NonNull Context context, @NonNull Uri uri, @NonNull UrlHandler urlHandler, @Nullable String string) {
        }
    };

    private final boolean a;

    public void handleUrl(UrlHandler urlHandler, @NonNull Context context, @NonNull Uri uri, boolean bl, @Nullable String string) {
        LogUtil.show("Ad event URL: " + uri);
        if (this.a && !bl) {
            throw new a("Attempted to handle action without user interaction.");
        }
        this.a(context, uri, urlHandler, string);
    }

    private UrlAction(boolean bl) {
        this.a = bl;
    }

    public abstract boolean shouldTryHandlingUrl(@NonNull Uri var1);

    protected abstract void a(@NonNull Context var1, @NonNull Uri var2, @NonNull UrlHandler var3, @Nullable String var4);
}

