/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.a.a;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlResolutionTask;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.TrackingRequest;
import java.util.EnumSet;

public class UrlHandler {
    private static final ResultActions a = new ResultActions(){

        @Override
        public void urlHandlingSucceeded(@NonNull String string, @NonNull UrlAction urlAction) {
        }

        @Override
        public void urlHandlingFailed(@NonNull String string, @NonNull UrlAction urlAction) {
        }
    };
    private static final TPSchemeListener b = new TPSchemeListener(){

        @Override
        public void onFinishLoad() {
        }

        @Override
        public void onClose() {
        }

        @Override
        public void onFailLoad() {
        }
    };
    @NonNull
    private EnumSet<UrlAction> c;
    @NonNull
    private ResultActions d;
    @NonNull
    private TPSchemeListener e;
    @Nullable
    private String f;
    private boolean g;
    private boolean h;
    private boolean i;

    private UrlHandler(@NonNull EnumSet<UrlAction> enumSet, @NonNull ResultActions resultActions, @NonNull TPSchemeListener tPSchemeListener, boolean bl, @Nullable String string) {
        this.c = EnumSet.copyOf(enumSet);
        this.d = resultActions;
        this.e = tPSchemeListener;
        this.g = bl;
        this.f = string;
        this.h = false;
        this.i = false;
    }

    @NonNull
    TPSchemeListener a() {
        return this.e;
    }

    boolean b() {
        return this.g;
    }

    public void handleUrl(@NonNull Context context, @NonNull String string) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, true);
    }

    public void handleUrl(@NonNull Context context, @NonNull String string, boolean bl) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, bl, null);
    }

    public void handleUrl(final @NonNull Context context, final @NonNull String string, final boolean bl, final @Nullable Iterable<String> iterable) {
        Preconditions.checkNotNull(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.a(string, null, "Attempted to handle empty url.", null);
            return;
        }
        UrlResolutionTask.a a2 = new UrlResolutionTask.a(){

            @Override
            public void onSuccess(@NonNull String string2) {
                UrlHandler.this.i = false;
                UrlHandler.this.handleResolvedUrl(context, string2, bl, iterable);
            }

            @Override
            public void onFailure(@NonNull String string2, @Nullable Throwable throwable) {
                UrlHandler.this.i = false;
                UrlHandler.this.a(string, null, string2, throwable);
            }
        };
        UrlResolutionTask.getResolvedUrl(string, a2);
        this.i = true;
    }

    public boolean handleResolvedUrl(@NonNull Context context, @NonNull String string, boolean bl, @Nullable Iterable<String> iterable) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.a(string, null, "Attempted to handle empty url.", null);
            return false;
        }
        UrlAction urlAction = UrlAction.NOOP;
        Uri uri = Uri.parse((String)string);
        for (UrlAction urlAction2 : this.c) {
            if (!urlAction2.shouldTryHandlingUrl(uri)) continue;
            try {
                urlAction2.handleUrl(this, context, uri, bl, this.f);
                if (!(this.h || this.i || UrlAction.IGNORE_ABOUT_SCHEME.equals((Object)urlAction2) || UrlAction.HANDLE_TP_SCHEME.equals((Object)urlAction2))) {
                    TrackingRequest.makeTrackingHttpRequest(iterable, context, BaseEvent.Name.CLICK_REQUEST);
                    this.d.urlHandlingSucceeded(uri.toString(), urlAction2);
                    this.h = true;
                }
                return true;
            }
            catch (a a2) {
                LogUtil.show(a2.getMessage(), a2);
                urlAction = urlAction2;
            }
        }
        this.a(string, urlAction, "Link ignored. Unable to handle url: " + string, null);
        return false;
    }

    private void a(@Nullable String string, @Nullable UrlAction urlAction, @NonNull String string2, @Nullable Throwable throwable) {
        Preconditions.checkNotNull(string2);
        if (urlAction == null) {
            urlAction = UrlAction.NOOP;
        }
        LogUtil.show(string2, throwable);
        this.d.urlHandlingFailed(string, urlAction);
    }

    static /* synthetic */ ResultActions c() {
        return a;
    }

    static /* synthetic */ TPSchemeListener d() {
        return b;
    }

    public static class Builder {
        @NonNull
        private EnumSet<UrlAction> a = EnumSet.of(UrlAction.NOOP);
        @NonNull
        private ResultActions b = UrlHandler.c();
        @NonNull
        private TPSchemeListener c = UrlHandler.d();
        private boolean d = false;
        @Nullable
        private String e;

        public Builder withSupportedUrlActions(@NonNull UrlAction urlAction, UrlAction ... urlActionArray) {
            this.a = EnumSet.of(urlAction, urlActionArray);
            return this;
        }

        public Builder withSupportedUrlActions(@NonNull EnumSet<UrlAction> enumSet) {
            this.a = EnumSet.copyOf(enumSet);
            return this;
        }

        public Builder withResultActions(@NonNull ResultActions resultActions) {
            this.b = resultActions;
            return this;
        }

        public Builder withTPSchemeListener(@NonNull TPSchemeListener tPSchemeListener) {
            this.c = tPSchemeListener;
            return this;
        }

        public Builder withoutTPBrowser() {
            this.d = true;
            return this;
        }

        public Builder withDspCreativeId(@Nullable String string) {
            this.e = string;
            return this;
        }

        public UrlHandler build() {
            return new UrlHandler(this.a, this.b, this.c, this.d, this.e);
        }
    }

    public static interface TPSchemeListener {
        public void onFinishLoad();

        public void onClose();

        public void onFailLoad();
    }

    public static interface ResultActions {
        public void urlHandlingSucceeded(@NonNull String var1, @NonNull UrlAction var2);

        public void urlHandlingFailed(@NonNull String var1, @NonNull UrlAction var2);
    }
}

