/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.util.Json;
import java.util.HashMap;
import java.util.Map;

public class EventDetails {
    @NonNull
    private final Map<String, String> a;

    private EventDetails(@NonNull Map<String, String> map) {
        Preconditions.checkNotNull(map);
        this.a = map;
    }

    @Nullable
    public String getAdUnitId() {
        return this.a.get("ad_unit_id");
    }

    @Nullable
    public String getDspCreativeId() {
        return this.a.get("dsp_creative_id");
    }

    @Nullable
    public String getAdType() {
        return this.a.get("ad_type");
    }

    @Nullable
    public String getAdNetworkType() {
        return this.a.get("ad_network_type");
    }

    @Nullable
    public Double getAdWidthPx() {
        return EventDetails.a(this.a, "ad_width_px");
    }

    @Nullable
    public Double getAdHeightPx() {
        return EventDetails.a(this.a, "ad_height_px_key");
    }

    @Nullable
    public Double getGeoLatitude() {
        return EventDetails.a(this.a, "geo_latitude");
    }

    @Nullable
    public Double getGeoLongitude() {
        return EventDetails.a(this.a, "geo_longitude");
    }

    @Nullable
    public Double getGeoAccuracy() {
        return EventDetails.a(this.a, "geo_accuracy_key");
    }

    @Nullable
    public Double getPerformanceDurationMs() {
        return EventDetails.a(this.a, "performance_duration_ms");
    }

    @Nullable
    public String getRequestId() {
        return this.a.get("request_id_key");
    }

    @Nullable
    public Integer getRequestStatusCode() {
        return EventDetails.b(this.a, "request_status_code");
    }

    @Nullable
    public String getRequestUri() {
        return this.a.get("request_uri_key");
    }

    public String toJsonString() {
        return Json.mapToJsonString(this.a);
    }

    public String toString() {
        return this.toJsonString();
    }

    @Nullable
    private static Double a(@NonNull Map<String, String> map, @NonNull String string) {
        String string2 = map.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Nullable
    private static Integer b(@NonNull Map<String, String> map, @NonNull String string) {
        String string2 = map.get(string);
        if (string2 == null) {
            return null;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static class Builder {
        @NonNull
        private final Map<String, String> a = new HashMap<String, String>();

        @NonNull
        public Builder adUnitId(@Nullable String string) {
            if (string != null) {
                this.a.put("ad_unit_id", string);
            }
            return this;
        }

        @NonNull
        public Builder dspCreativeId(@Nullable String string) {
            if (string != null) {
                this.a.put("dsp_creative_id", string);
            }
            return this;
        }

        @NonNull
        public Builder adType(@Nullable String string) {
            if (string != null) {
                this.a.put("ad_type", string);
            }
            return this;
        }

        @NonNull
        public Builder adNetworkType(@Nullable String string) {
            if (string != null) {
                this.a.put("ad_network_type", string);
            }
            return this;
        }

        @NonNull
        public Builder adWidthPx(@Nullable Integer n2) {
            if (n2 != null) {
                this.a.put("ad_width_px", String.valueOf(n2));
            }
            return this;
        }

        @NonNull
        public Builder adHeightPx(@Nullable Integer n2) {
            if (n2 != null) {
                this.a.put("ad_height_px_key", String.valueOf(n2));
            }
            return this;
        }

        @NonNull
        public Builder geoLatitude(@Nullable Double d2) {
            if (d2 != null) {
                this.a.put("geo_latitude", String.valueOf(d2));
            }
            return this;
        }

        @NonNull
        public Builder geoLongitude(@Nullable Double d2) {
            if (d2 != null) {
                this.a.put("geo_longitude", String.valueOf(d2));
            }
            return this;
        }

        @NonNull
        public Builder geoAccuracy(@Nullable Float f2) {
            if (f2 != null) {
                this.a.put("geo_accuracy_key", String.valueOf((double)f2.floatValue()));
            }
            return this;
        }

        @NonNull
        public Builder performanceDurationMs(@Nullable Long l2) {
            if (l2 != null) {
                this.a.put("performance_duration_ms", String.valueOf((double)l2.longValue()));
            }
            return this;
        }

        @NonNull
        public Builder requestId(@Nullable String string) {
            if (string != null) {
                this.a.put("request_id_key", string);
            }
            return this;
        }

        @NonNull
        public Builder requestStatusCode(@Nullable Integer n2) {
            if (n2 != null) {
                this.a.put("request_status_code", String.valueOf(n2));
            }
            return this;
        }

        @NonNull
        public Builder requestUri(@Nullable String string) {
            if (string != null) {
                this.a.put("request_uri_key", string);
            }
            return this;
        }

        @NonNull
        public EventDetails build() {
            return new EventDetails(this.a);
        }
    }
}

