/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;

public class JSONArray
extends JSON
implements Serializable,
Cloneable,
List<Object>,
RandomAccess {
    private final List<Object> d;
    protected transient Object b;
    protected transient Type c;

    public JSONArray() {
        this.d = new ArrayList<Object>();
    }

    public JSONArray(List<Object> list) {
        if (list == null) {
            throw new IllegalArgumentException("list is null.");
        }
        this.d = list;
    }

    public JSONArray(int n2) {
        this.d = new ArrayList<Object>(n2);
    }

    public Object getRelatedArray() {
        return this.b;
    }

    public void setRelatedArray(Object object) {
        this.b = object;
    }

    public Type getComponentType() {
        return this.c;
    }

    public void setComponentType(Type type) {
        this.c = type;
    }

    @Override
    public int size() {
        return this.d.size();
    }

    @Override
    public boolean isEmpty() {
        return this.d.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.d.contains(object);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.d.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.d.toArray();
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.d.toArray(TArray);
    }

    @Override
    public boolean add(Object object) {
        return this.d.add(object);
    }

    public JSONArray fluentAdd(Object object) {
        this.d.add(object);
        return this;
    }

    @Override
    public boolean remove(Object object) {
        return this.d.remove(object);
    }

    public JSONArray fluentRemove(Object object) {
        this.d.remove(object);
        return this;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.d.containsAll(collection);
    }

    @Override
    public boolean addAll(Collection<?> collection) {
        return this.d.addAll(collection);
    }

    public JSONArray fluentAddAll(Collection<?> collection) {
        this.d.addAll(collection);
        return this;
    }

    @Override
    public boolean addAll(int n2, Collection<?> collection) {
        return this.d.addAll(n2, collection);
    }

    public JSONArray fluentAddAll(int n2, Collection<?> collection) {
        this.d.addAll(n2, collection);
        return this;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.d.removeAll(collection);
    }

    public JSONArray fluentRemoveAll(Collection<?> collection) {
        this.d.removeAll(collection);
        return this;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.d.retainAll(collection);
    }

    public JSONArray fluentRetainAll(Collection<?> collection) {
        this.d.retainAll(collection);
        return this;
    }

    @Override
    public void clear() {
        this.d.clear();
    }

    public JSONArray fluentClear() {
        this.d.clear();
        return this;
    }

    @Override
    public Object set(int n2, Object object) {
        if (n2 == -1) {
            this.d.add(object);
            return null;
        }
        if (this.d.size() <= n2) {
            for (int i2 = this.d.size(); i2 < n2; ++i2) {
                this.d.add(null);
            }
            this.d.add(object);
            return null;
        }
        return this.d.set(n2, object);
    }

    public JSONArray fluentSet(int n2, Object object) {
        this.set(n2, object);
        return this;
    }

    @Override
    public void add(int n2, Object object) {
        this.d.add(n2, object);
    }

    public JSONArray fluentAdd(int n2, Object object) {
        this.d.add(n2, object);
        return this;
    }

    @Override
    public Object remove(int n2) {
        return this.d.remove(n2);
    }

    public JSONArray fluentRemove(int n2) {
        this.d.remove(n2);
        return this;
    }

    @Override
    public int indexOf(Object object) {
        return this.d.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.d.lastIndexOf(object);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.d.listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int n2) {
        return this.d.listIterator(n2);
    }

    @Override
    public List<Object> subList(int n2, int n3) {
        return this.d.subList(n2, n3);
    }

    @Override
    public Object get(int n2) {
        return this.d.get(n2);
    }

    public JSONObject getJSONObject(int n2) {
        Object object = this.d.get(n2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        if (object instanceof Map) {
            return new JSONObject((Map)object);
        }
        return (JSONObject)JSONArray.toJSON(object);
    }

    public JSONArray getJSONArray(int n2) {
        Object object = this.d.get(n2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        if (object instanceof List) {
            return new JSONArray((List)object);
        }
        return (JSONArray)JSONArray.toJSON(object);
    }

    public <T> T getObject(int n2, Class<T> clazz) {
        Object object = this.d.get(n2);
        return TypeUtils.castToJavaBean(object, clazz);
    }

    public <T> T getObject(int n2, Type type) {
        Object object = this.d.get(n2);
        if (type instanceof Class) {
            return TypeUtils.castToJavaBean(object, (Class)type);
        }
        String string = JSON.toJSONString(object);
        return JSON.parseObject(string, type, new Feature[0]);
    }

    public Boolean getBoolean(int n2) {
        Object object = this.get(n2);
        if (object == null) {
            return null;
        }
        return TypeUtils.castToBoolean(object);
    }

    public boolean getBooleanValue(int n2) {
        Object object = this.get(n2);
        if (object == null) {
            return false;
        }
        return TypeUtils.castToBoolean(object);
    }

    public Byte getByte(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToByte(object);
    }

    public byte getByteValue(int n2) {
        Object object = this.get(n2);
        Byte by = TypeUtils.castToByte(object);
        if (by == null) {
            return 0;
        }
        return by;
    }

    public Short getShort(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToShort(object);
    }

    public short getShortValue(int n2) {
        Object object = this.get(n2);
        Short s2 = TypeUtils.castToShort(object);
        if (s2 == null) {
            return 0;
        }
        return s2;
    }

    public Integer getInteger(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToInt(object);
    }

    public int getIntValue(int n2) {
        Object object = this.get(n2);
        Integer n3 = TypeUtils.castToInt(object);
        if (n3 == null) {
            return 0;
        }
        return n3;
    }

    public Long getLong(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToLong(object);
    }

    public long getLongValue(int n2) {
        Object object = this.get(n2);
        Long l2 = TypeUtils.castToLong(object);
        if (l2 == null) {
            return 0L;
        }
        return l2;
    }

    public Float getFloat(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToFloat(object);
    }

    public float getFloatValue(int n2) {
        Object object = this.get(n2);
        Float f2 = TypeUtils.castToFloat(object);
        if (f2 == null) {
            return 0.0f;
        }
        return f2.floatValue();
    }

    public Double getDouble(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToDouble(object);
    }

    public double getDoubleValue(int n2) {
        Object object = this.get(n2);
        Double d2 = TypeUtils.castToDouble(object);
        if (d2 == null) {
            return 0.0;
        }
        return d2;
    }

    public BigDecimal getBigDecimal(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToBigDecimal(object);
    }

    public BigInteger getBigInteger(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToBigInteger(object);
    }

    public String getString(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToString(object);
    }

    public java.util.Date getDate(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToDate(object);
    }

    public Date getSqlDate(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToSqlDate(object);
    }

    public Timestamp getTimestamp(int n2) {
        Object object = this.get(n2);
        return TypeUtils.castToTimestamp(object);
    }

    public <T> List<T> toJavaList(Class<T> clazz) {
        ArrayList<T> arrayList = new ArrayList<T>(this.size());
        ParserConfig parserConfig = ParserConfig.getGlobalInstance();
        for (Object object : this) {
            T t2 = TypeUtils.cast(object, clazz, parserConfig);
            arrayList.add(t2);
        }
        return arrayList;
    }

    public Object clone() {
        return new JSONArray(new ArrayList<Object>(this.d));
    }

    @Override
    public boolean equals(Object object) {
        return this.d.equals(object);
    }

    @Override
    public int hashCode() {
        return this.d.hashCode();
    }
}

