/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONPath;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONScanner;

public class JSONPatch {
    public static String apply(String string, String string2) {
        Object object = JSONPatch.apply(JSON.parse(string, Feature.OrderedField), string2);
        return JSON.toJSONString(object);
    }

    public static Object apply(Object object, String string) {
        Operation[] operationArray = JSONPatch.a(string) ? new Operation[]{JSON.parseObject(string, Operation.class)} : JSON.parseObject(string, Operation[].class);
        block7: for (Operation operation : operationArray) {
            JSONPath jSONPath = JSONPath.compile(operation.path);
            switch (operation.type) {
                case add: {
                    jSONPath.patchAdd(object, operation.value, false);
                    continue block7;
                }
                case replace: {
                    jSONPath.patchAdd(object, operation.value, true);
                    continue block7;
                }
                case remove: {
                    jSONPath.remove(object);
                    continue block7;
                }
                case copy: 
                case move: {
                    boolean bl;
                    JSONPath jSONPath2 = JSONPath.compile(operation.from);
                    Object object2 = jSONPath2.eval(object);
                    if (operation.type == OperationType.move && !(bl = jSONPath2.remove(object))) {
                        throw new JSONException("json patch move error : " + operation.from + " -> " + operation.path);
                    }
                    jSONPath.set(object, object2);
                    continue block7;
                }
                case test: {
                    Object object3 = jSONPath.eval(object);
                    if (object3 == null) {
                        return operation.value == null;
                    }
                    return object3.equals(operation.value);
                }
            }
        }
        return object;
    }

    private static boolean a(String string) {
        if (string == null) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (JSONScanner.isWhitespace(c2)) continue;
            return c2 == '{';
        }
        return false;
    }

    public static enum OperationType {
        add,
        remove,
        replace,
        move,
        copy,
        test;

    }

    @JSONType(orders={"op", "from", "path", "value"})
    public static class Operation {
        @JSONField(name="op")
        public OperationType type;
        public String from;
        public String path;
        public Object value;
    }
}

