/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.ASMUtils;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public final class JSONScanner
extends JSONLexerBase {
    private final String r;
    private final int s;

    public JSONScanner(String string) {
        this(string, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(String string, int n2) {
        super(n2);
        this.r = string;
        this.s = this.r.length();
        this.e = -1;
        this.next();
        if (this.d == '\ufeff') {
            this.next();
        }
    }

    @Override
    public final char charAt(int n2) {
        if (n2 >= this.s) {
            return '\u001a';
        }
        return this.r.charAt(n2);
    }

    @Override
    public final char next() {
        int n2;
        char c2 = (n2 = ++this.e) >= this.s ? (char)'\u001a' : (char)this.r.charAt(n2);
        this.d = c2;
        return c2;
    }

    public JSONScanner(char[] cArray, int n2) {
        this(cArray, n2, JSON.DEFAULT_PARSER_FEATURE);
    }

    public JSONScanner(char[] cArray, int n2, int n3) {
        this(new String(cArray, 0, n2), n3);
    }

    @Override
    protected final void a(int n2, int n3, char[] cArray) {
        this.r.getChars(n2, n2 + n3, cArray, 0);
    }

    static boolean a(String string, int n2, char[] cArray) {
        int n3 = cArray.length;
        if (n3 + n2 > string.length()) {
            return false;
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            if (cArray[i2] == string.charAt(n2 + i2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean charArrayCompare(char[] cArray) {
        return JSONScanner.a(this.r, this.e, cArray);
    }

    @Override
    public final int indexOf(char c2, int n2) {
        return this.r.indexOf(c2, n2);
    }

    @Override
    public final String addSymbol(int n2, int n3, int n4, SymbolTable symbolTable) {
        return symbolTable.addSymbol(this.r, n2, n3, n4);
    }

    @Override
    public byte[] bytesValue() {
        if (this.a == 26) {
            int n2 = this.i + 1;
            int n3 = this.h;
            if (n3 % 2 != 0) {
                throw new JSONException("illegal state. " + n3);
            }
            byte[] byArray = new byte[n3 / 2];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                char c2 = this.r.charAt(n2 + i2 * 2);
                char c3 = this.r.charAt(n2 + i2 * 2 + 1);
                int n4 = c2 - (c2 <= '9' ? 48 : 55);
                int n5 = c3 - (c3 <= '9' ? 48 : 55);
                byArray[i2] = (byte)(n4 << 4 | n5);
            }
            return byArray;
        }
        if (!this.j) {
            return IOUtils.decodeBase64(this.r, this.i + 1, this.h);
        }
        String string = new String(this.g, 0, this.h);
        return IOUtils.decodeBase64(string);
    }

    @Override
    public final String stringVal() {
        if (!this.j) {
            return this.subString(this.i + 1, this.h);
        }
        return new String(this.g, 0, this.h);
    }

    @Override
    public final String subString(int n2, int n3) {
        if (ASMUtils.IS_ANDROID) {
            if (n3 < this.g.length) {
                this.r.getChars(n2, n2 + n3, this.g, 0);
                return new String(this.g, 0, n3);
            }
            char[] cArray = new char[n3];
            this.r.getChars(n2, n2 + n3, cArray, 0);
            return new String(cArray);
        }
        return this.r.substring(n2, n2 + n3);
    }

    @Override
    public final char[] sub_chars(int n2, int n3) {
        if (ASMUtils.IS_ANDROID && n3 < this.g.length) {
            this.r.getChars(n2, n2 + n3, this.g, 0);
            return this.g;
        }
        char[] cArray = new char[n3];
        this.r.getChars(n2, n2 + n3, cArray, 0);
        return cArray;
    }

    @Override
    public final String numberString() {
        char c2 = this.charAt(this.i + this.h - 1);
        int n2 = this.h;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n2;
        }
        return this.subString(this.i, n2);
    }

    @Override
    public final BigDecimal decimalValue() {
        char c2 = this.charAt(this.i + this.h - 1);
        int n2 = this.h;
        if (c2 == 'L' || c2 == 'S' || c2 == 'B' || c2 == 'F' || c2 == 'D') {
            --n2;
        }
        if (n2 > 65535) {
            throw new JSONException("decimal overflow");
        }
        int n3 = this.i;
        int n4 = n2;
        if (n4 < this.g.length) {
            this.r.getChars(n3, n3 + n4, this.g, 0);
            return new BigDecimal(this.g, 0, n4, MathContext.UNLIMITED);
        }
        char[] cArray = new char[n4];
        this.r.getChars(n3, n3 + n4, cArray, 0);
        return new BigDecimal(cArray, 0, cArray.length, MathContext.UNLIMITED);
    }

    public boolean scanISO8601DateIfMatch() {
        return this.scanISO8601DateIfMatch(true);
    }

    public boolean scanISO8601DateIfMatch(boolean bl) {
        int n2 = this.s - this.e;
        return this.a(bl, n2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean a(boolean bl, int n2) {
        char c2;
        int n3;
        char c3;
        char c4;
        char c5;
        char c6;
        char c7;
        char c8;
        int n4;
        char c9;
        char c10;
        char c11;
        char c12;
        char c13;
        char c14;
        char c15;
        if (n2 < 8) {
            return false;
        }
        char c16 = this.charAt(this.e);
        char c17 = this.charAt(this.e + 1);
        char c18 = this.charAt(this.e + 2);
        char c19 = this.charAt(this.e + 3);
        char c20 = this.charAt(this.e + 4);
        char c21 = this.charAt(this.e + 5);
        char c22 = this.charAt(this.e + 6);
        char c23 = this.charAt(this.e + 7);
        if (!bl && n2 > 13) {
            c15 = this.charAt(this.e + n2 - 1);
            char c24 = this.charAt(this.e + n2 - 2);
            if (c16 == '/' && c17 == 'D' && c18 == 'a' && c19 == 't' && c20 == 'e' && c21 == '(' && c15 == '/' && c24 == ')') {
                int n5;
                int n6 = -1;
                for (n5 = 6; n5 < n2; ++n5) {
                    char c25 = this.charAt(this.e + n5);
                    if (c25 == '+') {
                        n6 = n5;
                        continue;
                    }
                    if (c25 < '0' || c25 > '9') break;
                }
                if (n6 == -1) {
                    return false;
                }
                n5 = this.e + 6;
                String string = this.subString(n5, this.e + n6 - n5);
                long l2 = Long.parseLong(string);
                this.k = Calendar.getInstance(this.l, this.m);
                this.k.setTimeInMillis(l2);
                this.a = 5;
                return true;
            }
        }
        if (n2 == 8 || n2 == 14 || n2 == 16 && ((c15 = this.charAt(this.e + 10)) == 'T' || c15 == ' ') || n2 == 17 && this.charAt(this.e + 6) != '-') {
            int n7;
            int n8;
            int n9;
            int n10;
            void var12_16;
            char c26;
            char c27;
            char c28;
            char c29;
            char c30;
            char c31;
            char c32;
            boolean bl2;
            if (bl) {
                return false;
            }
            char c33 = this.charAt(this.e + 8);
            boolean bl3 = c20 == '-' && c23 == '-';
            boolean bl4 = bl3 && n2 == 16;
            boolean bl5 = bl2 = bl3 && n2 == 17;
            if (bl2 || bl4) {
                char c34 = c16;
                c32 = c17;
                c31 = c18;
                c30 = c19;
                c29 = c21;
                c28 = c22;
                c27 = c33;
                c26 = this.charAt(this.e + 9);
            } else if (c20 == '-' && c22 == '-') {
                char c35 = c16;
                c32 = c17;
                c31 = c18;
                c30 = c19;
                c29 = '0';
                c28 = c21;
                c27 = '0';
                c26 = c23;
            } else {
                char c36 = c16;
                c32 = c17;
                c31 = c18;
                c30 = c19;
                c29 = c20;
                c28 = c21;
                c27 = c22;
                c26 = c23;
            }
            if (!JSONScanner.a((char)var12_16, c32, c31, c30, c29, c28, c27, c26)) {
                return false;
            }
            this.a((char)var12_16, c32, c31, c30, c29, c28, c27, c26);
            if (n2 != 8) {
                int n11;
                int n12;
                char c37;
                char c38;
                int n13;
                char c39;
                int n14 = this.charAt(this.e + 9);
                c15 = this.charAt(this.e + 10);
                char c40 = this.charAt(this.e + 11);
                int n15 = this.charAt(this.e + 12);
                int n16 = this.charAt(this.e + 13);
                if (bl2 && c15 == 'T' && n16 == 58 && this.charAt(this.e + 16) == 'Z' || bl4 && (c15 == ' ' || c15 == 'T') && n16 == 58) {
                    c39 = c40;
                    n13 = n15;
                    c38 = this.charAt(this.e + 14);
                    c37 = this.charAt(this.e + 15);
                    n12 = 48;
                    n11 = 48;
                } else {
                    c39 = c33;
                    n13 = n14;
                    c38 = c15;
                    c37 = c40;
                    n12 = n15;
                    n11 = n16;
                }
                if (!this.b(c39, (char)n13, c38, c37, (char)n12, (char)n11)) {
                    return false;
                }
                if (n2 == 17 && !bl2) {
                    char c41 = this.charAt(this.e + 14);
                    char c42 = this.charAt(this.e + 15);
                    char c43 = this.charAt(this.e + 16);
                    if (c41 < '0' || c41 > '9') {
                        return false;
                    }
                    if (c42 < '0' || c42 > '9') {
                        return false;
                    }
                    if (c43 < '0' || c43 > '9') {
                        return false;
                    }
                    n10 = (c41 - 48) * 100 + (c42 - 48) * 10 + (c43 - 48);
                } else {
                    n10 = 0;
                }
                n9 = (c39 - 48) * 10 + (n13 - 48);
                n8 = (c38 - 48) * 10 + (c37 - 48);
                n7 = (n12 - 48) * 10 + (n11 - 48);
            } else {
                n9 = 0;
                n8 = 0;
                n7 = 0;
                n10 = 0;
            }
            this.k.set(11, n9);
            this.k.set(12, n8);
            this.k.set(13, n7);
            this.k.set(14, n10);
            this.a = 5;
            return true;
        }
        if (n2 < 9) {
            return false;
        }
        char c44 = this.charAt(this.e + 8);
        char c45 = this.charAt(this.e + 9);
        int n17 = 10;
        if (c20 == '-' && c23 == '-' || c20 == '/' && c23 == '/') {
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            c10 = c21;
            c9 = c22;
            if (c45 == ' ') {
                n4 = 48;
                c8 = c44;
                n17 = 9;
            } else {
                n4 = c44;
                c8 = c45;
            }
        } else if (c20 == '-' && c22 == '-') {
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            c10 = '0';
            c9 = c21;
            if (c44 == ' ') {
                n4 = 48;
                c8 = c23;
                n17 = 8;
            } else {
                n4 = c23;
                c8 = c44;
                n17 = 9;
            }
        } else if (c18 == '.' && c21 == '.' || c18 == '-' && c21 == '-') {
            n4 = c16;
            c8 = c17;
            c10 = c19;
            c9 = c20;
            c14 = c22;
            c13 = c23;
            c12 = c44;
            c11 = c45;
        } else if (c44 == 'T') {
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            c10 = c20;
            c9 = c21;
            n4 = c22;
            c8 = c23;
            n17 = 8;
        } else {
            if (c20 != '\u5e74' && c20 != 45380) return false;
            c14 = c16;
            c13 = c17;
            c12 = c18;
            c11 = c19;
            if (c23 == '\u6708' || c23 == '\uc6d4') {
                c10 = c21;
                c9 = c22;
                if (c45 == '\u65e5' || c45 == '\uc77c') {
                    n4 = 48;
                    c8 = c44;
                } else {
                    if (this.charAt(this.e + 10) != '\u65e5' && this.charAt(this.e + 10) != '\uc77c') return false;
                    n4 = c44;
                    c8 = c45;
                    n17 = 11;
                }
            } else {
                if (c22 != '\u6708' && c22 != 50900) return false;
                c10 = '0';
                c9 = c21;
                if (c44 == '\u65e5' || c44 == '\uc77c') {
                    n4 = 48;
                    c8 = c23;
                } else {
                    if (c45 != '\u65e5' && c45 != '\uc77c') return false;
                    n4 = c23;
                    c8 = c44;
                }
            }
        }
        if (!JSONScanner.a(c14, c13, c12, c11, c10, c9, n4, c8)) {
            return false;
        }
        this.a(c14, c13, c12, c11, c10, c9, (char)n4, c8);
        char c46 = this.charAt(this.e + n17);
        if (c46 == 'T' && n2 == 16 && n17 == 8 && this.charAt(this.e + 15) == 'Z') {
            String[] stringArray;
            char c47;
            char c48;
            char c49;
            char c50;
            char c51;
            char c52 = this.charAt(this.e + n17 + 1);
            if (!this.b(c52, c51 = this.charAt(this.e + n17 + 2), c50 = this.charAt(this.e + n17 + 3), c49 = this.charAt(this.e + n17 + 4), c48 = this.charAt(this.e + n17 + 5), c47 = this.charAt(this.e + n17 + 6))) {
                return false;
            }
            this.a(c52, c51, c50, c49, c48, c47);
            this.k.set(14, 0);
            if (this.k.getTimeZone().getRawOffset() != 0 && (stringArray = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[0]);
                this.k.setTimeZone(timeZone);
            }
            this.a = 5;
            return true;
        }
        if (c46 == 'T' || c46 == ' ' && !bl) {
            if (n2 < n17 + 9) {
                return false;
            }
        } else {
            if (c46 == '\"' || c46 == '\u001a' || c46 == '\u65e5' || c46 == '\uc77c') {
                this.k.set(11, 0);
                this.k.set(12, 0);
                this.k.set(13, 0);
                this.k.set(14, 0);
                this.d = this.charAt(this.e += n17);
                this.a = 5;
                return true;
            }
            if (c46 != '+' && c46 != '-') return false;
            if (this.s != n17 + 6) return false;
            if (this.charAt(this.e + n17 + 3) != ':' || this.charAt(this.e + n17 + 4) != '0' || this.charAt(this.e + n17 + 5) != '0') {
                return false;
            }
            this.a('0', '0', '0', '0', '0', '0');
            this.k.set(14, 0);
            this.a(c46, this.charAt(this.e + n17 + 1), this.charAt(this.e + n17 + 2));
            return true;
        }
        if (this.charAt(this.e + n17 + 3) != ':') {
            return false;
        }
        if (this.charAt(this.e + n17 + 6) != ':') {
            return false;
        }
        char c53 = this.charAt(this.e + n17 + 1);
        if (!this.b(c53, c7 = this.charAt(this.e + n17 + 2), c6 = this.charAt(this.e + n17 + 4), c5 = this.charAt(this.e + n17 + 5), c4 = this.charAt(this.e + n17 + 7), c3 = this.charAt(this.e + n17 + 8))) {
            return false;
        }
        this.a(c53, c7, c6, c5, c4, c3);
        char c54 = this.charAt(this.e + n17 + 9);
        int n18 = -1;
        int n19 = 0;
        if (c54 == '.') {
            if (n2 < n17 + 11) {
                return false;
            }
            n3 = this.charAt(this.e + n17 + 10);
            if (n3 < 48 || n3 > 57) {
                return false;
            }
            n19 = n3 - 48;
            n18 = 1;
            if (n2 > n17 + 11 && (c2 = this.charAt(this.e + n17 + 11)) >= '0' && c2 <= '9') {
                n19 = n19 * 10 + (c2 - 48);
                n18 = 2;
            }
            if (n18 == 2 && (c2 = this.charAt(this.e + n17 + 12)) >= '0' && c2 <= '9') {
                n19 = n19 * 10 + (c2 - 48);
                n18 = 3;
            }
        }
        this.k.set(14, n19);
        n3 = 0;
        c2 = this.charAt(this.e + n17 + 10 + n18);
        if (c2 == ' ') {
            c2 = this.charAt(this.e + n17 + 10 + ++n18);
        }
        if (c2 == '+' || c2 == '-') {
            char c55 = this.charAt(this.e + n17 + 10 + n18 + 1);
            if (c55 < '0' || c55 > '1') {
                return false;
            }
            char c56 = this.charAt(this.e + n17 + 10 + n18 + 2);
            if (c56 < '0' || c56 > '9') {
                return false;
            }
            char c57 = this.charAt(this.e + n17 + 10 + n18 + 3);
            int n20 = 48;
            int n21 = 48;
            if (c57 == ':') {
                n20 = this.charAt(this.e + n17 + 10 + n18 + 4);
                n21 = this.charAt(this.e + n17 + 10 + n18 + 5);
                if (n20 == 52 && n21 == 53) {
                    if ((c55 != '1' || c56 != '2' && c56 != '3') && (c55 != '0' || c56 != '5' && c56 != '8')) {
                        return false;
                    }
                } else {
                    if (n20 != 48 && n20 != 51) {
                        return false;
                    }
                    if (n21 != 48) {
                        return false;
                    }
                }
                n3 = 6;
            } else if (c57 == '0') {
                n20 = this.charAt(this.e + n17 + 10 + n18 + 4);
                if (n20 != 48 && n20 != 51) {
                    return false;
                }
                n3 = 5;
            } else if (c57 == '3' && this.charAt(this.e + n17 + 10 + n18 + 4) == '0') {
                n20 = 51;
                n21 = 48;
                n3 = 5;
            } else if (c57 == '4' && this.charAt(this.e + n17 + 10 + n18 + 4) == '5') {
                n20 = 52;
                n21 = 53;
                n3 = 5;
            } else {
                n3 = 3;
            }
            this.a(c2, c55, c56, (char)n20, (char)n21);
        } else if (c2 == 'Z') {
            String[] stringArray;
            n3 = 1;
            if (this.k.getTimeZone().getRawOffset() != 0 && (stringArray = TimeZone.getAvailableIDs(0)).length > 0) {
                TimeZone timeZone = TimeZone.getTimeZone(stringArray[0]);
                this.k.setTimeZone(timeZone);
            }
        }
        char c58 = this.charAt(this.e + (n17 + 10 + n18 + n3));
        if (c58 != '\u001a' && c58 != '\"') {
            return false;
        }
        this.d = this.charAt(this.e += n17 + 10 + n18 + n3);
        this.a = 5;
        return true;
    }

    protected void a(char c2, char c3, char c4, char c5, char c6, char c7) {
        int n2 = (c2 - 48) * 10 + (c3 - 48);
        int n3 = (c4 - 48) * 10 + (c5 - 48);
        int n4 = (c6 - 48) * 10 + (c7 - 48);
        this.k.set(11, n2);
        this.k.set(12, n3);
        this.k.set(13, n4);
    }

    protected void a(char c2, char c3, char c4) {
        this.a(c2, c3, c4, '0', '0');
    }

    protected void a(char c2, char c3, char c4, char c5, char c6) {
        int n2 = ((c3 - 48) * 10 + (c4 - 48)) * 3600 * 1000;
        n2 += ((c5 - 48) * 10 + (c6 - 48)) * 60 * 1000;
        if (c2 == '-') {
            n2 = -n2;
        }
        if (this.k.getTimeZone().getRawOffset() != n2) {
            this.k.setTimeZone(new SimpleTimeZone(n2, Integer.toString(n2)));
        }
    }

    private boolean b(char c2, char c3, char c4, char c5, char c6, char c7) {
        if (c2 == '0') {
            if (c3 < '0' || c3 > '9') {
                return false;
            }
        } else if (c2 == '1') {
            if (c3 < '0' || c3 > '9') {
                return false;
            }
        } else if (c2 == '2') {
            if (c3 < '0' || c3 > '4') {
                return false;
            }
        } else {
            return false;
        }
        if (c4 >= '0' && c4 <= '5') {
            if (c5 < '0' || c5 > '9') {
                return false;
            }
        } else if (c4 == '6') {
            if (c5 != '0') {
                return false;
            }
        } else {
            return false;
        }
        if (c6 >= '0' && c6 <= '5') {
            if (c7 < '0' || c7 > '9') {
                return false;
            }
        } else if (c6 == '6') {
            if (c7 != '0') {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void a(char c2, char c3, char c4, char c5, char c6, char c7, char c8, char c9) {
        this.k = Calendar.getInstance(this.l, this.m);
        int n2 = (c2 - 48) * 1000 + (c3 - 48) * 100 + (c4 - 48) * 10 + (c5 - 48);
        int n3 = (c6 - 48) * 10 + (c7 - 48) - 1;
        int n4 = (c8 - 48) * 10 + (c9 - 48);
        this.k.set(1, n2);
        this.k.set(2, n3);
        this.k.set(5, n4);
    }

    static boolean a(char c2, char c3, char c4, char c5, char c6, char c7, int n2, int n3) {
        if (c2 < '0' || c2 > '9') {
            return false;
        }
        if (c3 < '0' || c3 > '9') {
            return false;
        }
        if (c4 < '0' || c4 > '9') {
            return false;
        }
        if (c5 < '0' || c5 > '9') {
            return false;
        }
        if (c6 == '0') {
            if (c7 < '1' || c7 > '9') {
                return false;
            }
        } else if (c6 == '1') {
            if (c7 != '0' && c7 != '1' && c7 != '2') {
                return false;
            }
        } else {
            return false;
        }
        if (n2 == 48) {
            if (n3 < 49 || n3 > 57) {
                return false;
            }
        } else if (n2 == 49 || n2 == 50) {
            if (n3 < 48 || n3 > 57) {
                return false;
            }
        } else if (n2 == 51) {
            if (n3 != 48 && n3 != 49) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public boolean isEOF() {
        return this.e == this.s || this.d == '\u001a' && this.e + 1 >= this.s;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int scanFieldInt(char[] cArray) {
        int n2;
        int n3;
        boolean bl;
        char c2;
        int n4;
        char c3;
        int n5;
        block24: {
            int n6;
            boolean bl2;
            this.matchStat = 0;
            n5 = this.e;
            c3 = this.d;
            if (!JSONScanner.a(this.r, this.e, cArray)) {
                this.matchStat = -2;
                return 0;
            }
            n4 = this.e + cArray.length;
            boolean bl3 = bl2 = (c2 = this.charAt(n4++)) == '\"';
            if (bl2) {
                c2 = this.charAt(n4++);
            }
            boolean bl4 = bl = c2 == '-';
            if (bl) {
                c2 = this.charAt(n4++);
            }
            if (c2 >= '0' && c2 <= '9') {
                n3 = c2 - 48;
            } else {
                this.matchStat = -1;
                return 0;
            }
            while ((c2 = this.charAt(n4++)) >= '0' && c2 <= '9') {
                int n7 = n3 * 10;
                if (n7 < n3) {
                    this.matchStat = -1;
                    return 0;
                }
                n3 = n7 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n3 < 0) {
                this.matchStat = -1;
                return 0;
            }
            if (bl2) {
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(n4++);
            }
            while (true) {
                if (c2 == ',' || c2 == '}') {
                    this.e = n4 - 1;
                    if (c2 == ',') {
                        break;
                    }
                    break block24;
                }
                if (!JSONScanner.isWhitespace(c2)) {
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(n4++);
            }
            this.d = this.charAt(++this.e);
            this.matchStat = 3;
            this.a = 16;
            if (bl) {
                n6 = -n3;
                return n6;
            }
            n6 = n3;
            return n6;
        }
        if (c2 == '}') {
            this.e = n4 - 1;
            c2 = this.charAt(++this.e);
            while (true) {
                if (c2 == ',') {
                    this.a = 16;
                    this.d = this.charAt(++this.e);
                    break;
                }
                if (c2 == ']') {
                    this.a = 15;
                    this.d = this.charAt(++this.e);
                    break;
                }
                if (c2 == '}') {
                    this.a = 13;
                    this.d = this.charAt(++this.e);
                    break;
                }
                if (c2 == '\u001a') {
                    this.a = 20;
                    break;
                }
                if (!JSONScanner.isWhitespace(c2)) {
                    this.e = n5;
                    this.d = c3;
                    this.matchStat = -1;
                    return 0;
                }
                c2 = this.charAt(++this.e);
            }
            this.matchStat = 4;
        }
        if (bl) {
            n2 = -n3;
            return n2;
        }
        n2 = n3;
        return n2;
    }

    @Override
    public String scanFieldString(char[] cArray) {
        String string;
        int n2;
        char c2;
        char c3;
        int n3;
        block21: {
            int n4;
            this.matchStat = 0;
            n3 = this.e;
            c3 = this.d;
            while (!JSONScanner.a(this.r, this.e, cArray)) {
                if (JSONScanner.isWhitespace(this.d)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.d)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return this.stringDefaultValue();
            }
            int n5 = this.e + cArray.length;
            int n6 = 0;
            if ((c2 = this.charAt(n5++)) != '\"') {
                while (JSONScanner.isWhitespace(c2)) {
                    ++n6;
                    c2 = this.charAt(n5++);
                }
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return this.stringDefaultValue();
                }
            }
            if ((n2 = this.indexOf('\"', n4 = n5)) == -1) {
                throw new JSONException("unclosed str");
            }
            string = this.subString(n4, n2 - n4);
            if (string.indexOf(92) != -1) {
                int n7;
                while (true) {
                    n7 = 0;
                    for (int i2 = n2 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                        ++n7;
                    }
                    if (n7 % 2 == 0) break;
                    n2 = this.indexOf('\"', n2 + 1);
                }
                n7 = n2 - (this.e + cArray.length + 1 + n6);
                char[] cArray2 = this.sub_chars(this.e + cArray.length + 1 + n6, n7);
                string = JSONScanner.readString(cArray2, n7);
            }
            if ((this.c & Feature.TrimStringFieldValue.mask) != 0) {
                string = string.trim();
            }
            c2 = this.charAt(n2 + 1);
            while (true) {
                if (c2 == ',' || c2 == '}') break block21;
                if (!JSONScanner.isWhitespace(c2)) break;
                c2 = this.charAt(++n2 + 1);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.e = n2 + 1;
        this.d = c2;
        String string2 = string;
        if (c2 == ',') {
            this.d = this.charAt(++this.e);
            this.matchStat = 3;
            return string2;
        }
        if ((c2 = this.charAt(++this.e)) == ',') {
            this.a = 16;
            this.d = this.charAt(++this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.d = this.charAt(++this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.d = this.charAt(++this.e);
        } else if (c2 == '\u001a') {
            this.a = 20;
        } else {
            this.e = n3;
            this.d = c3;
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public Date scanFieldDate(char[] cArray) {
        Date date;
        char c2;
        char c3;
        int n2;
        block23: {
            this.matchStat = 0;
            n2 = this.e;
            c3 = this.d;
            if (!JSONScanner.a(this.r, this.e, cArray)) {
                this.matchStat = -2;
                return null;
            }
            int n3 = this.e + cArray.length;
            if ((c2 = this.charAt(n3++)) == '\"') {
                int n4 = n3;
                int n5 = this.indexOf('\"', n4);
                if (n5 == -1) {
                    throw new JSONException("unclosed str");
                }
                int n6 = n5 - n4;
                this.e = n3;
                if (!this.a(false, n6)) {
                    this.e = n2;
                    this.matchStat = -1;
                    return null;
                }
                date = this.k.getTime();
                c2 = this.charAt(n5 + 1);
                this.e = n2;
                while (true) {
                    if (c2 == ',' || c2 == '}') {
                        this.e = n5 + 1;
                        this.d = c2;
                        break block23;
                    }
                    if (!JSONScanner.isWhitespace(c2)) break;
                    c2 = this.charAt(++n5 + 1);
                }
                this.matchStat = -1;
                return null;
            }
            if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                long l2 = 0L;
                boolean bl = false;
                if (c2 == '-') {
                    c2 = this.charAt(n3++);
                    bl = true;
                }
                if (c2 >= '0' && c2 <= '9') {
                    l2 = c2 - 48;
                    while ((c2 = this.charAt(n3++)) >= '0' && c2 <= '9') {
                        l2 = l2 * 10L + (long)(c2 - 48);
                    }
                    if (c2 == ',' || c2 == '}') {
                        this.e = n3 - 1;
                    }
                }
                if (l2 < 0L) {
                    this.matchStat = -1;
                    return null;
                }
                if (bl) {
                    l2 = -l2;
                }
                date = new Date(l2);
            } else {
                this.matchStat = -1;
                return null;
            }
        }
        if (c2 == ',') {
            this.d = this.charAt(++this.e);
            this.matchStat = 3;
            this.a = 16;
            return date;
        }
        if ((c2 = this.charAt(++this.e)) == ',') {
            this.a = 16;
            this.d = this.charAt(++this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.d = this.charAt(++this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.d = this.charAt(++this.e);
        } else if (c2 == '\u001a') {
            this.a = 20;
        } else {
            this.e = n2;
            this.d = c3;
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return date;
    }

    @Override
    public long scanFieldSymbol(char[] cArray) {
        long l2;
        block15: {
            char c2;
            this.matchStat = 0;
            while (!JSONScanner.a(this.r, this.e, cArray)) {
                if (JSONScanner.isWhitespace(this.d)) {
                    this.next();
                    while (JSONScanner.isWhitespace(this.d)) {
                        this.next();
                    }
                    continue;
                }
                this.matchStat = -2;
                return 0L;
            }
            int n2 = this.e + cArray.length;
            int n3 = 0;
            if ((c2 = this.charAt(n2++)) != '\"') {
                while (JSONScanner.isWhitespace(c2)) {
                    c2 = this.charAt(n2++);
                    ++n3;
                }
                if (c2 != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
            }
            l2 = -3750763034362895579L;
            while (true) {
                if ((c2 = this.charAt(n2++)) == '\"') break;
                if (n2 > this.s) {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 ^= (long)c2;
                l2 *= 1099511628211L;
            }
            this.e = n2;
            this.d = c2 = this.charAt(this.e);
            while (true) {
                if (c2 == ',') {
                    this.d = this.charAt(++this.e);
                    this.matchStat = 3;
                    return l2;
                }
                if (c2 == '}') {
                    this.next();
                    this.skipWhitespace();
                    c2 = this.getCurrent();
                    if (c2 == ',') {
                        this.a = 16;
                        this.d = this.charAt(++this.e);
                        break block15;
                    }
                    if (c2 == ']') {
                        this.a = 15;
                        this.d = this.charAt(++this.e);
                        break block15;
                    }
                    if (c2 == '}') {
                        this.a = 13;
                        this.d = this.charAt(++this.e);
                        break block15;
                    }
                    if (c2 == '\u001a') {
                        this.a = 20;
                        break block15;
                    }
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(c2)) break;
                c2 = this.charAt(++this.e);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> clazz) {
        Collection<String> collection;
        block23: {
            int n2;
            char c2;
            int n3;
            char c3;
            int n4;
            block22: {
                block24: {
                    this.matchStat = 0;
                    while (this.d == '\n' || this.d == ' ') {
                        int n5;
                        this.d = (char)((n5 = ++this.e) >= this.s ? 26 : (int)this.r.charAt(n5));
                    }
                    if (!JSONScanner.a(this.r, this.e, cArray)) {
                        this.matchStat = -2;
                        return null;
                    }
                    collection = this.newCollectionByType(clazz);
                    n4 = this.e;
                    c3 = this.d;
                    n3 = this.e + cArray.length;
                    if ((c2 = this.charAt(n3++)) == '[') break block24;
                    if (!this.r.startsWith("ull", n3)) {
                        this.matchStat = -1;
                        return null;
                    }
                    n3 += 3;
                    c2 = this.charAt(n3++);
                    collection = null;
                    break block22;
                }
                c2 = this.charAt(n3++);
                while (true) {
                    block28: {
                        String string;
                        int n6;
                        block26: {
                            block27: {
                                block25: {
                                    if (c2 != '\"') break block25;
                                    n2 = n3;
                                    n6 = this.indexOf('\"', n2);
                                    if (n6 == -1) {
                                        throw new JSONException("unclosed str");
                                    }
                                    string = this.subString(n2, n6 - n2);
                                    if (string.indexOf(92) == -1) break block26;
                                    break block27;
                                }
                                if (c2 == 'n' && this.r.startsWith("ull", n3)) {
                                    n3 += 3;
                                    c2 = this.charAt(n3++);
                                    collection.add(null);
                                    break block28;
                                } else if (c2 == ']' && collection.size() == 0) {
                                    c2 = this.charAt(n3++);
                                    break block22;
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            while (true) {
                                int n7 = 0;
                                for (int i2 = n6 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n7, --i2) {
                                }
                                if (n7 % 2 == 0) {
                                    n7 = n6 - n2;
                                    char[] cArray2 = this.sub_chars(n2, n7);
                                    string = JSONScanner.readString(cArray2, n7);
                                    break;
                                }
                                n6 = this.indexOf('\"', n6 + 1);
                            }
                        }
                        n3 = n6 + 1;
                        c2 = this.charAt(n3++);
                        collection.add(string);
                    }
                    if (c2 != ',') break;
                    c2 = this.charAt(n3++);
                }
                if (c2 != ']') {
                    this.matchStat = -1;
                    return null;
                }
                c2 = this.charAt(n3++);
                while (JSONScanner.isWhitespace(c2)) {
                    c2 = this.charAt(n3++);
                }
            }
            this.e = n3;
            if (c2 == ',') {
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                return collection;
            }
            if (c2 != '}') {
                this.d = c3;
                this.e = n4;
                this.matchStat = -1;
                return null;
            }
            c2 = this.charAt(this.e);
            do {
                if (c2 == ',') {
                    this.a = 16;
                    this.d = this.charAt(++this.e);
                    break block23;
                }
                if (c2 == ']') {
                    this.a = 15;
                    this.d = this.charAt(++this.e);
                    break block23;
                }
                if (c2 == '}') {
                    this.a = 13;
                    this.d = this.charAt(++this.e);
                    break block23;
                }
                if (c2 == '\u001a') {
                    this.a = 20;
                    this.d = c2;
                    break block23;
                }
                n2 = 0;
                while (JSONScanner.isWhitespace(c2)) {
                    c2 = this.charAt(n3++);
                    this.e = n3;
                    n2 = 1;
                }
            } while (n2 != 0);
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return collection;
    }

    @Override
    public long scanFieldLong(char[] cArray) {
        long l2;
        boolean bl;
        block19: {
            char c2;
            boolean bl2;
            this.matchStat = 0;
            int n2 = this.e;
            char c3 = this.d;
            if (!JSONScanner.a(this.r, this.e, cArray)) {
                this.matchStat = -2;
                return 0L;
            }
            int n3 = this.e + cArray.length;
            boolean bl3 = bl2 = (c2 = this.charAt(n3++)) == '\"';
            if (bl2) {
                c2 = this.charAt(n3++);
            }
            bl = false;
            if (c2 == '-') {
                c2 = this.charAt(n3++);
                bl = true;
            }
            if (c2 >= '0' && c2 <= '9') {
                boolean bl4;
                l2 = c2 - 48;
                while ((c2 = this.charAt(n3++)) >= '0' && c2 <= '9') {
                    l2 = l2 * 10L + (long)(c2 - 48);
                }
                if (c2 == '.') {
                    this.matchStat = -1;
                    return 0L;
                }
                if (bl2) {
                    if (c2 != '\"') {
                        this.matchStat = -1;
                        return 0L;
                    }
                    c2 = this.charAt(n3++);
                }
                if (c2 == ',' || c2 == '}') {
                    this.e = n3 - 1;
                }
                boolean bl5 = bl4 = l2 >= 0L || l2 == Long.MIN_VALUE && bl;
                if (!bl4) {
                    this.e = n2;
                    this.d = c3;
                    this.matchStat = -1;
                    return 0L;
                }
            } else {
                this.e = n2;
                this.d = c3;
                this.matchStat = -1;
                return 0L;
            }
            while (true) {
                if (c2 == ',') {
                    this.d = this.charAt(++this.e);
                    this.matchStat = 3;
                    this.a = 16;
                    return bl ? -l2 : l2;
                }
                if (c2 == '}') {
                    c2 = this.charAt(++this.e);
                    while (true) {
                        if (c2 == ',') {
                            this.a = 16;
                            this.d = this.charAt(++this.e);
                            break block19;
                        }
                        if (c2 == ']') {
                            this.a = 15;
                            this.d = this.charAt(++this.e);
                            break block19;
                        }
                        if (c2 == '}') {
                            this.a = 13;
                            this.d = this.charAt(++this.e);
                            break block19;
                        }
                        if (c2 == '\u001a') {
                            this.a = 20;
                            break block19;
                        }
                        if (!JSONScanner.isWhitespace(c2)) break;
                        c2 = this.charAt(++this.e);
                    }
                    this.e = n2;
                    this.d = c3;
                    this.matchStat = -1;
                    return 0L;
                }
                if (!JSONScanner.isWhitespace(c2)) break;
                this.e = n3;
                c2 = this.charAt(n3++);
            }
            this.matchStat = -1;
            return 0L;
        }
        this.matchStat = 4;
        return bl ? -l2 : l2;
    }

    @Override
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        block29: {
            char c2;
            boolean bl2;
            this.matchStat = 0;
            if (!JSONScanner.a(this.r, this.e, cArray)) {
                this.matchStat = -2;
                return false;
            }
            int n2 = this.e;
            int n3 = this.e + cArray.length;
            boolean bl3 = bl2 = (c2 = this.charAt(n3++)) == '\"';
            if (bl2) {
                c2 = this.charAt(n3++);
            }
            if (c2 == 't') {
                if (this.charAt(n3++) != 'r') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n3++) != 'u') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n3++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (bl2 && this.charAt(n3++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.e = n3;
                c2 = this.charAt(this.e);
                bl = true;
            } else if (c2 == 'f') {
                if (this.charAt(n3++) != 'a') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n3++) != 'l') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n3++) != 's') {
                    this.matchStat = -1;
                    return false;
                }
                if (this.charAt(n3++) != 'e') {
                    this.matchStat = -1;
                    return false;
                }
                if (bl2 && this.charAt(n3++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.e = n3;
                c2 = this.charAt(this.e);
                bl = false;
            } else if (c2 == '1') {
                if (bl2 && this.charAt(n3++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.e = n3;
                c2 = this.charAt(this.e);
                bl = true;
            } else if (c2 == '0') {
                if (bl2 && this.charAt(n3++) != '\"') {
                    this.matchStat = -1;
                    return false;
                }
                this.e = n3;
                c2 = this.charAt(this.e);
                bl = false;
            } else {
                this.matchStat = -1;
                return false;
            }
            while (true) {
                if (c2 == ',') {
                    this.d = this.charAt(++this.e);
                    this.matchStat = 3;
                    this.a = 16;
                    break block29;
                }
                if (c2 == '}') {
                    block30: {
                        c2 = this.charAt(++this.e);
                        while (true) {
                            if (c2 == ',') {
                                this.a = 16;
                                this.d = this.charAt(++this.e);
                                break block30;
                            }
                            if (c2 == ']') {
                                this.a = 15;
                                this.d = this.charAt(++this.e);
                                break block30;
                            }
                            if (c2 == '}') {
                                this.a = 13;
                                this.d = this.charAt(++this.e);
                                break block30;
                            }
                            if (c2 == '\u001a') {
                                this.a = 20;
                                break block30;
                            }
                            if (!JSONScanner.isWhitespace(c2)) break;
                            c2 = this.charAt(++this.e);
                        }
                        this.matchStat = -1;
                        return false;
                    }
                    this.matchStat = 4;
                    break block29;
                }
                if (!JSONScanner.isWhitespace(c2)) break;
                c2 = this.charAt(++this.e);
            }
            this.e = n2;
            c2 = this.charAt(this.e);
            this.matchStat = -1;
            return false;
        }
        return bl;
    }

    @Override
    public final int scanInt(char c2) {
        int n2;
        boolean bl;
        boolean bl2;
        this.matchStat = 0;
        int n3 = this.e;
        int n4 = this.e;
        char c3 = this.charAt(n4++);
        while (JSONScanner.isWhitespace(c3)) {
            c3 = this.charAt(n4++);
        }
        boolean bl3 = bl2 = c3 == '\"';
        if (bl2) {
            c3 = this.charAt(n4++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(n4++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n2 = c3 - 48;
            while ((c3 = this.charAt(n4++)) >= '0' && c3 <= '9') {
                int n5 = n2 * 10;
                if (n5 < n2) {
                    throw new JSONException("parseInt error : " + this.subString(n3, n4 - 1));
                }
                n2 = n5 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0;
                }
                c3 = this.charAt(n4++);
            }
            if (n2 < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n' && this.charAt(n4++) == 'u' && this.charAt(n4++) == 'l' && this.charAt(n4++) == 'l') {
                this.matchStat = 5;
                int n6 = 0;
                c3 = this.charAt(n4++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(n4++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e = n4;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return n6;
                    }
                    if (c3 == ']') {
                        this.e = n4;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return n6;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(n4++);
                }
                this.matchStat = -1;
                return 0;
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.e = n4;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bl ? -n2 : n2;
            }
            if (!JSONScanner.isWhitespace(c3)) break;
            c3 = this.charAt(n4++);
        }
        this.matchStat = -1;
        return bl ? -n2 : n2;
    }

    @Override
    public double scanDouble(char c2) {
        double d2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = this.e;
        boolean bl3 = bl2 = (c3 = this.charAt(n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            int n3;
            int n4;
            boolean bl5;
            boolean bl6;
            long l2 = c3 - 48;
            while ((c3 = this.charAt(n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            long l3 = 1L;
            boolean bl7 = bl6 = c3 == '.';
            if (bl6) {
                if ((c3 = this.charAt(n2++)) >= '0' && c3 <= '9') {
                    l2 = l2 * 10L + (long)(c3 - 48);
                    l3 = 10L;
                    while ((c3 = this.charAt(n2++)) >= '0' && c3 <= '9') {
                        l2 = l2 * 10L + (long)(c3 - 48);
                        l3 *= 10L;
                    }
                } else {
                    this.matchStat = -1;
                    return 0.0;
                }
            }
            boolean bl8 = bl5 = c3 == 'e' || c3 == 'E';
            if (bl5) {
                if ((c3 = this.charAt(n2++)) == '+' || c3 == '-') {
                    c3 = this.charAt(n2++);
                }
                while (c3 >= '0' && c3 <= '9') {
                    c3 = this.charAt(n2++);
                }
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0.0;
                }
                c3 = this.charAt(n2++);
                n4 = this.e + 1;
                n3 = n2 - n4 - 2;
            } else {
                n4 = this.e;
                n3 = n2 - n4 - 1;
            }
            if (!bl5 && n3 < 18) {
                d2 = (double)l2 / (double)l3;
                if (bl) {
                    d2 = -d2;
                }
            } else {
                String string = this.subString(n4, n3);
                d2 = Double.parseDouble(string);
            }
        } else {
            if (c3 == 'n' && this.charAt(n2++) == 'u' && this.charAt(n2++) == 'l' && this.charAt(n2++) == 'l') {
                this.matchStat = 5;
                double d3 = 0.0;
                c3 = this.charAt(n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e = n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return d3;
                    }
                    if (c3 == ']') {
                        this.e = n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return d3;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(n2++);
                }
                this.matchStat = -1;
                return 0.0;
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (c3 == c2) {
            this.e = n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return d2;
        }
        this.matchStat = -1;
        return d2;
    }

    @Override
    public long scanLong(char c2) {
        long l2;
        boolean bl;
        char c3;
        boolean bl2;
        this.matchStat = 0;
        int n2 = this.e;
        boolean bl3 = bl2 = (c3 = this.charAt(n2++)) == '\"';
        if (bl2) {
            c3 = this.charAt(n2++);
        }
        boolean bl4 = bl = c3 == '-';
        if (bl) {
            c3 = this.charAt(n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            boolean bl5;
            l2 = c3 - 48;
            while ((c3 = this.charAt(n2++)) >= '0' && c3 <= '9') {
                l2 = l2 * 10L + (long)(c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (bl2) {
                if (c3 != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                c3 = this.charAt(n2++);
            }
            boolean bl6 = bl5 = l2 >= 0L || l2 == Long.MIN_VALUE && bl;
            if (!bl5) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            if (c3 == 'n' && this.charAt(n2++) == 'u' && this.charAt(n2++) == 'l' && this.charAt(n2++) == 'l') {
                this.matchStat = 5;
                long l3 = 0L;
                c3 = this.charAt(n2++);
                if (bl2 && c3 == '\"') {
                    c3 = this.charAt(n2++);
                }
                while (true) {
                    if (c3 == ',') {
                        this.e = n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 16;
                        return l3;
                    }
                    if (c3 == ']') {
                        this.e = n2;
                        this.d = this.charAt(this.e);
                        this.matchStat = 5;
                        this.a = 15;
                        return l3;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(n2++);
                }
                this.matchStat = -1;
                return 0L;
            }
            this.matchStat = -1;
            return 0L;
        }
        while (true) {
            if (c3 == c2) {
                this.e = n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return bl ? -l2 : l2;
            }
            if (!JSONScanner.isWhitespace(c3)) break;
            c3 = this.charAt(n2++);
        }
        this.matchStat = -1;
        return l2;
    }

    @Override
    public Date scanDate(char c2) {
        Date date;
        char c3;
        char c4;
        int n2;
        block24: {
            this.matchStat = 0;
            n2 = this.e;
            c4 = this.d;
            int n3 = this.e;
            if ((c3 = this.charAt(n3++)) == '\"') {
                int n4 = n3;
                int n5 = this.indexOf('\"', n4);
                if (n5 == -1) {
                    throw new JSONException("unclosed str");
                }
                int n6 = n5 - n4;
                this.e = n3;
                if (!this.a(false, n6)) {
                    this.e = n2;
                    this.d = c4;
                    this.matchStat = -1;
                    return null;
                }
                date = this.k.getTime();
                c3 = this.charAt(n5 + 1);
                this.e = n2;
                while (true) {
                    if (c3 == ',' || c3 == ']') {
                        this.e = n5 + 1;
                        this.d = c3;
                        break block24;
                    }
                    if (!JSONScanner.isWhitespace(c3)) break;
                    c3 = this.charAt(++n5 + 1);
                }
                this.e = n2;
                this.d = c4;
                this.matchStat = -1;
                return null;
            }
            if (c3 == '-' || c3 >= '0' && c3 <= '9') {
                long l2 = 0L;
                boolean bl = false;
                if (c3 == '-') {
                    c3 = this.charAt(n3++);
                    bl = true;
                }
                if (c3 >= '0' && c3 <= '9') {
                    l2 = c3 - 48;
                    while ((c3 = this.charAt(n3++)) >= '0' && c3 <= '9') {
                        l2 = l2 * 10L + (long)(c3 - 48);
                    }
                    if (c3 == ',' || c3 == ']') {
                        this.e = n3 - 1;
                    }
                }
                if (l2 < 0L) {
                    this.e = n2;
                    this.d = c4;
                    this.matchStat = -1;
                    return null;
                }
                if (bl) {
                    l2 = -l2;
                }
                date = new Date(l2);
            } else if (c3 == 'n' && this.charAt(n3++) == 'u' && this.charAt(n3++) == 'l' && this.charAt(n3++) == 'l') {
                date = null;
                c3 = this.charAt(n3);
                this.e = n3;
            } else {
                this.e = n2;
                this.d = c4;
                this.matchStat = -1;
                return null;
            }
        }
        if (c3 == ',') {
            this.d = this.charAt(++this.e);
            this.matchStat = 3;
            return date;
        }
        if ((c3 = this.charAt(++this.e)) == ',') {
            this.a = 16;
            this.d = this.charAt(++this.e);
        } else if (c3 == ']') {
            this.a = 15;
            this.d = this.charAt(++this.e);
        } else if (c3 == '}') {
            this.a = 13;
            this.d = this.charAt(++this.e);
        } else if (c3 == '\u001a') {
            this.d = (char)26;
            this.a = 20;
        } else {
            this.e = n2;
            this.d = c4;
            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return date;
    }

    @Override
    protected final void a(int n2, char[] cArray, int n3, int n4) {
        this.r.getChars(n2, n2 + n4, cArray, n3);
    }

    @Override
    public String info() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 1;
        int n3 = 1;
        int n4 = 0;
        while (n4 < this.e) {
            char c2 = this.r.charAt(n4);
            if (c2 == '\n') {
                n3 = 1;
                ++n2;
            }
            ++n4;
            ++n3;
        }
        stringBuilder.append("pos ").append(this.e).append(", line ").append(n2).append(", column ").append(n3);
        if (this.r.length() < 65535) {
            stringBuilder.append(this.r);
        } else {
            stringBuilder.append(this.r.substring(0, 65535));
        }
        return stringBuilder.toString();
    }

    @Override
    public String[] scanFieldStringArray(char[] cArray, int n2, SymbolTable symbolTable) {
        String[] stringArray;
        char c2;
        int n3;
        int n4 = this.e;
        char c3 = this.d;
        while (JSONScanner.isWhitespace(this.d)) {
            this.next();
        }
        if (cArray != null) {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            n3 = this.e + cArray.length;
            c2 = this.r.charAt(n3++);
            while (JSONScanner.isWhitespace(c2)) {
                c2 = this.r.charAt(n3++);
            }
            if (c2 == ':') {
                c2 = this.r.charAt(n3++);
            } else {
                this.matchStat = -1;
                return null;
            }
            while (JSONScanner.isWhitespace(c2)) {
                c2 = this.r.charAt(n3++);
            }
        } else {
            n3 = this.e + 1;
            c2 = this.d;
        }
        if (c2 != '[') {
            if (c2 == 'n' && this.r.startsWith("ull", this.e + 1)) {
                this.e += 4;
                this.d = this.r.charAt(this.e);
                return null;
            }
            this.matchStat = -1;
            return null;
        }
        this.e = n3;
        this.d = this.r.charAt(this.e);
        String[] stringArray2 = n2 >= 0 ? new String[n2] : new String[4];
        int n5 = 0;
        while (true) {
            if (JSONScanner.isWhitespace(this.d)) {
                this.next();
                continue;
            }
            if (this.d != '\"') {
                this.e = n4;
                this.d = c3;
                this.matchStat = -1;
                return null;
            }
            stringArray = this.scanSymbol(symbolTable, '\"');
            if (n5 == stringArray2.length) {
                int n6 = stringArray2.length + (stringArray2.length >> 1) + 1;
                String[] stringArray3 = new String[n6];
                System.arraycopy(stringArray2, 0, stringArray3, 0, stringArray2.length);
                stringArray2 = stringArray3;
            }
            stringArray2[n5++] = stringArray;
            while (JSONScanner.isWhitespace(this.d)) {
                this.next();
            }
            if (this.d != ',') break;
            this.next();
        }
        if (stringArray2.length != n5) {
            stringArray = new String[n5];
            System.arraycopy(stringArray2, 0, stringArray, 0, n5);
            stringArray2 = stringArray;
        }
        while (JSONScanner.isWhitespace(this.d)) {
            this.next();
        }
        if (this.d != ']') {
            this.e = n4;
            this.d = c3;
            this.matchStat = -1;
            return null;
        }
        this.next();
        return stringArray2;
    }

    @Override
    public boolean matchField2(char[] cArray) {
        while (JSONScanner.isWhitespace(this.d)) {
            this.next();
        }
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n2 = this.e + cArray.length;
        char c2 = this.r.charAt(n2++);
        while (JSONScanner.isWhitespace(c2)) {
            c2 = this.r.charAt(n2++);
        }
        if (c2 == ':') {
            this.e = n2;
            this.d = this.charAt(this.e);
            return true;
        }
        this.matchStat = -2;
        return false;
    }

    @Override
    public final void skipObject() {
        this.skipObject(false);
    }

    @Override
    public final void skipObject(boolean bl) {
        int n2;
        int n3;
        boolean bl2 = false;
        int n4 = 0;
        for (n3 = this.e; n3 < this.r.length(); ++n3) {
            n2 = this.r.charAt(n3);
            if (n2 == 92) {
                if (n3 < this.s - 1) {
                    ++n3;
                    continue;
                }
                this.d = (char)n2;
                this.e = n3;
                throw new JSONException("illegal str, " + this.info());
            }
            if (n2 == 34) {
                bl2 = !bl2;
                continue;
            }
            if (n2 == 123) {
                if (bl2) continue;
                ++n4;
                continue;
            }
            if (n2 != 125 || bl2 || --n4 != -1) continue;
            this.e = n3 + 1;
            if (this.e == this.r.length()) {
                this.d = (char)26;
                this.a = 20;
                return;
            }
            this.d = this.r.charAt(this.e);
            if (this.d == ',') {
                int n5;
                this.a = 16;
                this.d = (char)((n5 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n5));
                return;
            }
            if (this.d == '}') {
                this.a = 13;
                this.next();
                return;
            }
            if (this.d == ']') {
                this.a = 15;
                this.next();
                return;
            }
            this.nextToken(16);
            return;
        }
        for (n2 = 0; n2 < this.e; ++n2) {
            if (n2 >= this.r.length() || this.r.charAt(n2) != ' ') continue;
            ++n3;
        }
        if (n3 == this.r.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    @Override
    public final void skipArray() {
        this.skipArray(false);
    }

    public final void skipArray(boolean bl) {
        int n2;
        boolean bl2 = false;
        int n3 = 0;
        for (n2 = this.e; n2 < this.r.length(); ++n2) {
            char c2 = this.r.charAt(n2);
            if (c2 == '\\') {
                if (n2 < this.s - 1) {
                    ++n2;
                    continue;
                }
                this.d = c2;
                this.e = n2;
                throw new JSONException("illegal str, " + this.info());
            }
            if (c2 == '\"') {
                bl2 = !bl2;
                continue;
            }
            if (c2 == '[') {
                if (bl2) continue;
                ++n3;
                continue;
            }
            if (c2 == '{' && bl) {
                int n4;
                this.d = (char)((n4 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n4));
                this.skipObject(bl);
                continue;
            }
            if (c2 != ']' || bl2 || --n3 != -1) continue;
            this.e = n2 + 1;
            if (this.e == this.r.length()) {
                this.d = (char)26;
                this.a = 20;
                return;
            }
            this.d = this.r.charAt(this.e);
            this.nextToken(16);
            return;
        }
        if (n2 == this.r.length()) {
            throw new JSONException("illegal str, " + this.info());
        }
    }

    public final void skipString() {
        if (this.d == '\"') {
            for (int i2 = this.e + 1; i2 < this.r.length(); ++i2) {
                char c2 = this.r.charAt(i2);
                if (c2 == '\\') {
                    if (i2 >= this.s - 1) continue;
                    ++i2;
                    continue;
                }
                if (c2 != '\"') continue;
                this.e = i2 + 1;
                this.d = this.r.charAt(this.e);
                return;
            }
            throw new JSONException("unclosed str");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean seekArrayToItem(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("index must > 0, but " + n2);
        }
        if (this.a == 20) {
            return false;
        }
        if (this.a != 14) {
            throw new UnsupportedOperationException();
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.skipWhitespace();
            if (this.d == '\"' || this.d == '\'') {
                this.skipString();
                if (this.d == ',') {
                    this.next();
                    continue;
                }
                if (this.d == ']') {
                    this.next();
                    this.nextToken(16);
                    return false;
                }
                throw new JSONException("illegal json.");
            }
            if (this.d == '{') {
                this.next();
                this.a = 12;
                this.skipObject(false);
            } else if (this.d == '[') {
                this.next();
                this.a = 14;
                this.skipArray(false);
            } else {
                boolean bl = false;
                for (int i3 = this.e + 1; i3 < this.r.length(); ++i3) {
                    char c2 = this.r.charAt(i3);
                    if (c2 == ',') {
                        bl = true;
                        this.e = i3 + 1;
                        this.d = this.charAt(this.e);
                        break;
                    }
                    if (c2 != ']') continue;
                    this.e = i3 + 1;
                    this.d = this.charAt(this.e);
                    this.nextToken();
                    return false;
                }
                if (bl) continue;
                throw new JSONException("illegal json.");
            }
            if (this.a == 16) continue;
            if (this.a == 15) {
                return false;
            }
            throw new UnsupportedOperationException();
        }
        this.nextToken();
        return true;
    }

    @Override
    public int seekObjectToField(long l2, boolean bl) {
        block57: {
            if (this.a == 20) {
                return -1;
            }
            if (this.a == 13 || this.a == 15) {
                this.nextToken();
                return -1;
            }
            if (this.a != 12 && this.a != 16) {
                throw new UnsupportedOperationException(JSONToken.name(this.a));
            }
            while (true) {
                int n2;
                long l3;
                if (this.d == '}') {
                    this.next();
                    this.nextToken();
                    return -1;
                }
                if (this.d == '\u001a') {
                    return -1;
                }
                if (this.d != '\"') {
                    this.skipWhitespace();
                }
                if (this.d == '\"') {
                    l3 = -3750763034362895579L;
                    for (n2 = this.e + 1; n2 < this.r.length(); ++n2) {
                        char c2 = this.r.charAt(n2);
                        if (c2 == '\\') {
                            if (++n2 == this.r.length()) {
                                throw new JSONException("unclosed str, " + this.info());
                            }
                            c2 = this.r.charAt(n2);
                        }
                        if (c2 == '\"') {
                            this.e = n2 + 1;
                            this.d = (char)(this.e >= this.r.length() ? 26 : (int)this.r.charAt(this.e));
                            break;
                        }
                        l3 ^= (long)c2;
                        l3 *= 1099511628211L;
                    }
                } else {
                    throw new UnsupportedOperationException();
                }
                if (l3 == l2) {
                    if (this.d != ':') {
                        this.skipWhitespace();
                    }
                    if (this.d == ':') {
                        this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                        if (this.d == ',') {
                            this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                            this.a = 16;
                        } else if (this.d == ']') {
                            this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                            this.a = 15;
                        } else if (this.d == '}') {
                            this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                            this.a = 13;
                        } else if (this.d >= '0' && this.d <= '9') {
                            this.h = 0;
                            this.b = this.e;
                            this.scanNumber();
                        } else {
                            this.nextToken(2);
                        }
                    }
                    return 3;
                }
                if (this.d != ':') {
                    this.skipWhitespace();
                }
                if (this.d != ':') {
                    throw new JSONException("illegal json, " + this.info());
                }
                this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                if (this.d != '\"' && this.d != '\'' && this.d != '{' && this.d != '[' && this.d != '0' && this.d != '1' && this.d != '2' && this.d != '3' && this.d != '4' && this.d != '5' && this.d != '6' && this.d != '7' && this.d != '8' && this.d != '9' && this.d != '+' && this.d != '-') {
                    this.skipWhitespace();
                }
                if (this.d == '-' || this.d == '+' || this.d >= '0' && this.d <= '9') {
                    this.next();
                    while (this.d >= '0' && this.d <= '9') {
                        this.next();
                    }
                    if (this.d == '.') {
                        this.next();
                        while (this.d >= '0' && this.d <= '9') {
                            this.next();
                        }
                    }
                    if (this.d == 'E' || this.d == 'e') {
                        this.next();
                        if (this.d == '-' || this.d == '+') {
                            this.next();
                        }
                        while (this.d >= '0' && this.d <= '9') {
                            this.next();
                        }
                    }
                    if (this.d != ',') {
                        this.skipWhitespace();
                    }
                    if (this.d != ',') continue;
                    this.next();
                    continue;
                }
                if (this.d == '\"') {
                    this.skipString();
                    if (this.d != ',' && this.d != '}') {
                        this.skipWhitespace();
                    }
                    if (this.d != ',') continue;
                    this.next();
                    continue;
                }
                if (this.d == 't') {
                    this.next();
                    if (this.d == 'r') {
                        this.next();
                        if (this.d == 'u') {
                            this.next();
                            if (this.d == 'e') {
                                this.next();
                            }
                        }
                    }
                    if (this.d != ',' && this.d != '}') {
                        this.skipWhitespace();
                    }
                    if (this.d != ',') continue;
                    this.next();
                    continue;
                }
                if (this.d == 'n') {
                    this.next();
                    if (this.d == 'u') {
                        this.next();
                        if (this.d == 'l') {
                            this.next();
                            if (this.d == 'l') {
                                this.next();
                            }
                        }
                    }
                    if (this.d != ',' && this.d != '}') {
                        this.skipWhitespace();
                    }
                    if (this.d != ',') continue;
                    this.next();
                    continue;
                }
                if (this.d == 'f') {
                    this.next();
                    if (this.d == 'a') {
                        this.next();
                        if (this.d == 'l') {
                            this.next();
                            if (this.d == 's') {
                                this.next();
                                if (this.d == 'e') {
                                    this.next();
                                }
                            }
                        }
                    }
                    if (this.d != ',' && this.d != '}') {
                        this.skipWhitespace();
                    }
                    if (this.d != ',') continue;
                    this.next();
                    continue;
                }
                if (this.d == '{') {
                    this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                    if (bl) {
                        this.a = 12;
                        return 1;
                    }
                    this.skipObject(false);
                    if (this.a != 13) continue;
                    return -1;
                }
                if (this.d != '[') break block57;
                this.next();
                if (bl) {
                    this.a = 14;
                    return 2;
                }
                this.skipArray(false);
                if (this.a == 13) break;
            }
            return -1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public int seekObjectToField(long[] lArray) {
        if (this.a != 12 && this.a != 16) {
            throw new UnsupportedOperationException();
        }
        while (true) {
            int n2;
            int n3;
            long l2;
            if (this.d == '}') {
                this.next();
                this.nextToken();
                this.matchStat = -1;
                return -1;
            }
            if (this.d == '\u001a') {
                this.matchStat = -1;
                return -1;
            }
            if (this.d != '\"') {
                this.skipWhitespace();
            }
            if (this.d == '\"') {
                l2 = -3750763034362895579L;
                for (n3 = this.e + 1; n3 < this.r.length(); ++n3) {
                    n2 = this.r.charAt(n3);
                    if (n2 == 92) {
                        if (++n3 == this.r.length()) {
                            throw new JSONException("unclosed str, " + this.info());
                        }
                        n2 = this.r.charAt(n3);
                    }
                    if (n2 == 34) {
                        this.e = n3 + 1;
                        this.d = (char)(this.e >= this.r.length() ? 26 : (int)this.r.charAt(this.e));
                        break;
                    }
                    l2 ^= (long)n2;
                    l2 *= 1099511628211L;
                }
            } else {
                throw new UnsupportedOperationException();
            }
            n3 = -1;
            for (n2 = 0; n2 < lArray.length; ++n2) {
                if (l2 != lArray[n2]) continue;
                n3 = n2;
                break;
            }
            if (n3 != -1) {
                if (this.d != ':') {
                    this.skipWhitespace();
                }
                if (this.d == ':') {
                    this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                    if (this.d == ',') {
                        this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                        this.a = 16;
                    } else if (this.d == ']') {
                        this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                        this.a = 15;
                    } else if (this.d == '}') {
                        this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                        this.a = 13;
                    } else if (this.d >= '0' && this.d <= '9') {
                        this.h = 0;
                        this.b = this.e;
                        this.scanNumber();
                    } else {
                        this.nextToken(2);
                    }
                }
                this.matchStat = 3;
                return n3;
            }
            if (this.d != ':') {
                this.skipWhitespace();
            }
            if (this.d != ':') {
                throw new JSONException("illegal json, " + this.info());
            }
            this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
            if (this.d != '\"' && this.d != '\'' && this.d != '{' && this.d != '[' && this.d != '0' && this.d != '1' && this.d != '2' && this.d != '3' && this.d != '4' && this.d != '5' && this.d != '6' && this.d != '7' && this.d != '8' && this.d != '9' && this.d != '+' && this.d != '-') {
                this.skipWhitespace();
            }
            if (this.d == '-' || this.d == '+' || this.d >= '0' && this.d <= '9') {
                this.next();
                while (this.d >= '0' && this.d <= '9') {
                    this.next();
                }
                if (this.d == '.') {
                    this.next();
                    while (this.d >= '0' && this.d <= '9') {
                        this.next();
                    }
                }
                if (this.d == 'E' || this.d == 'e') {
                    this.next();
                    if (this.d == '-' || this.d == '+') {
                        this.next();
                    }
                    while (this.d >= '0' && this.d <= '9') {
                        this.next();
                    }
                }
                if (this.d != ',') {
                    this.skipWhitespace();
                }
                if (this.d != ',') continue;
                this.next();
                continue;
            }
            if (this.d == '\"') {
                this.skipString();
                if (this.d != ',' && this.d != '}') {
                    this.skipWhitespace();
                }
                if (this.d != ',') continue;
                this.next();
                continue;
            }
            if (this.d == '{') {
                this.d = (char)((n2 = ++this.e) >= this.r.length() ? 26 : (int)this.r.charAt(n2));
                this.skipObject(false);
                continue;
            }
            if (this.d != '[') break;
            this.next();
            this.skipArray(false);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        int n2;
        if (this.r.startsWith("\"@type\":\"", this.e) && (n2 = this.r.indexOf(34, this.e + 9)) != -1) {
            this.e += 9;
            int n3 = 0;
            for (int i2 = this.e; i2 < n2; ++i2) {
                n3 = 31 * n3 + this.r.charAt(i2);
            }
            String string = this.addSymbol(this.e, n2 - this.e, n3, symbolTable);
            char c2 = this.r.charAt(n2 + 1);
            if (c2 != ',' && c2 != ']') {
                return null;
            }
            this.e = n2 + 2;
            this.d = this.r.charAt(this.e);
            return string;
        }
        return null;
    }
}

