/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser.deserializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.deserializer.ContextObjectDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.ContextObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.lang.reflect.Type;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class Jdk8DateCodec
extends ContextObjectDeserializer
implements ObjectDeserializer,
ContextObjectSerializer,
ObjectSerializer {
    public static final Jdk8DateCodec instance = new Jdk8DateCodec();
    private static final DateTimeFormatter a = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter b = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
    private static final DateTimeFormatter c = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
    private static final DateTimeFormatter d = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 HH:mm:ss");
    private static final DateTimeFormatter e = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5 H\u65f6m\u5206s\u79d2");
    private static final DateTimeFormatter f = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c HH:mm:ss");
    private static final DateTimeFormatter g = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm:ss");
    private static final DateTimeFormatter h = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
    private static final DateTimeFormatter i = DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm:ss");
    private static final DateTimeFormatter j = DateTimeFormatter.ofPattern("dd-MM-yyyy HH:mm:ss");
    private static final DateTimeFormatter k = DateTimeFormatter.ofPattern("yyyyMMdd");
    private static final DateTimeFormatter l = DateTimeFormatter.ofPattern("yyyy/MM/dd");
    private static final DateTimeFormatter m = DateTimeFormatter.ofPattern("yyyy\u5e74M\u6708d\u65e5");
    private static final DateTimeFormatter n = DateTimeFormatter.ofPattern("yyyy\ub144M\uc6d4d\uc77c");
    private static final DateTimeFormatter o = DateTimeFormatter.ofPattern("MM/dd/yyyy");
    private static final DateTimeFormatter p = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter q = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private static final DateTimeFormatter r = DateTimeFormatter.ofPattern("dd-MM-yyyy");
    private static final DateTimeFormatter s = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter t = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object, String string, int n2) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 8) {
            jSONLexer.nextToken();
            return null;
        }
        if (jSONLexer.token() == 4) {
            String string2 = jSONLexer.stringVal();
            jSONLexer.nextToken();
            DateTimeFormatter dateTimeFormatter = null;
            if (string != null) {
                dateTimeFormatter = "yyyy-MM-dd HH:mm:ss".equals(string) ? a : DateTimeFormatter.ofPattern(string);
            }
            if ("".equals(string2)) {
                return null;
            }
            if (type == LocalDateTime.class) {
                LocalDateTime localDateTime;
                if (string2.length() == 10 || string2.length() == 8) {
                    LocalDate localDate = this.a(string2, string, dateTimeFormatter);
                    localDateTime = LocalDateTime.of(localDate, LocalTime.MIN);
                } else {
                    localDateTime = this.a(string2, dateTimeFormatter);
                }
                return (T)localDateTime;
            }
            if (type == LocalDate.class) {
                LocalDate localDate;
                if (string2.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(string2);
                    localDate = LocalDate.of(localDateTime.getYear(), localDateTime.getMonthValue(), localDateTime.getDayOfMonth());
                } else {
                    localDate = this.a(string2, string, dateTimeFormatter);
                }
                return (T)localDate;
            }
            if (type == LocalTime.class) {
                LocalTime localTime;
                if (string2.length() == 23) {
                    LocalDateTime localDateTime = LocalDateTime.parse(string2);
                    localTime = LocalTime.of(localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond(), localDateTime.getNano());
                } else {
                    boolean bl = true;
                    for (int i2 = 0; i2 < string2.length(); ++i2) {
                        char c2 = string2.charAt(i2);
                        if (c2 >= '0' && c2 <= '9') continue;
                        bl = false;
                        break;
                    }
                    if (bl && string2.length() > 8 && string2.length() < 19) {
                        long l2 = Long.parseLong(string2);
                        localTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId()).toLocalTime();
                    } else {
                        localTime = LocalTime.parse(string2);
                    }
                }
                return (T)localTime;
            }
            if (type == ZonedDateTime.class) {
                Object object2;
                if (dateTimeFormatter == a) {
                    dateTimeFormatter = s;
                }
                if (dateTimeFormatter == null && string2.length() <= 19) {
                    object2 = new JSONScanner(string2);
                    TimeZone timeZone = defaultJSONParser.lexer.getTimeZone();
                    ((JSONLexerBase)object2).setTimeZone(timeZone);
                    boolean bl = ((JSONScanner)object2).scanISO8601DateIfMatch(false);
                    if (bl) {
                        Date date = ((JSONLexerBase)object2).getCalendar().getTime();
                        return (T)ZonedDateTime.ofInstant(date.toInstant(), timeZone.toZoneId());
                    }
                }
                object2 = this.b(string2, dateTimeFormatter);
                return (T)object2;
            }
            if (type == OffsetDateTime.class) {
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(string2);
                return (T)offsetDateTime;
            }
            if (type == OffsetTime.class) {
                OffsetTime offsetTime = OffsetTime.parse(string2);
                return (T)offsetTime;
            }
            if (type == ZoneId.class) {
                ZoneId zoneId = ZoneId.of(string2);
                return (T)zoneId;
            }
            if (type == Period.class) {
                Period period = Period.parse(string2);
                return (T)period;
            }
            if (type == Duration.class) {
                Duration duration = Duration.parse(string2);
                return (T)duration;
            }
            if (type == Instant.class) {
                boolean bl = true;
                for (int i3 = 0; i3 < string2.length(); ++i3) {
                    char c3 = string2.charAt(i3);
                    if (c3 >= '0' && c3 <= '9') continue;
                    bl = false;
                    break;
                }
                if (bl && string2.length() > 8 && string2.length() < 19) {
                    long l3 = Long.parseLong(string2);
                    return (T)Instant.ofEpochMilli(l3);
                }
                Instant instant = Instant.parse(string2);
                return (T)instant;
            }
        } else {
            if (jSONLexer.token() == 2) {
                long l4 = jSONLexer.longValue();
                jSONLexer.nextToken();
                if ("unixtime".equals(string)) {
                    l4 *= 1000L;
                } else if ("yyyyMMddHHmmss".equals(string)) {
                    int n3 = (int)(l4 / 10000000000L);
                    int n4 = (int)(l4 / 100000000L % 100L);
                    int n5 = (int)(l4 / 1000000L % 100L);
                    int n6 = (int)(l4 / 10000L % 100L);
                    int n7 = (int)(l4 / 100L % 100L);
                    int n8 = (int)(l4 % 100L);
                    if (type == LocalDateTime.class) {
                        return (T)LocalDateTime.of(n3, n4, n5, n6, n7, n8);
                    }
                }
                if (type == LocalDateTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l4), JSON.defaultTimeZone.toZoneId());
                }
                if (type == LocalDate.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l4), JSON.defaultTimeZone.toZoneId()).toLocalDate();
                }
                if (type == LocalTime.class) {
                    return (T)LocalDateTime.ofInstant(Instant.ofEpochMilli(l4), JSON.defaultTimeZone.toZoneId()).toLocalTime();
                }
                if (type == ZonedDateTime.class) {
                    return (T)ZonedDateTime.ofInstant(Instant.ofEpochMilli(l4), JSON.defaultTimeZone.toZoneId());
                }
                if (type == Instant.class) {
                    return (T)Instant.ofEpochMilli(l4);
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        return null;
    }

    protected LocalDateTime a(String string, DateTimeFormatter dateTimeFormatter) {
        char c2;
        int n2;
        char c3;
        if (dateTimeFormatter == null) {
            char c4;
            char c5;
            char c6;
            if (string.length() == 19) {
                c6 = string.charAt(4);
                c3 = string.charAt(7);
                n2 = string.charAt(10);
                c2 = string.charAt(13);
                c5 = string.charAt(16);
                if (c2 == ':' && c5 == ':') {
                    if (c6 == '-' && c3 == '-') {
                        if (n2 == 84) {
                            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                        } else if (n2 == 32) {
                            dateTimeFormatter = a;
                        }
                    } else if (c6 == '/' && c3 == '/') {
                        dateTimeFormatter = c;
                    } else {
                        c4 = string.charAt(0);
                        char c7 = string.charAt(1);
                        char c8 = string.charAt(2);
                        char c9 = string.charAt(3);
                        char c10 = string.charAt(5);
                        if (c8 == '/' && c10 == '/') {
                            int n3 = (c4 - 48) * 10 + (c7 - 48);
                            int n4 = (c9 - 48) * 10 + (c6 - 48);
                            if (n3 > 12) {
                                dateTimeFormatter = h;
                            } else if (n4 > 12) {
                                dateTimeFormatter = g;
                            } else {
                                String string2 = Locale.getDefault().getCountry();
                                if (string2.equals("US")) {
                                    dateTimeFormatter = g;
                                } else if (string2.equals("BR") || string2.equals("AU")) {
                                    dateTimeFormatter = h;
                                }
                            }
                        } else if (c8 == '.' && c10 == '.') {
                            dateTimeFormatter = i;
                        } else if (c8 == '-' && c10 == '-') {
                            dateTimeFormatter = j;
                        }
                    }
                }
            } else if (string.length() == 23) {
                c6 = string.charAt(4);
                c3 = string.charAt(7);
                n2 = string.charAt(10);
                c2 = string.charAt(13);
                c5 = string.charAt(16);
                c4 = string.charAt(19);
                if (c2 == ':' && c5 == ':' && c6 == '-' && c3 == '-' && n2 == 32 && c4 == '.') {
                    dateTimeFormatter = b;
                }
            }
            if (string.length() >= 17) {
                c6 = string.charAt(4);
                if (c6 == '\u5e74') {
                    dateTimeFormatter = string.charAt(string.length() - 1) == '\u79d2' ? e : d;
                } else if (c6 == '\ub144') {
                    dateTimeFormatter = f;
                }
            }
        }
        if (dateTimeFormatter == null) {
            JSONScanner jSONScanner = new JSONScanner(string);
            if (jSONScanner.scanISO8601DateIfMatch(false)) {
                Instant instant = jSONScanner.getCalendar().toInstant();
                return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            }
            c3 = '\u0001';
            for (n2 = 0; n2 < string.length(); ++n2) {
                c2 = string.charAt(n2);
                if (c2 >= '0' && c2 <= '9') continue;
                c3 = '\u0000';
                break;
            }
            if (c3 != '\u0000' && string.length() > 8 && string.length() < 19) {
                long l2 = Long.parseLong(string);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId());
            }
        }
        return dateTimeFormatter == null ? LocalDateTime.parse(string) : LocalDateTime.parse(string, dateTimeFormatter);
    }

    protected LocalDate a(String string, String string2, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            char c2;
            int n2;
            char c3;
            if (string.length() == 8) {
                dateTimeFormatter = k;
            }
            if (string.length() == 10) {
                c3 = string.charAt(4);
                n2 = string.charAt(7);
                if (c3 == '/' && n2 == 47) {
                    dateTimeFormatter = l;
                }
                c2 = string.charAt(0);
                char c4 = string.charAt(1);
                char c5 = string.charAt(2);
                char c6 = string.charAt(3);
                char c7 = string.charAt(5);
                if (c5 == '/' && c7 == '/') {
                    int n3 = (c2 - 48) * 10 + (c4 - 48);
                    int n4 = (c6 - 48) * 10 + (c3 - 48);
                    if (n3 > 12) {
                        dateTimeFormatter = p;
                    } else if (n4 > 12) {
                        dateTimeFormatter = o;
                    } else {
                        String string3 = Locale.getDefault().getCountry();
                        if (string3.equals("US")) {
                            dateTimeFormatter = o;
                        } else if (string3.equals("BR") || string3.equals("AU")) {
                            dateTimeFormatter = p;
                        }
                    }
                } else if (c5 == '.' && c7 == '.') {
                    dateTimeFormatter = q;
                } else if (c5 == '-' && c7 == '-') {
                    dateTimeFormatter = r;
                }
            }
            if (string.length() >= 9) {
                c3 = string.charAt(4);
                if (c3 == '\u5e74') {
                    dateTimeFormatter = m;
                } else if (c3 == '\ub144') {
                    dateTimeFormatter = n;
                }
            }
            c3 = '\u0001';
            for (n2 = 0; n2 < string.length(); ++n2) {
                c2 = string.charAt(n2);
                if (c2 >= '0' && c2 <= '9') continue;
                c3 = '\u0000';
                break;
            }
            if (c3 != '\u0000' && string.length() > 8 && string.length() < 19) {
                long l2 = Long.parseLong(string);
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId()).toLocalDate();
            }
        }
        return dateTimeFormatter == null ? LocalDate.parse(string) : LocalDate.parse(string, dateTimeFormatter);
    }

    protected ZonedDateTime b(String string, DateTimeFormatter dateTimeFormatter) {
        if (dateTimeFormatter == null) {
            char c2;
            int n2;
            char c3;
            if (string.length() == 19) {
                c3 = string.charAt(4);
                n2 = string.charAt(7);
                c2 = string.charAt(10);
                char c4 = string.charAt(13);
                char c5 = string.charAt(16);
                if (c4 == ':' && c5 == ':') {
                    if (c3 == '-' && n2 == 45) {
                        if (c2 == 'T') {
                            dateTimeFormatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
                        } else if (c2 == ' ') {
                            dateTimeFormatter = a;
                        }
                    } else if (c3 == '/' && n2 == 47) {
                        dateTimeFormatter = c;
                    } else {
                        char c6 = string.charAt(0);
                        char c7 = string.charAt(1);
                        char c8 = string.charAt(2);
                        char c9 = string.charAt(3);
                        char c10 = string.charAt(5);
                        if (c8 == '/' && c10 == '/') {
                            int n3 = (c6 - 48) * 10 + (c7 - 48);
                            int n4 = (c9 - 48) * 10 + (c3 - 48);
                            if (n3 > 12) {
                                dateTimeFormatter = h;
                            } else if (n4 > 12) {
                                dateTimeFormatter = g;
                            } else {
                                String string2 = Locale.getDefault().getCountry();
                                if (string2.equals("US")) {
                                    dateTimeFormatter = g;
                                } else if (string2.equals("BR") || string2.equals("AU")) {
                                    dateTimeFormatter = h;
                                }
                            }
                        } else if (c8 == '.' && c10 == '.') {
                            dateTimeFormatter = i;
                        } else if (c8 == '-' && c10 == '-') {
                            dateTimeFormatter = j;
                        }
                    }
                }
            }
            if (string.length() >= 17) {
                c3 = string.charAt(4);
                if (c3 == '\u5e74') {
                    dateTimeFormatter = string.charAt(string.length() - 1) == '\u79d2' ? e : d;
                } else if (c3 == '\ub144') {
                    dateTimeFormatter = f;
                }
            }
            c3 = '\u0001';
            for (n2 = 0; n2 < string.length(); ++n2) {
                c2 = string.charAt(n2);
                if (c2 >= '0' && c2 <= '9') continue;
                c3 = '\u0000';
                break;
            }
            if (c3 != '\u0000' && string.length() > 8 && string.length() < 19) {
                long l2 = Long.parseLong(string);
                return ZonedDateTime.ofInstant(Instant.ofEpochMilli(l2), JSON.defaultTimeZone.toZoneId());
            }
        }
        return dateTimeFormatter == null ? ZonedDateTime.parse(string) : ZonedDateTime.parse(string, dateTimeFormatter);
    }

    @Override
    public int getFastMatchToken() {
        return 4;
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type clazz, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull();
        } else {
            if (clazz == null) {
                clazz = object.getClass();
            }
            if (clazz == LocalDateTime.class) {
                int n3 = SerializerFeature.UseISO8601DateFormat.getMask();
                LocalDateTime localDateTime = (LocalDateTime)object;
                String string = jSONSerializer.getDateFormatPattern();
                if (string == null) {
                    int n4;
                    string = (n2 & n3) != 0 || jSONSerializer.isEnabled(SerializerFeature.UseISO8601DateFormat) ? "yyyy-MM-dd'T'HH:mm:ss" : (jSONSerializer.isEnabled(SerializerFeature.WriteDateUseDateFormat) ? JSON.DEFFAULT_DATE_FORMAT : ((n4 = localDateTime.getNano()) == 0 ? "yyyy-MM-dd'T'HH:mm:ss" : (n4 % 1000000 == 0 ? "yyyy-MM-dd'T'HH:mm:ss.SSS" : "yyyy-MM-dd'T'HH:mm:ss.SSSSSSSSS")));
                }
                if (string != null) {
                    this.a(serializeWriter, localDateTime, string);
                } else {
                    serializeWriter.writeLong(localDateTime.atZone(JSON.defaultTimeZone.toZoneId()).toInstant().toEpochMilli());
                }
            } else {
                serializeWriter.writeString(object.toString());
            }
        }
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, BeanContext beanContext) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        String string = beanContext.getFormat();
        this.a(serializeWriter, (TemporalAccessor)object, string);
    }

    private void a(SerializeWriter serializeWriter, TemporalAccessor temporalAccessor, String string) {
        Object object;
        if ("unixtime".equals(string)) {
            object = null;
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                long l2 = ((ChronoZonedDateTime)temporalAccessor).toEpochSecond();
                serializeWriter.writeInt((int)l2);
                return;
            }
            if (temporalAccessor instanceof LocalDateTime) {
                long l3 = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toEpochSecond();
                serializeWriter.writeInt((int)l3);
                return;
            }
        }
        if ("millis".equals(string)) {
            object = null;
            if (temporalAccessor instanceof ChronoZonedDateTime) {
                object = ((ChronoZonedDateTime)temporalAccessor).toInstant();
            } else if (temporalAccessor instanceof LocalDateTime) {
                object = ((LocalDateTime)temporalAccessor).atZone(JSON.defaultTimeZone.toZoneId()).toInstant();
            }
            if (object != null) {
                long l4 = ((Instant)object).toEpochMilli();
                serializeWriter.writeLong(l4);
                return;
            }
        }
        DateTimeFormatter dateTimeFormatter = string == "yyyy-MM-dd'T'HH:mm:ss" ? t : DateTimeFormatter.ofPattern(string);
        object = dateTimeFormatter.format(temporalAccessor);
        serializeWriter.writeString((String)object);
    }

    public static Object castToLocalDateTime(Object object, String string) {
        if (object == null) {
            return null;
        }
        if (string == null) {
            string = "yyyy-MM-dd HH:mm:ss";
        }
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(string);
        return LocalDateTime.parse(object.toString(), dateTimeFormatter);
    }
}

