/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;

public class BigDecimalCodec
implements ObjectDeserializer,
ObjectSerializer {
    static final BigDecimal a = BigDecimal.valueOf(-9007199254740991L);
    static final BigDecimal b = BigDecimal.valueOf(0x1FFFFFFFFFFFFFL);
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            BigDecimal bigDecimal = (BigDecimal)object;
            int n3 = bigDecimal.scale();
            String string = SerializerFeature.isEnabled(n2, serializeWriter.c, SerializerFeature.WriteBigDecimalAsPlain) && n3 >= -100 && n3 < 100 ? bigDecimal.toPlainString() : bigDecimal.toString();
            if (n3 == 0 && string.length() >= 16 && SerializerFeature.isEnabled(n2, serializeWriter.c, SerializerFeature.BrowserCompatible) && (bigDecimal.compareTo(a) < 0 || bigDecimal.compareTo(b) > 0)) {
                serializeWriter.writeString(string);
                return;
            }
            serializeWriter.write(string);
            if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && type != BigDecimal.class && bigDecimal.scale() == 0) {
                serializeWriter.write(46);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return BigDecimalCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseDecimal error, field : " + object, exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        if (jSONLexer.token() == 3) {
            BigDecimal bigDecimal = jSONLexer.decimalValue();
            jSONLexer.nextToken(16);
            return (T)bigDecimal;
        }
        Object object = defaultJSONParser.parse();
        return (T)(object == null ? null : TypeUtils.castToBigDecimal(object));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

