/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class FloatCodec
implements ObjectDeserializer,
ObjectSerializer {
    private NumberFormat a;
    public static FloatCodec instance = new FloatCodec();

    public FloatCodec() {
    }

    public FloatCodec(DecimalFormat decimalFormat) {
        this.a = decimalFormat;
    }

    public FloatCodec(String string) {
        this(new DecimalFormat(string));
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        float f2 = ((Float)object).floatValue();
        if (this.a != null) {
            String string = this.a.format(f2);
            serializeWriter.write(string);
        } else {
            serializeWriter.writeFloat(f2, true);
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        try {
            return FloatCodec.deserialze(defaultJSONParser);
        }
        catch (Exception exception) {
            throw new JSONException("parseLong error, field : " + object, exception);
        }
    }

    public static <T> T deserialze(DefaultJSONParser defaultJSONParser) {
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        if (jSONLexer.token() == 2) {
            String string = jSONLexer.numberString();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(Float.parseFloat(string));
        }
        if (jSONLexer.token() == 3) {
            float f2 = jSONLexer.floatValue();
            jSONLexer.nextToken(16);
            return (T)Float.valueOf(f2);
        }
        Object object = defaultJSONParser.parse();
        if (object == null) {
            return null;
        }
        return (T)TypeUtils.castToFloat(object);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

