/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicInteger;

public class IntegerCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static IntegerCodec instance = new IntegerCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        Number number = (Number)object;
        if (number == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
            return;
        }
        if (object instanceof Long) {
            serializeWriter.writeLong(number.longValue());
        } else {
            serializeWriter.writeInt(number.intValue());
        }
        if (serializeWriter.isEnabled(SerializerFeature.WriteClassName)) {
            Class<?> clazz = number.getClass();
            if (clazz == Byte.class) {
                serializeWriter.write(66);
            } else if (clazz == Short.class) {
                serializeWriter.write(83);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Integer n2;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        int n3 = jSONLexer.token();
        if (n3 == 8) {
            jSONLexer.nextToken(16);
            return null;
        }
        try {
            if (n3 == 2) {
                int n4 = jSONLexer.intValue();
                jSONLexer.nextToken(16);
                n2 = n4;
            } else if (n3 == 3) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                n2 = TypeUtils.intValue(bigDecimal);
                jSONLexer.nextToken(16);
            } else if (n3 == 12) {
                JSONObject jSONObject = new JSONObject(true);
                defaultJSONParser.parseObject(jSONObject);
                n2 = TypeUtils.castToInt(jSONObject);
            } else {
                Object object2 = defaultJSONParser.parse();
                n2 = TypeUtils.castToInt(object2);
            }
        }
        catch (Exception exception) {
            String string = "parseInt error";
            if (object != null) {
                string = string + ", field : " + object;
            }
            throw new JSONException(string, exception);
        }
        if (type == AtomicInteger.class) {
            return (T)new AtomicInteger(n2);
        }
        return (T)n2;
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

