/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.TypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicLong;

public class LongCodec
implements ObjectDeserializer,
ObjectSerializer {
    public static LongCodec instance = new LongCodec();

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            long l2 = (Long)object;
            serializeWriter.writeLong(l2);
            if (serializeWriter.isEnabled(SerializerFeature.WriteClassName) && l2 <= Integer.MAX_VALUE && l2 >= Integer.MIN_VALUE && type != Long.class && type != Long.TYPE) {
                serializeWriter.write(76);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        Long l2;
        JSONLexer jSONLexer = defaultJSONParser.lexer;
        try {
            int n2 = jSONLexer.token();
            if (n2 == 2) {
                long l3 = jSONLexer.longValue();
                jSONLexer.nextToken(16);
                l2 = l3;
            } else if (n2 == 3) {
                BigDecimal bigDecimal = jSONLexer.decimalValue();
                l2 = TypeUtils.longValue(bigDecimal);
                jSONLexer.nextToken(16);
            } else {
                if (n2 == 12) {
                    JSONObject jSONObject = new JSONObject(true);
                    defaultJSONParser.parseObject(jSONObject);
                    l2 = TypeUtils.castToLong(jSONObject);
                } else {
                    Object object2 = defaultJSONParser.parse();
                    l2 = TypeUtils.castToLong(object2);
                }
                if (l2 == null) {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            throw new JSONException("parseLong error, field : " + object, exception);
        }
        return (T)(type == AtomicLong.class ? new AtomicLong(l2) : l2);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

