/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import java.lang.reflect.Type;

public class PrimitiveArraySerializer
implements ObjectSerializer {
    public static PrimitiveArraySerializer instance = new PrimitiveArraySerializer();

    @Override
    public final void write(JSONSerializer jSONSerializer, Object object, Object object2, Type type, int n2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        if (object == null) {
            serializeWriter.writeNull(SerializerFeature.WriteNullListAsEmpty);
            return;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            serializeWriter.write(91);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (i2 != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeInt(nArray[i2]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof short[]) {
            short[] sArray = (short[])object;
            serializeWriter.write(91);
            for (int i3 = 0; i3 < sArray.length; ++i3) {
                if (i3 != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeInt(sArray[i3]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof long[]) {
            long[] lArray = (long[])object;
            serializeWriter.write(91);
            for (int i4 = 0; i4 < lArray.length; ++i4) {
                if (i4 != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.writeLong(lArray[i4]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            serializeWriter.write(91);
            for (int i5 = 0; i5 < blArray.length; ++i5) {
                if (i5 != 0) {
                    serializeWriter.write(44);
                }
                serializeWriter.write(blArray[i5]);
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof float[]) {
            float[] fArray = (float[])object;
            serializeWriter.write(91);
            for (int i6 = 0; i6 < fArray.length; ++i6) {
                float f2;
                if (i6 != 0) {
                    serializeWriter.write(44);
                }
                if (Float.isNaN(f2 = fArray[i6])) {
                    serializeWriter.writeNull();
                    continue;
                }
                serializeWriter.append(Float.toString(f2));
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            serializeWriter.write(91);
            for (int i7 = 0; i7 < dArray.length; ++i7) {
                double d2;
                if (i7 != 0) {
                    serializeWriter.write(44);
                }
                if (Double.isNaN(d2 = dArray[i7])) {
                    serializeWriter.writeNull();
                    continue;
                }
                serializeWriter.append(Double.toString(d2));
            }
            serializeWriter.write(93);
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            serializeWriter.writeByteArray(byArray);
            return;
        }
        char[] cArray = (char[])object;
        serializeWriter.writeString(cArray);
    }
}

