/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.util.ACache;
import com.tradplus.ads.network.response.ConfigResponse;
import com.tradplus.ads.pushcenter.PushCenter;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;

public class FrequencyUtils {
    private static FrequencyUtils a;
    private String b = "frequency";
    private String c = "frequency_click_time";
    private String d = "frequency_show_time";
    private String e = "frequency_show_count";

    public static FrequencyUtils getInstance() {
        if (a == null) {
            a = new FrequencyUtils();
        }
        return a;
    }

    public void saveFrequency(Context context, ConfigResponse.FrequencyBean frequencyBean, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        PushCenter.getInstance().saveMessageToLocal(this.b + string, frequencyBean, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void saveFrequencyLoadTime(Context context, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        long l2 = this.getFrequencyLoadTime(context, string, n2);
        long l3 = System.currentTimeMillis();
        ConfigResponse.FrequencyBean frequencyBean = this.getFrequencyInfo(context, string, n2);
        LogUtil.ownShow("getFrequencyInfo : " + frequencyBean, "tradplus frequency");
        if (frequencyBean == null) {
            return;
        }
        if ((l3 - l2) / 1000L / 60L > (long)frequencyBean.getTime()) {
            LogUtil.ownShow("getFrequencyInfo.getTime() : " + frequencyBean.getTime(), "tradplus frequency");
            PushCenter.getInstance().saveMessageToLocal(this.c + string, System.currentTimeMillis(), PushMessageUtils.Type.EV_TRADPLUS.getValue());
            this.saveFrequencyShowCount(context, 0, string, n2);
        }
    }

    public void saveFrequencyLoadTime(Context context, long l2, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)ACache.get(context, n2).getAsString(this.c))) {
            PushCenter.getInstance().saveMessageToLocal(this.c + string, l2, PushMessageUtils.Type.EV_TRADPLUS.getValue());
        }
    }

    public void stillSaveFrequencyLoadTime(Context context, long l2, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        PushCenter.getInstance().saveMessageToLocal(this.c + string, l2, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void saveFrequencyShowTime(Context context, long l2, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return;
        }
        PushCenter.getInstance().saveMessageToLocal(this.d + string, l2, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public void saveFrequencyShowCount(Context context, int n2, String string, int n3) {
        if (ACache.get(context, n3) == null) {
            return;
        }
        PushCenter.getInstance().saveMessageToLocal(this.e + string, n2, PushMessageUtils.Type.EV_TRADPLUS.getValue());
    }

    public int getFrequencyShowCount(Context context, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return 0;
        }
        Object object = ACache.get(context, n2).getAsObject(this.e + string);
        if (object == null) {
            return 0;
        }
        return (Integer)object;
    }

    public long getFrequencyLoadTime(Context context, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return 0L;
        }
        Object object = ACache.get(context, n2).getAsObject(this.c + string);
        if (object == null) {
            return 0L;
        }
        return (Long)object;
    }

    public void clear(Context context, String string, int n2) {
        this.saveFrequencyLoadTime(context, 0L, string, n2);
        this.saveFrequencyShowCount(context, 0, string, n2);
    }

    public ConfigResponse.FrequencyBean getFrequencyInfo(Context context, String string, int n2) {
        if (ACache.get(context, n2) == null) {
            return null;
        }
        Object object = null;
        object = ACache.get(context, n2).getAsObject(this.b + string);
        if (object == null) {
            return null;
        }
        LogUtil.ownShow("frequencyInfo : " + object, "tradplus frequency");
        return (ConfigResponse.FrequencyBean)object;
    }

    public boolean needFrequencyShow(Context context, String string, int n2) {
        ConfigResponse.FrequencyBean frequencyBean = this.getFrequencyInfo(context, string, n2);
        long l2 = this.getFrequencyLoadTime(context, string, n2);
        long l3 = System.currentTimeMillis();
        int n3 = this.getFrequencyShowCount(context, string, n2);
        if (frequencyBean == null) {
            return true;
        }
        if (frequencyBean.getLimit() == -1) {
            return true;
        }
        if (frequencyBean.getTime() == -1) {
            return true;
        }
        Log.d((String)"tradplus refresh", (String)("Limit : " + frequencyBean.getLimit() + ", showCount : " + n3));
        if ((l3 - l2) / 1000L / 60L >= (long)frequencyBean.getTime()) {
            this.stillSaveFrequencyLoadTime(context, l3, string, n2);
            this.saveFrequencyShowCount(context, 0, string, n2);
            return true;
        }
        return frequencyBean.getLimit() > n3;
    }
}

