/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import androidx.annotation.Nullable;
import com.tradplus.ads.common.util.ResponseHeader;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class HeaderUtils {
    @Nullable
    public static String extractHeader(Map<String, String> map, ResponseHeader responseHeader) {
        return map.get(responseHeader.getKey());
    }

    public static Integer extractIntegerHeader(Map<String, String> map, ResponseHeader responseHeader) {
        return HeaderUtils.a(HeaderUtils.extractHeader(map, responseHeader));
    }

    public static boolean extractBooleanHeader(Map<String, String> map, ResponseHeader responseHeader, boolean bl) {
        return HeaderUtils.a(HeaderUtils.extractHeader(map, responseHeader), bl);
    }

    public static Integer extractPercentHeader(Map<String, String> map, ResponseHeader responseHeader) {
        return HeaderUtils.b(HeaderUtils.extractHeader(map, responseHeader));
    }

    @Nullable
    public static String extractPercentHeaderString(Map<String, String> map, ResponseHeader responseHeader) {
        Integer n2 = HeaderUtils.extractPercentHeader(map, responseHeader);
        return n2 != null ? n2.toString() : null;
    }

    public static String extractHeader(HttpResponse httpResponse, ResponseHeader responseHeader) {
        Header header = httpResponse.getFirstHeader(responseHeader.getKey());
        return header != null ? header.getValue() : null;
    }

    public static boolean extractBooleanHeader(HttpResponse httpResponse, ResponseHeader responseHeader, boolean bl) {
        return HeaderUtils.a(HeaderUtils.extractHeader(httpResponse, responseHeader), bl);
    }

    public static Integer extractIntegerHeader(HttpResponse httpResponse, ResponseHeader responseHeader) {
        String string = HeaderUtils.extractHeader(httpResponse, responseHeader);
        return HeaderUtils.a(string);
    }

    public static int extractIntHeader(HttpResponse httpResponse, ResponseHeader responseHeader, int n2) {
        Integer n3 = HeaderUtils.extractIntegerHeader(httpResponse, responseHeader);
        if (n3 == null) {
            return n2;
        }
        return n3;
    }

    private static boolean a(@Nullable String string, boolean bl) {
        if (string == null) {
            return bl;
        }
        return string.equals("1");
    }

    private static Integer a(String string) {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setParseIntegerOnly(true);
        try {
            Number number = numberFormat.parse(string.trim());
            return number.intValue();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Nullable
    private static Integer b(@Nullable String string) {
        if (string == null) {
            return null;
        }
        Integer n2 = HeaderUtils.a(string.replace("%", ""));
        if (n2 == null || n2 < 0 || n2 > 100) {
            return null;
        }
        return n2;
    }
}

