/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.network.CustomSSLSocketFactory;
import com.tradplus.ads.network.MaxWidthImageLoader;
import com.tradplus.ads.network.PlayServicesUrlRewriter;
import com.tradplus.ads.network.RequestQueueHttpStack;
import com.tradplus.ads.network.TPRequestQueue;
import com.tradplus.ads.volley.toolbox.BasicNetwork;
import com.tradplus.ads.volley.toolbox.DiskBasedCache;
import com.tradplus.ads.volley.toolbox.ImageLoader;
import java.io.File;

public class Networking {
    private static final String a = System.getProperty("http.agent");
    private static volatile TPRequestQueue b;
    private static volatile String c;
    private static volatile MaxWidthImageLoader d;
    private static boolean e;

    @Nullable
    public static TPRequestQueue getRequestQueue() {
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static TPRequestQueue getRequestQueue(@NonNull Context context) {
        TPRequestQueue tPRequestQueue = b;
        if (tPRequestQueue != null) return tPRequestQueue;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            tPRequestQueue = b;
            if (tPRequestQueue != null) return tPRequestQueue;
            ClientMetadata clientMetadata = ClientMetadata.getInstance(context);
            PlayServicesUrlRewriter playServicesUrlRewriter = new PlayServicesUrlRewriter(clientMetadata.getDeviceId(), context);
            CustomSSLSocketFactory customSSLSocketFactory = CustomSSLSocketFactory.getDefault(10000);
            String string = Networking.getUserAgent(context.getApplicationContext());
            RequestQueueHttpStack requestQueueHttpStack = new RequestQueueHttpStack(string, playServicesUrlRewriter, customSSLSocketFactory);
            BasicNetwork basicNetwork = new BasicNetwork(requestQueueHttpStack);
            if (context.getApplicationContext().getCacheDir() == null) return tPRequestQueue;
            File file = new File(context.getApplicationContext().getCacheDir().getPath() + File.separator + "flute-volley-cache");
            DiskBasedCache diskBasedCache = new DiskBasedCache(file, (int)DeviceUtils.diskCacheSizeBytes(file, 0xA00000L));
            b = tPRequestQueue = new TPRequestQueue(diskBasedCache, basicNetwork);
            tPRequestQueue.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tPRequestQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static ImageLoader getImageLoader(@NonNull Context context) {
        MaxWidthImageLoader maxWidthImageLoader = d;
        if (maxWidthImageLoader != null) return maxWidthImageLoader;
        Class<Networking> clazz = Networking.class;
        synchronized (Networking.class) {
            maxWidthImageLoader = d;
            if (maxWidthImageLoader != null) return maxWidthImageLoader;
            TPRequestQueue tPRequestQueue = Networking.getRequestQueue(context);
            int n2 = DeviceUtils.memoryCacheSizeBytes(context);
            LruCache<String, Bitmap> lruCache = new LruCache<String, Bitmap>(n2){

                protected int a(String string, Bitmap bitmap) {
                    if (bitmap != null) {
                        return bitmap.getRowBytes() * bitmap.getHeight();
                    }
                    return super.sizeOf((Object)string, (Object)bitmap);
                }

                protected /* synthetic */ int sizeOf(Object object, Object object2) {
                    return this.a((String)object, (Bitmap)object2);
                }
            };
            d = maxWidthImageLoader = new MaxWidthImageLoader(tPRequestQueue, context, new ImageLoader.ImageCache((LruCache)lruCache){
                final /* synthetic */ LruCache a;
                {
                    this.a = lruCache;
                }

                @Override
                public Bitmap getBitmap(String string) {
                    return (Bitmap)this.a.get((Object)string);
                }

                @Override
                public void putBitmap(String string, Bitmap bitmap) {
                    this.a.put((Object)string, (Object)bitmap);
                }
            });
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return maxWidthImageLoader;
        }
    }

    @NonNull
    public static String getUserAgent(@NonNull Context context) {
        Preconditions.checkNotNull(context);
        String string = "";
        return string;
    }

    @NonNull
    public static String getCachedUserAgent() {
        String string = c;
        if (string == null) {
            return a;
        }
        return string;
    }

    @VisibleForTesting
    public static synchronized void clearForTesting() {
        b = null;
        d = null;
        c = null;
    }

    @VisibleForTesting
    public static synchronized void setRequestQueueForTesting(TPRequestQueue tPRequestQueue) {
        b = tPRequestQueue;
    }

    @VisibleForTesting
    public static synchronized void setImageLoaderForTesting(MaxWidthImageLoader maxWidthImageLoader) {
        d = maxWidthImageLoader;
    }

    @VisibleForTesting
    public static synchronized void setUserAgentForTesting(String string) {
        c = string;
    }

    public static void useHttps(boolean bl) {
        e = bl;
    }

    public static boolean useHttps() {
        return e;
    }

    public static String getScheme() {
        return Networking.useHttps() ? "https" : "http";
    }

    public static String getBaseUrlScheme() {
        return "http";
    }

    static {
        e = false;
    }
}

