/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network.util;

import com.tradplus.ads.common.task.TPWorker;
import com.tradplus.ads.common.util.LogUtil;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Map;
import org.apache.http.conn.ConnectTimeoutException;

public abstract class ResourceDownloadBaseUrlLoader {
    private final String TAG = this.getClass().getSimpleName();
    protected String mURL;
    protected boolean mIsStop;
    protected long downloadStartTime;
    protected long downloadEndTime;
    protected long downloadSize;

    public ResourceDownloadBaseUrlLoader(String string) {
        this.mURL = string;
    }

    public void start() {
        this.mIsStop = false;
        this.load();
    }

    public void stop() {
        this.mIsStop = true;
    }

    protected abstract Map<String, String> onPrepareHeaders();

    protected abstract void onErrorAgent(String var1, String var2);

    private void load() {
        TPWorker tPWorker = new TPWorker(){

            @Override
            public void work() {
                try {
                    this.a(ResourceDownloadBaseUrlLoader.this.mURL);
                }
                catch (OutOfMemoryError | StackOverflowError virtualMachineError) {
                    System.gc();
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", virtualMachineError.getMessage());
                }
                catch (Exception exception) {
                    LogUtil.ownShow(exception.getMessage());
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", exception.getMessage());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            private void a(String string) {
                ResourceDownloadBaseUrlLoader.this.downloadStartTime = System.currentTimeMillis();
                HttpURLConnection httpURLConnection = null;
                try {
                    LogUtil.ownShow("REQUEST URL: " + string);
                    URL uRL = new URL(string);
                    httpURLConnection = (HttpURLConnection)uRL.openConnection();
                    httpURLConnection.setInstanceFollowRedirects(false);
                    Map<String, String> map = ResourceDownloadBaseUrlLoader.this.onPrepareHeaders();
                    if (map != null && map.size() > 0) {
                        for (String object2 : map.keySet()) {
                            httpURLConnection.addRequestProperty(object2, map.get(object2));
                            LogUtil.ownShow("REQUEST ADDED HEADER: \n" + object2 + "  :  " + map.get(object2));
                        }
                    }
                    if (ResourceDownloadBaseUrlLoader.this.mIsStop) {
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10001", "Task had been canceled.");
                        return;
                    }
                    httpURLConnection.setConnectTimeout(ResourceDownloadBaseUrlLoader.this.getConnectTimeout());
                    httpURLConnection.connect();
                    int n2 = httpURLConnection.getResponseCode();
                    if (n2 != 200) {
                        LogUtil.ownShow("http respond status code is " + n2 + " ! url=" + string);
                        if (n2 == 302) {
                            if (!ResourceDownloadBaseUrlLoader.this.mIsStop) {
                                String string2 = httpURLConnection.getHeaderField("Location");
                                if (string2 != null) {
                                    void var6_16;
                                    if (!string2.startsWith("http")) {
                                        String string3 = string + string2;
                                    }
                                    this.a((String)var6_16);
                                }
                            } else {
                                ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10001", "Task had been canceled.");
                            }
                            return;
                        }
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", httpURLConnection.getResponseMessage());
                        return;
                    }
                    if (ResourceDownloadBaseUrlLoader.this.mIsStop) {
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10001", "Task had been canceled.");
                        return;
                    }
                    ResourceDownloadBaseUrlLoader.this.downloadSize = httpURLConnection.getContentLength();
                    InputStream inputStream = httpURLConnection.getInputStream();
                    boolean bl = ResourceDownloadBaseUrlLoader.this.saveHttpResource(inputStream);
                    LogUtil.ownShow("save_success = " + bl);
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    ResourceDownloadBaseUrlLoader.this.downloadEndTime = System.currentTimeMillis();
                    if (bl) {
                        LogUtil.ownShow("download success --> " + ResourceDownloadBaseUrlLoader.this.mURL);
                        ResourceDownloadBaseUrlLoader.this.onLoadFinishCallback();
                    } else {
                        LogUtil.ownShow("download fail --> " + ResourceDownloadBaseUrlLoader.this.mURL);
                        ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", "Save fail!");
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", socketTimeoutException.getMessage());
                    LogUtil.ownShow(socketTimeoutException.toString());
                }
                catch (ConnectTimeoutException connectTimeoutException) {
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", connectTimeoutException.getMessage());
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    System.gc();
                    LogUtil.ownShow(outOfMemoryError.getMessage());
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", outOfMemoryError.getMessage());
                }
                catch (StackOverflowError stackOverflowError) {
                    System.gc();
                    LogUtil.ownShow(stackOverflowError.getMessage());
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", stackOverflowError.getMessage());
                }
                catch (Error error) {
                    System.gc();
                    LogUtil.ownShow(error.getMessage());
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", error.getMessage());
                }
                catch (Exception exception) {
                    LogUtil.ownShow(exception.getMessage());
                    ResourceDownloadBaseUrlLoader.this.onLoadFailedCallback("-10000", exception.getMessage());
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
        };
        this.startWorker(tPWorker);
    }

    protected int getConnectTimeout() {
        return 60000;
    }

    protected int getReadTimeout() {
        return 20000;
    }

    protected abstract boolean saveHttpResource(InputStream var1);

    protected abstract void startWorker(TPWorker var1);

    protected abstract void onLoadFinishCallback();

    protected abstract void onLoadFailedCallback(String var1, String var2);
}

