/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.pushcenter.http;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.e;
import com.tradplus.ads.mobileads.util.TradPlusDataConstants;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.TPRequestQueue;
import com.tradplus.ads.pushcenter.PushCenter;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.http.MessageRequest;
import com.tradplus.ads.pushcenter.http.TrackUrlRequest;
import com.tradplus.ads.pushcenter.response.BaseResponse;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import com.tradplus.ads.volley.VolleyError;
import org.json.JSONArray;

public class PushCenterHttpUtils {
    private String a = "https://api.tradplusad.com/api/v1_2/ev";
    private String b = "https://" + (TradPlus.getLocalDebugMode() ? "test-crosspro-track.tradplusad.com" : "crosspro-track.tradplusad.com") + "/ev";
    private Context c;
    private boolean d;
    private OnPushStatusListener e;

    public String getPushUrlfromType(int n2) {
        if (n2 == TradPlusDataConstants.CACHETRADPLUSTYPE) {
            String string = TextUtils.isEmpty((CharSequence)RequestUtils.getInstance().getEV(this.c, n2)) ? this.a : RequestUtils.getInstance().getEV(this.c, n2);
            return string;
        }
        if (n2 == TradPlusDataConstants.CACHETYPE) {
            return this.b;
        }
        return "";
    }

    public void push(Context context, final JSONArray jSONArray, final int n2) {
        if (jSONArray.length() > 0) {
            LogUtil.ownShow("dataBody length = " + jSONArray.length());
            this.c = context;
            String string = this.getPushUrlfromType(n2);
            LogUtil.ownShow(string, PushMessageUtils.getInstance().getCacheType(n2) + ": Push Data To Service");
            LogUtil.ownShow("push body = " + jSONArray.toString(), PushMessageUtils.getInstance().getCacheType(n2));
            MessageRequest messageRequest = new MessageRequest(string, jSONArray.toString(), new MessageRequest.Listener(){

                @Override
                public void onResponse(BaseResponse baseResponse) {
                    LogUtil.ownShow("getStatusCode = " + baseResponse.getStatusCode(), PushMessageUtils.getInstance().getCacheType(n2));
                }

                @Override
                public void onErrorResponse(VolleyError volleyError) {
                    LogUtil.ownShow("push failed", PushMessageUtils.getInstance().getCacheType(n2));
                    PushCenter.getInstance().sendMessageToCenter(PushCenterHttpUtils.this.c, jSONArray, n2);
                }
            });
            TPRequestQueue tPRequestQueue = Networking.getRequestQueue(this.c);
            if (tPRequestQueue != null) {
                tPRequestQueue.add(messageRequest);
            }
        }
    }

    public void pushGroupMessage(Context context, final JSONArray jSONArray, final int n2) {
        if (this.canAddNewMessageToPush()) {
            this.d = true;
            final int n3 = jSONArray.length();
            if (n3 > 0) {
                LogUtil.ownShow("group dataBody length = " + jSONArray.length());
                this.c = context;
                String string = this.getPushUrlfromType(n2);
                LogUtil.ownShow(string, PushMessageUtils.getInstance().getCacheType(n2) + ": group Push Data To Service");
                LogUtil.ownShow("group push body = " + jSONArray.toString(), PushMessageUtils.getInstance().getCacheType(n2));
                MessageRequest messageRequest = new MessageRequest(string, jSONArray.toString(), new MessageRequest.Listener(){

                    @Override
                    public void onResponse(BaseResponse baseResponse) {
                        PushCenterHttpUtils.this.d = false;
                        LogUtil.ownShow("group getStatusCode = " + baseResponse.getStatusCode(), PushMessageUtils.getInstance().getCacheType(n2));
                        if (PushCenterHttpUtils.this.e != null && n3 == 100) {
                            PushCenterHttpUtils.this.e.onPushEnd();
                        }
                    }

                    @Override
                    public void onErrorResponse(VolleyError volleyError) {
                        LogUtil.ownShow("group push failed", PushMessageUtils.getInstance().getCacheType(n2));
                        PushCenter.getInstance().sendGroupMessageToCenter(PushCenterHttpUtils.this.c, jSONArray, n2);
                        PushCenterHttpUtils.this.d = false;
                    }
                });
                TPRequestQueue tPRequestQueue = Networking.getRequestQueue(this.c);
                if (tPRequestQueue != null) {
                    tPRequestQueue.add(messageRequest);
                }
            }
        }
    }

    public void pushTrackMessage(final Context context, final String string, final EventShowEndRequest eventShowEndRequest) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            LogUtil.ownShow("pushTrackMessage url=" + string);
            LogUtil.ownShow("pushTrackMessage eventShowEndRequest=" + eventShowEndRequest);
            if (eventShowEndRequest == null) {
                return;
            }
            LogUtil.ownShow("pushTrackMessage eventShowEndRequest event.getSuuid()=" + string + "@" + eventShowEndRequest.getSuuid());
            PushCenter.getInstance().removeTrackUrls(context, string + "@" + eventShowEndRequest.getSuuid());
            this.c = context;
            TrackUrlRequest trackUrlRequest = new TrackUrlRequest(string, new TrackUrlRequest.Listener(){

                @Override
                public void onSuccess(BaseResponse baseResponse) {
                    PushCenterHttpUtils.this.d = false;
                    LogUtil.ownShow("pushTrackMessage getStatusCode = " + baseResponse.getStatusCode());
                    LogUtil.ownShow("pushTrackMessage url = " + string);
                    eventShowEndRequest.setError_code("1");
                    PushCenter.getInstance().sendMessageToCenter(PushCenterHttpUtils.this.c, eventShowEndRequest, TradPlusDataConstants.CACHETYPE);
                    EventShowEndRequest eventShowEndRequest2 = RequestUtils.getInstance().getTrackMessage(context, string + "@" + eventShowEndRequest.getSuuid());
                    if (eventShowEndRequest2 != null) {
                        PushCenter.getInstance().removeTrackMessage(context, string + "@" + eventShowEndRequest.getSuuid());
                        PushCenter.getInstance().removeTrackUrls(context, string + "@" + eventShowEndRequest.getSuuid());
                    }
                }

                @Override
                public void onErrorResponse(VolleyError volleyError) {
                    LogUtil.ownShow("pushTrackMessage failed");
                    TradPlusErrorCode tradPlusErrorCode = com.tradplus.ads.mobileads.e.a(volleyError, context);
                    EventShowEndRequest eventShowEndRequest2 = RequestUtils.getInstance().getTrackMessage(context, string + "@" + eventShowEndRequest.getSuuid());
                    PushCenter.getInstance().setTrackUrls(context, string + "@" + eventShowEndRequest.getSuuid());
                    if (eventShowEndRequest2 != null) {
                        if (eventShowEndRequest2.getTrack_count() > 3) {
                            LogUtil.ownShow("pushTrackMessage getTrack_count = " + eventShowEndRequest2.getTrack_count());
                            if (tradPlusErrorCode == TradPlusErrorCode.NO_CONNECTION) {
                                eventShowEndRequest2.setError_code("7");
                            } else if (tradPlusErrorCode == TradPlusErrorCode.NETWORK_TIMEOUT) {
                                eventShowEndRequest2.setError_code("3");
                            } else if (volleyError.networkResponse != null) {
                                eventShowEndRequest2.setError_code(volleyError.networkResponse.statusCode + "");
                            } else {
                                eventShowEndRequest2.setError_code("2");
                            }
                            PushCenter.getInstance().sendMessageToCenter(PushCenterHttpUtils.this.c, eventShowEndRequest2, TradPlusDataConstants.CACHETYPE);
                            PushCenter.getInstance().removeTrackMessage(context, string + "@" + eventShowEndRequest2.getSuuid());
                            PushCenter.getInstance().removeTrackUrls(context, string + "@" + eventShowEndRequest2.getSuuid());
                        } else {
                            eventShowEndRequest2.setTrack_count(eventShowEndRequest2.getTrack_count() + 1);
                            LogUtil.ownShow("pushTrackMessage getTrack_count = " + eventShowEndRequest2.getTrack_count());
                            PushCenter.getInstance().setTrackMessage(context, string + "@" + eventShowEndRequest2.getSuuid(), eventShowEndRequest2);
                        }
                    } else {
                        LogUtil.ownShow("pushTrackMessage new track message");
                        PushCenter.getInstance().setTrackMessage(context, string + "@" + eventShowEndRequest.getSuuid(), eventShowEndRequest);
                    }
                }
            });
            TPRequestQueue tPRequestQueue = Networking.getRequestQueue(this.c);
            if (tPRequestQueue != null) {
                tPRequestQueue.add(trackUrlRequest);
            }
        }
    }

    public OnPushStatusListener getOnPushStatusListener() {
        return this.e;
    }

    public void setOnPushStatusListener(OnPushStatusListener onPushStatusListener) {
        this.e = onPushStatusListener;
    }

    public boolean canAddNewMessageToPush() {
        return !this.d;
    }

    public boolean isUploading() {
        return this.d;
    }

    public void setUploading(boolean bl) {
        this.d = bl;
    }

    public static interface OnPushStatusListener {
        public void onPushEnd();
    }
}

