/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley.toolbox;

import android.os.SystemClock;
import com.tradplus.ads.volley.AuthFailureError;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.Network;
import com.tradplus.ads.volley.NetworkError;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.NoConnectionError;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.RetryPolicy;
import com.tradplus.ads.volley.ServerError;
import com.tradplus.ads.volley.TimeoutError;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.VolleyLog;
import com.tradplus.ads.volley.toolbox.ByteArrayPool;
import com.tradplus.ads.volley.toolbox.HttpStack;
import com.tradplus.ads.volley.toolbox.PoolingByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.cookie.DateUtils;

public class BasicNetwork
implements Network {
    protected static final boolean a = VolleyLog.DEBUG;
    private static int d = 3000;
    private static int e = 4096;
    protected final HttpStack b;
    protected final ByteArrayPool c;

    public BasicNetwork(HttpStack httpStack) {
        this(httpStack, new ByteArrayPool(e));
    }

    public BasicNetwork(HttpStack httpStack, ByteArrayPool byteArrayPool) {
        this.b = httpStack;
        this.c = byteArrayPool;
    }

    @Override
    public NetworkResponse performRequest(Request<?> request) {
        long l2 = SystemClock.elapsedRealtime();
        while (true) {
            HttpResponse httpResponse = null;
            byte[] byArray = null;
            Map<String, String> map = Collections.emptyMap();
            try {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                this.a(hashMap, request.getCacheEntry());
                httpResponse = this.b.performRequest(request, hashMap);
                StatusLine statusLine = httpResponse.getStatusLine();
                int n2 = statusLine.getStatusCode();
                map = BasicNetwork.a(httpResponse.getAllHeaders());
                if (n2 == 304) {
                    Cache.Entry entry = request.getCacheEntry();
                    if (entry == null) {
                        return new NetworkResponse(304, null, map, true, SystemClock.elapsedRealtime() - l2);
                    }
                    entry.responseHeaders.putAll(map);
                    return new NetworkResponse(304, entry.data, entry.responseHeaders, true, SystemClock.elapsedRealtime() - l2);
                }
                byArray = httpResponse.getEntity() != null ? this.a(httpResponse.getEntity()) : new byte[]{};
                long l3 = SystemClock.elapsedRealtime() - l2;
                this.a(l3, request, byArray, statusLine);
                if (n2 < 200 || n2 > 299) {
                    throw new IOException();
                }
                return new NetworkResponse(n2, byArray, map, false, SystemClock.elapsedRealtime() - l2);
            }
            catch (SocketTimeoutException socketTimeoutException) {
                BasicNetwork.a("socket", request, new TimeoutError());
                continue;
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                BasicNetwork.a("connection", request, new TimeoutError());
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException("Bad URL " + request.getUrl(), malformedURLException);
            }
            catch (IOException iOException) {
                int n3 = 0;
                NetworkResponse networkResponse = null;
                if (httpResponse == null) {
                    throw new NoConnectionError(iOException);
                }
                n3 = httpResponse.getStatusLine().getStatusCode();
                VolleyLog.e("Unexpected response code %d for %s", n3, request.getUrl());
                if (byArray != null) {
                    networkResponse = new NetworkResponse(n3, byArray, map, false, SystemClock.elapsedRealtime() - l2);
                    if (n3 == 401 || n3 == 403) {
                        BasicNetwork.a("auth", request, new AuthFailureError(networkResponse));
                        continue;
                    }
                    throw new ServerError(networkResponse);
                }
                throw new NetworkError(networkResponse);
            }
            break;
        }
    }

    private void a(long l2, Request<?> request, byte[] byArray, StatusLine statusLine) {
        if (a || l2 > (long)d) {
            VolleyLog.d("HTTP response for request=<%s> [lifetime=%d], [size=%s], [rc=%d], [retryCount=%s]", request, l2, byArray != null ? Integer.valueOf(byArray.length) : "null", statusLine.getStatusCode(), request.getRetryPolicy().getCurrentRetryCount());
        }
    }

    private static void a(String string, Request<?> request, VolleyError volleyError) {
        RetryPolicy retryPolicy = request.getRetryPolicy();
        int n2 = request.getTimeoutMs();
        try {
            retryPolicy.retry(volleyError);
        }
        catch (VolleyError volleyError2) {
            request.addMarker(String.format("%s-timeout-giveup [timeout=%s]", string, n2));
            throw volleyError2;
        }
        request.addMarker(String.format("%s-retry [timeout=%s]", string, n2));
    }

    private void a(Map<String, String> map, Cache.Entry entry) {
        if (entry == null) {
            return;
        }
        if (entry.etag != null) {
            map.put("If-None-Match", entry.etag);
        }
        if (entry.serverDate > 0L) {
            Date date = new Date(entry.serverDate);
            map.put("If-Modified-Since", DateUtils.formatDate((Date)date));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] a(HttpEntity httpEntity) {
        PoolingByteArrayOutputStream poolingByteArrayOutputStream = new PoolingByteArrayOutputStream(this.c, (int)httpEntity.getContentLength());
        byte[] byArray = null;
        try {
            int n2;
            InputStream inputStream = httpEntity.getContent();
            if (inputStream == null) {
                throw new ServerError();
            }
            byArray = this.c.getBuf(1024);
            while ((n2 = inputStream.read(byArray)) != -1) {
                poolingByteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = poolingByteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            try {
                httpEntity.consumeContent();
            }
            catch (IOException iOException) {
                VolleyLog.v("Error occured when calling consumingContent", new Object[0]);
            }
            this.c.returnBuf(byArray);
            poolingByteArrayOutputStream.close();
        }
    }

    protected static Map<String, String> a(Header[] headerArray) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int i2 = 0; i2 < headerArray.length; ++i2) {
            treeMap.put(headerArray[i2].getName(), headerArray[i2].getValue());
        }
        return treeMap;
    }
}

